/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.capabilities.CapabilityDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

@WailaPlugin(value="storagedrawers")
public class Waila
implements IWailaPlugin {
    public void register(IRegistrar registrar) {
        this.registerProvider(registrar);
    }

    private void registerProvider(IRegistrar registrar) {
        WailaDrawer provider = new WailaDrawer();
        registrar.addConfig(new ResourceLocation("storagedrawers", "display.content"), true);
        registrar.addConfig(new ResourceLocation("storagedrawers", "display.stacklimit"), true);
        registrar.addConfig(new ResourceLocation("storagedrawers", "display.status"), true);
        registrar.registerComponentProvider((IComponentProvider)provider, TooltipPosition.BODY, BlockDrawers.class);
    }

    public static class WailaDrawer
    implements IComponentProvider {
        @Nonnull
        public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
            return new ItemStack((IItemProvider)accessor.getBlock(), 1);
        }

        public void appendBody(List<ITextComponent> currenttip, IDataAccessor accessor, IPluginConfig config) {
            TileEntityDrawers tile = (TileEntityDrawers)accessor.getTileEntity();
            IDrawerAttributes attr = (IDrawerAttributes)tile.getCapability(CapabilityDrawerAttributes.DRAWER_ATTRIBUTES_CAPABILITY, null).orElse((Object)EmptyDrawerAttributes.EMPTY);
            if (config.get(new ResourceLocation("storagedrawers", "display.content"))) {
                for (int i = 0; i < tile.getDrawerCount(); ++i) {
                    IDrawer drawer = tile.getDrawer(i);
                    if (!drawer.isEnabled()) continue;
                    TranslationTextComponent name = new TranslationTextComponent("tooltip.storagedrawers.waila.empty", new Object[0]);
                    ItemStack stack = drawer.getStoredItemPrototype();
                    if (!stack.func_190926_b()) {
                        ITextComponent stackName = stack.func_200301_q();
                        if (drawer.getStoredItemCount() == Integer.MAX_VALUE) {
                            name = stackName.func_150258_a("[\u221e]");
                        } else if (drawer instanceof IFractionalDrawer && ((IFractionalDrawer)drawer).getConversionRate() > 1) {
                            name = stackName.func_150258_a((i == 0 ? " [" : " [+") + ((IFractionalDrawer)drawer).getStoredItemRemainder() + "]");
                        } else if (((Boolean)CommonConfig.INTEGRATION.wailaStackRemainder.get()).booleanValue()) {
                            int stacks = drawer.getStoredItemCount() / drawer.getStoredItemStackSize();
                            int remainder = drawer.getStoredItemCount() - stacks * drawer.getStoredItemStackSize();
                            name = stacks > 0 && remainder > 0 ? stackName.func_150258_a(" [" + stacks + "x" + drawer.getStoredItemStackSize() + " + " + remainder + "]") : (stacks > 0 ? stackName.func_150258_a(" [" + stacks + "x" + drawer.getStoredItemStackSize() + "]") : stackName.func_150258_a(" [" + remainder + "]"));
                        } else {
                            name = stackName.func_150258_a(" [" + drawer.getStoredItemCount() + "]");
                        }
                    }
                    currenttip.add((ITextComponent)new TranslationTextComponent("tooltip.storagedrawers.waila.drawer", new Object[]{i + 1, name}));
                }
            }
            if (config.get(new ResourceLocation("storagedrawers", "display.stacklimit"))) {
                if (tile.getDrawerAttributes().isUnlimitedStorage() || tile.getDrawerAttributes().isUnlimitedVending()) {
                    currenttip.add((ITextComponent)new TranslationTextComponent("tooltip.storagedrawers.waila.nolimit", new Object[0]));
                } else {
                    int multiplier = tile.upgrades().getStorageMultiplier();
                    int limit = tile.getEffectiveDrawerCapacity() * multiplier;
                    currenttip.add((ITextComponent)new TranslationTextComponent("tooltip.storagedrawers.waila.limit", new Object[]{limit, multiplier}));
                }
            }
            if (config.get(new ResourceLocation("storagedrawers", "display.status"))) {
                String attrib = "";
                if (attr.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                    attrib = attrib + (attrib.isEmpty() ? "" : ", ") + I18n.func_135052_a((String)"tooltip.storagedrawers.waila.locked", (Object[])new Object[0]);
                }
                if (attr.isVoid()) {
                    attrib = attrib + (attrib.isEmpty() ? "" : ", ") + I18n.func_135052_a((String)"tooltip.storagedrawers.waila.void", (Object[])new Object[0]);
                }
                if (!attrib.isEmpty()) {
                    currenttip.add((ITextComponent)new StringTextComponent(attrib));
                }
            }
        }
    }
}

