/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StorageRenderItem
extends ItemRenderer {
    private ItemRenderer parent = Minecraft.func_71410_x().func_175599_af();
    @Nonnull
    public ItemStack overrideStack = ItemStack.field_190927_a;

    public StorageRenderItem(TextureManager texManager, ModelManager modelManager, ItemColors colors) {
        super(texManager, modelManager, colors);
    }

    public ItemModelMesher func_175037_a() {
        return this.parent.func_175037_a();
    }

    public void func_180454_a(@Nonnull ItemStack stack, IBakedModel model) {
        this.parent.func_180454_a(stack, model);
    }

    public boolean func_175050_a(@Nonnull ItemStack stack) {
        return this.parent.func_175050_a(stack);
    }

    public void func_181564_a(@Nonnull ItemStack stack, ItemCameraTransforms.TransformType transformType) {
        this.parent.func_181564_a(stack, transformType);
    }

    public void func_184392_a(@Nonnull ItemStack stack, LivingEntity entity, ItemCameraTransforms.TransformType transform, boolean flag) {
        this.parent.func_184392_a(stack, entity, transform, flag);
    }

    public IBakedModel func_184393_a(@Nonnull ItemStack stack, World world, LivingEntity entity) {
        return this.parent.func_184393_a(stack, world, entity);
    }

    public void func_175042_a(@Nonnull ItemStack stack, int x, int y) {
        this.parent.func_175042_a(stack, x, y);
    }

    public void func_180450_b(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        this.parent.func_180450_b(stack, xPosition, yPosition);
    }

    public void func_175030_a(FontRenderer fr, @Nonnull ItemStack stack, int xPosition, int yPosition) {
        this.parent.func_175030_a(fr, stack, xPosition, yPosition);
    }

    public void func_180453_a(FontRenderer font, @Nonnull ItemStack item, int x, int y, String text) {
        if (item != this.overrideStack) {
            super.func_180453_a(font, item, x, y, text);
            return;
        }
        if (!(item = ItemStackHelper.decodeItemStack(item)).func_190926_b()) {
            float scale = 0.5f;
            float xoff = 0.0f;
            int stackSize = item.func_190916_E();
            if (ItemStackHelper.isStackEncoded(item)) {
                stackSize = 0;
            }
            if (stackSize >= 0 || text != null) {
                text = stackSize >= 100000000 ? (text == null ? String.format("%.0fM", Float.valueOf((float)stackSize / 1000000.0f)) : text) : (stackSize >= 1000000 ? (text == null ? String.format("%.1fM", Float.valueOf((float)stackSize / 1000000.0f)) : text) : (stackSize >= 100000 ? (text == null ? String.format("%.0fK", Float.valueOf((float)stackSize / 1000.0f)) : text) : (stackSize >= 10000 ? (text == null ? String.format("%.1fK", Float.valueOf((float)stackSize / 1000.0f)) : text) : (text == null ? String.valueOf(stackSize) : text))));
                int textX = (int)(((float)(x + 16) + xoff - (float)font.func_78256_a(text) * scale) / scale) - 1;
                int textY = (int)(((float)(y + 16) - 7.0f * scale) / scale) - 1;
                GlStateManager.disableLighting();
                GlStateManager.disableDepthTest();
                GlStateManager.disableBlend();
                GlStateManager.pushMatrix();
                GlStateManager.scalef((float)scale, (float)scale, (float)scale);
                if (stackSize > 0) {
                    font.func_175063_a(text, (float)textX, (float)textY, 0xFFFFFF);
                } else {
                    font.func_175063_a(text, (float)textX, (float)textY, 0xFF6060);
                }
                GlStateManager.popMatrix();
                GlStateManager.enableBlend();
                GlStateManager.enableLighting();
                GlStateManager.enableDepthTest();
            }
            if (item.func_77973_b().showDurabilityBar(item)) {
                double health = item.func_77973_b().getDurabilityForDisplay(item);
                int j1 = (int)Math.round(13.0 - health * 13.0);
                int k = (int)Math.round(255.0 - health * 255.0);
                GlStateManager.disableLighting();
                GlStateManager.disableDepthTest();
                GlStateManager.disableTexture();
                GlStateManager.disableAlphaTest();
                GlStateManager.disableBlend();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder worldrenderer = tessellator.func_178180_c();
                int l = 255 - k << 16 | k << 8;
                int i1 = (255 - k) / 4 << 16 | 0x3F00;
                this.renderQuad(worldrenderer, x + 2, y + 13, 13, 2, 0, 0, 0, 255);
                this.renderQuad(worldrenderer, x + 2, y + 13, 12, 1, (255 - k) / 4, 64, 0, 255);
                this.renderQuad(worldrenderer, x + 2, y + 13, j1, 1, 255 - k, k, 0, 255);
                GlStateManager.enableBlend();
                GlStateManager.enableAlphaTest();
                GlStateManager.enableTexture();
                GlStateManager.enableLighting();
                GlStateManager.enableDepthTest();
            }
        }
    }

    private void renderQuad(BufferBuilder tessellator, int x, int y, int w, int h, int r, int g, int b, int a) {
        tessellator.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        tessellator.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_181669_b(r, g, b, a).func_181675_d();
        tessellator.func_181662_b((double)(x + 0), (double)(y + h), 0.0).func_181669_b(r, g, b, a).func_181675_d();
        tessellator.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_181669_b(r, g, b, a).func_181675_d();
        tessellator.func_181662_b((double)(x + w), (double)(y + 0), 0.0).func_181669_b(r, g, b, a).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

