/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.TileDataShim;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeStatus;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStatus;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.MathHelper;

public class UpgradeData
extends TileDataShim {
    private final ItemStack[] upgrades;
    private int storageMultiplier;
    private EnumUpgradeStatus statusType;
    private EnumUpgradeRedstone redstoneType;
    private boolean hasOneStack;
    private boolean hasVoid;
    private boolean hasUnlimited;
    private boolean hasVending;
    private boolean hasConversion;
    private IDrawerAttributesModifiable attrs;

    public UpgradeData(int slotCount) {
        this.upgrades = new ItemStack[slotCount];
        for (int i = 0; i < this.upgrades.length; ++i) {
            this.upgrades[i] = ItemStack.field_190927_a;
        }
        this.syncStorageMultiplier();
    }

    public void setDrawerAttributes(IDrawerAttributesModifiable attrs) {
        this.attrs = attrs;
        this.syncUpgrades();
    }

    public int getSlotCount() {
        return this.upgrades.length;
    }

    @Nonnull
    public ItemStack getUpgrade(int slot) {
        slot = MathHelper.func_76125_a((int)slot, (int)0, (int)(this.upgrades.length - 1));
        return this.upgrades[slot];
    }

    public boolean addUpgrade(@Nonnull ItemStack upgrade) {
        int slot = this.getNextUpgradeSlot();
        if (slot == -1) {
            return false;
        }
        this.setUpgrade(slot, upgrade);
        return true;
    }

    public boolean setUpgrade(int slot, @Nonnull ItemStack upgrade) {
        ItemStack prevUpgrade;
        slot = MathHelper.func_76125_a((int)slot, (int)0, (int)(this.upgrades.length - 1));
        if (!upgrade.func_190926_b()) {
            upgrade = upgrade.func_77946_l();
            upgrade.func_190920_e(1);
        }
        if (!(prevUpgrade = this.upgrades[slot]).func_190926_b() && !this.canRemoveUpgrade(slot)) {
            return false;
        }
        this.upgrades[slot] = ItemStack.field_190927_a;
        this.syncStorageMultiplier();
        if (!upgrade.func_190926_b() && !this.canAddUpgrade(upgrade)) {
            this.upgrades[slot] = prevUpgrade;
            this.syncStorageMultiplier();
            return false;
        }
        this.upgrades[slot] = upgrade;
        this.syncUpgrades();
        this.onUpgradeChanged(prevUpgrade, upgrade);
        return true;
    }

    public boolean canAddUpgrade(@Nonnull ItemStack upgrade) {
        if (upgrade.func_190926_b()) {
            return false;
        }
        if (!(upgrade.func_77973_b() instanceof ItemUpgrade)) {
            return false;
        }
        ItemUpgrade candidate = (ItemUpgrade)upgrade.func_77973_b();
        if (candidate.getAllowMultiple()) {
            return true;
        }
        for (ItemStack stack : this.upgrades) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemUpgrade)) continue;
            ItemUpgrade reference = (ItemUpgrade)stack.func_77973_b();
            if (candidate.getUpgradeGroup() != reference.getUpgradeGroup()) continue;
            return false;
        }
        return true;
    }

    public boolean canRemoveUpgrade(int slot) {
        return !this.upgrades[slot = MathHelper.func_76125_a((int)slot, (int)0, (int)(this.upgrades.length - 1))].func_190926_b();
    }

    public int getStorageMultiplier() {
        return this.storageMultiplier;
    }

    public EnumUpgradeStatus getStatusType() {
        return this.statusType;
    }

    public EnumUpgradeRedstone getRedstoneType() {
        return this.redstoneType;
    }

    public boolean hasOneStackUpgrade() {
        return this.hasOneStack;
    }

    public boolean hasUnlimitedUpgrade() {
        return this.hasUnlimited;
    }

    public boolean hasVendingUpgrade() {
        return this.hasVending;
    }

    public boolean hasConversionUpgrade() {
        return this.hasConversion;
    }

    private int getNextUpgradeSlot() {
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (!this.upgrades[i].func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    private void syncUpgrades() {
        if (this.attrs == null) {
            return;
        }
        this.syncStorageMultiplier();
        this.syncStatusLevel();
        this.syncRedstoneLevel();
        this.hasOneStack = false;
        this.hasVoid = false;
        this.hasUnlimited = false;
        this.hasVending = false;
        this.hasConversion = false;
        for (ItemStack stack : this.upgrades) {
            Item item = stack.func_77973_b();
            if (item == ModItems.ONE_STACK_UPGRADE) {
                this.hasOneStack = true;
                continue;
            }
            if (item == ModItems.VOID_UPGRADE) {
                this.hasVoid = true;
                continue;
            }
            if (item == ModItems.CONVERSION_UPGRADE) {
                this.hasConversion = true;
                continue;
            }
            if (item == ModItems.CREATIVE_STORAGE_UPGRADE) {
                this.hasUnlimited = true;
                continue;
            }
            if (item != ModItems.CREATIVE_VENDING_UPGRADE) continue;
            this.hasVending = true;
        }
        this.attrs.setIsVoid(this.hasVoid);
        this.attrs.setIsDictConvertible(this.hasConversion);
        this.attrs.setIsUnlimitedStorage(this.hasUnlimited);
        this.attrs.setIsUnlimitedVending(this.hasVending);
    }

    private void syncStorageMultiplier() {
        this.storageMultiplier = 0;
        for (ItemStack stack : this.upgrades) {
            if (!(stack.func_77973_b() instanceof ItemUpgradeStorage)) continue;
            int level = ((ItemUpgradeStorage)stack.func_77973_b()).level.getLevel();
            this.storageMultiplier += CommonConfig.UPGRADES.getLevelMult(level);
        }
        if (this.storageMultiplier == 0) {
            this.storageMultiplier = CommonConfig.UPGRADES.getLevelMult(0);
        }
    }

    private void syncStatusLevel() {
        this.statusType = null;
        for (ItemStack stack : this.upgrades) {
            if (!(stack.func_77973_b() instanceof ItemUpgradeStatus)) continue;
            this.statusType = ((ItemUpgradeStatus)stack.func_77973_b()).level;
            break;
        }
    }

    private void syncRedstoneLevel() {
        this.redstoneType = null;
        for (ItemStack stack : this.upgrades) {
            if (!(stack.func_77973_b() instanceof ItemUpgradeRedstone)) continue;
            this.redstoneType = ((ItemUpgradeRedstone)stack.func_77973_b()).type;
            break;
        }
    }

    @Override
    public void read(CompoundNBT tag) {
        for (int i = 0; i < this.upgrades.length; ++i) {
            this.upgrades[i] = ItemStack.field_190927_a;
        }
        if (!tag.func_74764_b("Upgrades")) {
            return;
        }
        ListNBT tagList = tag.func_150295_c("Upgrades", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT upgradeTag = tagList.func_150305_b(i);
            byte slot = upgradeTag.func_74771_c("Slot");
            this.upgrades[slot] = ItemStack.func_199557_a((CompoundNBT)upgradeTag);
        }
        this.syncUpgrades();
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        ListNBT tagList = new ListNBT();
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (this.upgrades[i].func_190926_b()) continue;
            CompoundNBT upgradeTag = this.upgrades[i].func_77955_b(new CompoundNBT());
            upgradeTag.func_74774_a("Slot", (byte)i);
            tagList.add((Object)upgradeTag);
        }
        tag.func_218657_a("Upgrades", (INBT)tagList);
        return tag;
    }

    protected void onUpgradeChanged(ItemStack oldUpgrade, ItemStack newUpgrade) {
    }
}

