/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.metalbarrels.block;

import com.tfar.metalbarrels.tile.AbstractBarrelTile;
import java.util.Random;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class AbstractBarrelBlock
extends BarrelBlock {
    private static final Random RANDOM = new Random();

    public AbstractBarrelBlock(Block.Properties properties) {
        super(properties);
    }

    public void func_196243_a(BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof AbstractBarrelTile) {
                AbstractBarrelBlock.dropItems((AbstractBarrelTile)tileentity, worldIn, pos);
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public static void dropItems(AbstractBarrelTile barrel, World world, BlockPos pos) {
        IntStream.range(0, barrel.handler.getSlots()).mapToObj(i -> barrel.handler.getStackInSlot(i)).filter(stack -> !stack.func_190926_b()).forEach(stack -> AbstractBarrelBlock.spawnItemStack(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack));
    }

    public static void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        double d0 = EntityType.field_200765_E.func_220333_h();
        double d1 = 1.0 - d0;
        double d2 = d0 / 2.0;
        double d3 = Math.floor(x) + RANDOM.nextDouble() * d1 + d2;
        double d4 = Math.floor(y) + RANDOM.nextDouble() * d1;
        double d5 = Math.floor(z) + RANDOM.nextDouble() * d1 + d2;
        while (!stack.func_190926_b()) {
            ItemEntity itementity = new ItemEntity(worldIn, d3, d4, d5, stack.func_77979_a(RANDOM.nextInt(21) + 10));
            float f = 0.05f;
            itementity.func_213293_j(RANDOM.nextGaussian() * (double)f, RANDOM.nextGaussian() * (double)f + 0.2, RANDOM.nextGaussian() * (double)f);
            worldIn.func_217376_c((Entity)itementity);
        }
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof INamedContainerProvider) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
                player.func_195066_a(Stats.field_219732_ap);
            } else {
                throw new IllegalStateException("Our named container provider is missing!");
            }
        }
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        TileEntity barrel = world.func_175625_s(pos);
        return barrel instanceof AbstractBarrelTile ? ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)((AbstractBarrelTile)barrel).handler) : 0;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof AbstractBarrelTile) {
            ((AbstractBarrelTile)tileentity).setCustomName(stack.func_200301_q());
        }
    }

    public int getHarvestLevel(BlockState state) {
        return 1;
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }
}

