/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.helpers;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;

public class NBTHelper {
    public static ByteArrayNBT createBooleanList(boolean[] booleans) {
        byte[] bytes = new byte[booleans.length];
        for (int i = 0; i < booleans.length; ++i) {
            bytes[i] = (byte)(!booleans[i] ? 1 : 0);
        }
        return new ByteArrayNBT(bytes);
    }

    public static ByteArrayNBT createBooleanList(Boolean[] booleans) {
        byte[] bytes = new byte[booleans.length];
        for (int i = 0; i < booleans.length; ++i) {
            bytes[i] = (byte)(booleans[i] == false ? 1 : 0);
        }
        return new ByteArrayNBT(bytes);
    }

    public static ListNBT createShortList(short[] shorts) {
        ListNBT list = new ListNBT();
        for (short s : shorts) {
            list.add((Object)new ShortNBT(s));
        }
        return list;
    }

    public static ListNBT createShortList(Short[] shorts) {
        ListNBT list = new ListNBT();
        Short[] shortArray = shorts;
        int n = shortArray.length;
        for (int i = 0; i < n; ++i) {
            short s = shortArray[i];
            list.add((Object)new ShortNBT(s));
        }
        return list;
    }

    @Nonnull
    public static ListNBT createFloatList(float[] floats) {
        ListNBT list = new ListNBT();
        for (float f : floats) {
            list.add((Object)new FloatNBT(f));
        }
        return list;
    }

    @Nonnull
    public static ListNBT createFloatList(Float[] floats) {
        ListNBT list = new ListNBT();
        for (Float f : floats) {
            list.add((Object)new FloatNBT(f.floatValue()));
        }
        return list;
    }

    @Nonnull
    public static ListNBT createDoubleList(double[] doubles) {
        ListNBT list = new ListNBT();
        for (double d : doubles) {
            list.add((Object)new DoubleNBT(d));
        }
        return list;
    }

    @Nonnull
    public static ListNBT createDoubleList(Double[] doubles) {
        ListNBT list = new ListNBT();
        for (Double d : doubles) {
            list.add((Object)new DoubleNBT(d.doubleValue()));
        }
        return list;
    }

    @Nonnull
    public static short[] readShortList(ListNBT shorts) {
        short[] res = new short[shorts.size()];
        IntArrayList failed = new IntArrayList();
        for (int i = 0; i < shorts.size(); ++i) {
            INBT nbt = shorts.get(i);
            if (nbt instanceof ShortNBT) {
                res[i] = ((ShortNBT)nbt).func_150289_e();
                continue;
            }
            res[i] = 0;
            failed.add(i);
        }
        if (!failed.isEmpty()) {
            short[] shortened = new short[res.length - failed.size()];
            int shortenedCount = 0;
            for (int i = 0; i < res.length; ++i) {
                if (failed.contains(i)) continue;
                shortened[shortenedCount] = res[i];
                ++shortenedCount;
            }
            res = shortened;
        }
        return res;
    }

    @Nonnull
    public static Short[] readBShortList(ListNBT shorts) {
        Short[] res = new Short[shorts.size()];
        IntArrayList failed = new IntArrayList();
        for (int i = 0; i < shorts.size(); ++i) {
            INBT nbt = shorts.get(i);
            if (nbt instanceof ShortNBT) {
                res[i] = ((ShortNBT)nbt).func_150289_e();
                continue;
            }
            res[i] = 0;
            failed.add(i);
        }
        if (!failed.isEmpty()) {
            Short[] shortened = new Short[res.length - failed.size()];
            int shortenedCount = 0;
            for (int i = 0; i < res.length; ++i) {
                if (failed.contains(i)) continue;
                shortened[shortenedCount] = res[i];
                ++shortenedCount;
            }
            res = shortened;
        }
        return res;
    }

    @Nonnull
    public static ListNBT createStringList(String[] strings) {
        ListNBT list = new ListNBT();
        for (String s : strings) {
            list.add((Object)new StringNBT(s));
        }
        return list;
    }

    @Nonnull
    public static float[] readFloatList(ListNBT floats) {
        float[] res = new float[floats.size()];
        IntArrayList failed = new IntArrayList();
        for (int i = 0; i < floats.size(); ++i) {
            INBT nbt = floats.get(i);
            if (nbt instanceof FloatNBT) {
                res[i] = ((FloatNBT)nbt).func_150288_h();
                continue;
            }
            res[i] = 0.0f;
            failed.add(i);
        }
        if (!failed.isEmpty()) {
            float[] shortened = new float[res.length - failed.size()];
            int shortenedCount = 0;
            for (int i = 0; i < res.length; ++i) {
                if (failed.contains(i)) continue;
                shortened[shortenedCount] = res[i];
                ++shortenedCount;
            }
            res = shortened;
        }
        return res;
    }

    @Nonnull
    public static Float[] readBFloatList(ListNBT floats) {
        Float[] res = new Float[floats.size()];
        IntArrayList failed = new IntArrayList();
        for (int i = 0; i < floats.size(); ++i) {
            INBT nbt = floats.get(i);
            if (nbt instanceof FloatNBT) {
                res[i] = Float.valueOf(((FloatNBT)nbt).func_150288_h());
                continue;
            }
            res[i] = Float.valueOf(0.0f);
            failed.add(i);
        }
        if (!failed.isEmpty()) {
            Float[] shortened = new Float[res.length - failed.size()];
            int shortenedCount = 0;
            for (int i = 0; i < res.length; ++i) {
                if (failed.contains(i)) continue;
                shortened[shortenedCount] = res[i];
                ++shortenedCount;
            }
            res = shortened;
        }
        return res;
    }

    @Nonnull
    public static double[] readDoubleList(ListNBT doubles) {
        double[] res = new double[doubles.size()];
        IntArrayList failed = new IntArrayList();
        for (int i = 0; i < doubles.size(); ++i) {
            INBT nbt = doubles.get(i);
            if (nbt instanceof DoubleNBT) {
                res[i] = ((DoubleNBT)nbt).func_150286_g();
                continue;
            }
            res[i] = 0.0;
            failed.add(i);
        }
        if (!failed.isEmpty()) {
            double[] shortened = new double[res.length - failed.size()];
            int shortenedCount = 0;
            for (int i = 0; i < res.length; ++i) {
                if (failed.contains(i)) continue;
                shortened[shortenedCount] = res[i];
                ++shortenedCount;
            }
            res = shortened;
        }
        return res;
    }

    @Nonnull
    public static Double[] readBDoubleList(ListNBT doubles) {
        Double[] res = new Double[doubles.size()];
        IntArrayList failed = new IntArrayList();
        for (int i = 0; i < doubles.size(); ++i) {
            INBT nbt = doubles.get(i);
            if (nbt instanceof DoubleNBT) {
                res[i] = ((DoubleNBT)nbt).func_150286_g();
                continue;
            }
            res[i] = 0.0;
            failed.add(i);
        }
        if (!failed.isEmpty()) {
            Double[] shortened = new Double[res.length - failed.size()];
            int shortenedCount = 0;
            for (int i = 0; i < res.length; ++i) {
                if (failed.contains(i)) continue;
                shortened[shortenedCount] = res[i];
                ++shortenedCount;
            }
            res = shortened;
        }
        return res;
    }

    @Nonnull
    public static String[] readStringList(ListNBT strings) {
        String[] res = new String[strings.size()];
        IntArrayList failed = new IntArrayList();
        for (int i = 0; i < strings.size(); ++i) {
            INBT nbt = strings.get(i);
            if (nbt instanceof StringNBT) {
                res[i] = nbt.func_150285_a_();
                continue;
            }
            res[i] = "";
            failed.add(i);
        }
        if (!failed.isEmpty()) {
            String[] shortened = new String[res.length - failed.size()];
            int shortenedCount = 0;
            for (int i = 0; i < res.length; ++i) {
                if (failed.contains(i)) continue;
                shortened[shortenedCount] = res[i];
                ++shortenedCount;
            }
            res = shortened;
        }
        return res;
    }

    public static boolean[] readBooleanList(ByteArrayNBT booleans) {
        byte[] bytes = booleans.func_150292_c();
        boolean[] res = new boolean[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            res[i] = bytes[i] == 0;
        }
        return res;
    }

    public static Boolean[] readBBooleanList(ByteArrayNBT booleans) {
        byte[] bytes = booleans.func_150292_c();
        Boolean[] res = new Boolean[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            res[i] = bytes[i] == 0;
        }
        return res;
    }

    public static <T> ListNBT writeIterable(Iterable<T> iterable, Function<? super T, ? extends INBT> serializer) {
        return StreamSupport.stream(iterable.spliterator(), false).map(serializer).collect(NBTHelper.toListNBT());
    }

    public static <T> ListNBT writeIterable(Iterable<T> iterable, BiFunction<? super T, Integer, ? extends INBT> serializer) {
        int index = 0;
        ListNBT res = new ListNBT();
        for (T element : iterable) {
            res.add((Object)serializer.apply(element, index));
            ++index;
        }
        return res;
    }

    public static <V, T extends INBT> List<V> readList(CollectionNBT<T> list, Function<? super T, ? extends V> deserializer) {
        return list.stream().map(deserializer).collect(Collectors.toList());
    }

    public static <V, T extends INBT> List<V> readList(CollectionNBT<T> list, BiFunction<? super T, Integer, ? extends V> deserializer) {
        ArrayList<V> res = new ArrayList<V>(list.size());
        int index = 0;
        for (INBT element : list) {
            res.add(deserializer.apply(element, index));
            ++index;
        }
        return res;
    }

    public static <K, V> ListNBT serializeMap(Map<K, V> map, Function<? super K, ? extends INBT> keySerializer, Function<? super V, ? extends INBT> valueSerializer) {
        ListNBT list = new ListNBT();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_218657_a("key", keySerializer.apply(entry.getKey()));
            compound.func_218657_a("val", valueSerializer.apply(entry.getValue()));
            list.add((Object)compound);
        }
        return list;
    }

    public static <K, V> Map<K, V> deserializeMap(ListNBT list, Map<K, V> toAppendTo, Function<INBT, ? extends K> keyDeserializer, Function<INBT, ? extends V> valueDeserializer) {
        for (INBT nbt : list) {
            if (!(nbt instanceof CompoundNBT)) continue;
            CompoundNBT compound = (CompoundNBT)nbt;
            toAppendTo.put(keyDeserializer.apply(compound.func_74781_a("key")), valueDeserializer.apply(compound.func_74781_a("val")));
        }
        return toAppendTo;
    }

    public static <T> ListNBT serializeSet(Set<T> set, Function<? super T, ? extends INBT> elementSerializer) {
        ListNBT list = new ListNBT();
        for (T element : set) {
            list.add((Object)elementSerializer.apply(element));
        }
        return list;
    }

    public static <T> Set<T> deserializeSet(ListNBT list, Set<T> toAppendTo, Function<INBT, ? extends T> elementDeserializer) {
        for (INBT nbt : list) {
            toAppendTo.add(elementDeserializer.apply(nbt));
        }
        return toAppendTo;
    }

    public static ListNBT concat(ListNBT first, ListNBT second) {
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        return Stream.concat(first.stream(), second.stream()).collect(NBTHelper.toListNBT());
    }

    public static CompoundNBT getOrNewTag(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p();
        }
        CompoundNBT tag = new CompoundNBT();
        stack.func_77982_d(tag);
        return tag;
    }

    public static <T extends INBT> Collector<T, ListNBT, ListNBT> toListNBT() {
        return new Collector<T, ListNBT, ListNBT>(){

            @Override
            public Supplier<ListNBT> supplier() {
                return ListNBT::new;
            }

            @Override
            public BiConsumer<ListNBT, T> accumulator() {
                return AbstractList::add;
            }

            @Override
            public BinaryOperator<ListNBT> combiner() {
                return (l1, l2) -> {
                    l1.addAll((Collection)l2);
                    return l1;
                };
            }

            @Override
            public Function<ListNBT, ListNBT> finisher() {
                return Function.identity();
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH, Collector.Characteristics.UNORDERED);
            }
        };
    }
}

