/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.buffers;

import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.registry.objects.BGItems;
import com.direwolf20.buildinggadgets.common.util.blocks.BlockMap;
import com.direwolf20.buildinggadgets.common.util.buffers.ToolBufferBuilder;
import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PasteToolBufferBuilder {
    private static Map<String, CompoundNBT> tagMap = new HashMap<String, CompoundNBT>();
    private static Map<String, ToolBufferBuilder> bufferMap = new HashMap<String, ToolBufferBuilder>();

    private static int getCopyCounter(String UUID) {
        if (tagMap.containsKey(UUID)) {
            return tagMap.get(UUID).func_74762_e("copy_count");
        }
        return -1;
    }

    public static void clearMaps() {
        tagMap = new HashMap<String, CompoundNBT>();
        bufferMap = new HashMap<String, ToolBufferBuilder>();
    }

    public static void addToMap(String UUID, CompoundNBT tag) {
        tagMap.put(UUID, tag);
    }

    @Nullable
    public static CompoundNBT getTagFromUUID(String UUID) {
        if (tagMap.containsKey(UUID)) {
            return tagMap.get(UUID);
        }
        return null;
    }

    @Nullable
    public static ToolBufferBuilder getBufferFromMap(String UUID) {
        if (bufferMap.containsKey(UUID)) {
            return bufferMap.get(UUID);
        }
        return null;
    }

    public static void addMapToBuffer(String UUID) {
        List<BlockMap> blockMapList = GadgetCopyPaste.getBlockMapList(tagMap.get(UUID));
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        ToolBufferBuilder bufferBuilder = new ToolBufferBuilder(0x200000);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (BlockMap blockMap : blockMapList) {
            BlockState renderBlockState = blockMap.state.getState();
            if (renderBlockState.equals((Object)Blocks.field_150350_a.func_176223_P())) continue;
            IBakedModel model = dispatcher.func_184389_a(renderBlockState);
            dispatcher.func_175019_b().func_217635_c((IEnviromentBlockReader)Minecraft.func_71410_x().field_71441_e, model, renderBlockState, new BlockPos(blockMap.xOffset, blockMap.yOffset, blockMap.zOffset), (BufferBuilder)bufferBuilder, false, new Random(), 0L);
        }
        bufferBuilder.func_178977_d();
        bufferMap.put(UUID, bufferBuilder);
    }

    public static void draw(PlayerEntity player, double x, double y, double z, BlockPos startPos, String UUID) {
        ToolBufferBuilder bufferBuilder = bufferMap.get(UUID);
        bufferBuilder.func_181674_a((float)(x - (double)startPos.func_177958_n()), (float)(y + (double)player.func_70047_e() - (double)startPos.func_177956_o()), (float)(z - (double)startPos.func_177952_p()));
        if (bufferBuilder.func_178989_h() > 0) {
            VertexFormat vertexformat = bufferBuilder.func_178973_g();
            int i = vertexformat.func_177338_f();
            ByteBuffer bytebuffer = bufferBuilder.func_178966_f();
            List list = vertexformat.func_177343_g();
            for (int j = 0; j < list.size(); ++j) {
                VertexFormatElement vertexformatelement = (VertexFormatElement)list.get(j);
                bytebuffer.position(vertexformat.func_181720_d(j));
                vertexformatelement.func_177375_c().preDraw(vertexformat, j, i, bytebuffer);
            }
            GlStateManager.drawArrays((int)bufferBuilder.func_178979_i(), (int)0, (int)bufferBuilder.func_178989_h());
            int j1 = list.size();
            for (int i1 = 0; i1 < j1; ++i1) {
                VertexFormatElement vertexformatelement1 = (VertexFormatElement)list.get(i1);
                vertexformatelement1.func_177375_c().postDraw(vertexformat, i1, i, bytebuffer);
            }
        }
    }

    public static boolean isUpdateNeeded(String UUID, ItemStack stack) {
        return BGItems.gadgetCopyPaste.getCopyCounter(stack) != PasteToolBufferBuilder.getCopyCounter(UUID) || PasteToolBufferBuilder.getTagFromUUID(UUID) == null;
    }
}

