/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.registry.block;

import com.direwolf20.buildinggadgets.common.registry.RegistryObjectBuilder;
import com.direwolf20.buildinggadgets.common.registry.block.tile.TileEntityBuilder;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public final class BlockBuilder
extends RegistryObjectBuilder<Block, Block.Properties> {
    private Block block;
    private BiFunction<Block, Item.Properties, Item> itemBlockFactory = BlockItem::new;
    private Item.Properties itemBuilder = new Item.Properties();
    private boolean hasItem = true;
    private ResourceLocation tileEntityId;
    private TileEntityBuilder<?> tileEntityBuilder;

    public static BlockBuilder create(String registryName) {
        return new BlockBuilder(registryName);
    }

    public static BlockBuilder create(ResourceLocation registryName) {
        return new BlockBuilder(registryName);
    }

    public BlockBuilder(String registryName) {
        super(registryName);
    }

    public BlockBuilder(ResourceLocation registryName) {
        super(registryName);
    }

    public BlockBuilder item(Item.Properties itemBuilder, BiFunction<Block, Item.Properties, Item> itemBlockFactory) {
        this.itemBuilder = Objects.requireNonNull(itemBuilder);
        this.itemBlockFactory = Objects.requireNonNull(itemBlockFactory);
        return this;
    }

    public BlockBuilder item(Item.Properties itemBuilder) {
        return this.item(itemBuilder, this.itemBlockFactory);
    }

    public BlockBuilder setHasNoItem() {
        this.hasItem = false;
        return this;
    }

    public BlockBuilder factory(Function<Block.Properties, Block> factory) {
        return (BlockBuilder)super.factory(factory);
    }

    public BlockBuilder builder(Block.Properties builder) {
        return (BlockBuilder)super.builder(builder);
    }

    @Override
    protected Block construct() {
        this.block = (Block)super.construct();
        return this.block;
    }

    public BlockBuilder withTileEntity(ResourceLocation tileId) {
        this.tileEntityId = Objects.requireNonNull(tileId);
        return this;
    }

    public BlockBuilder withTileEntity(TileEntityBuilder<?> tileBuilder) {
        this.tileEntityId = Objects.requireNonNull(tileBuilder.getRegistryName());
        this.tileEntityBuilder = Objects.requireNonNull(tileBuilder);
        this.tileEntityBuilder.addValidBlock(this.getRegistryName());
        return this;
    }

    Item createItemFromBlock() {
        return (Item)this.itemBlockFactory.apply(this.block, this.itemBuilder).setRegistryName(this.getRegistryName());
    }

    boolean hasItem() {
        return this.hasItem;
    }

    ResourceLocation getTileEntityId() {
        return this.tileEntityId;
    }

    TileEntityBuilder<?> getTileEntityBuilder() {
        return this.tileEntityBuilder;
    }
}

