/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketBlockMap;
import com.direwolf20.buildinggadgets.common.world.WorldSave;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketRequestBlockMap {
    private static int uuidLength = 128;
    private String UUID;
    private boolean isTemplate;

    public PacketRequestBlockMap(String ID, boolean isTemplate) {
        this.UUID = ID;
        this.isTemplate = isTemplate;
    }

    public static void encode(PacketRequestBlockMap msg, PacketBuffer buffer) {
        buffer.func_180714_a(msg.UUID);
        buffer.writeBoolean(msg.isTemplate);
    }

    public static PacketRequestBlockMap decode(PacketBuffer buffer) {
        return new PacketRequestBlockMap(buffer.func_150789_c(uuidLength), buffer.readBoolean());
    }

    public static class Handler {
        public static void handle(PacketRequestBlockMap msg, Supplier<NetworkEvent.Context> ctx) {
            if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                return;
            }
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                CompoundNBT tagCompound = (msg.isTemplate ? WorldSave.getTemplateWorldSave(player.field_70170_p) : WorldSave.getWorldSave(player.field_70170_p)).getCompoundFromUUID(msg.UUID);
                if (tagCompound != null) {
                    PacketHandler.sendTo(new PacketBlockMap(tagCompound), player);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

