/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.registry.objects.BGItems;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketCopyCoords {
    private final BlockPos start;
    private final BlockPos end;

    public PacketCopyCoords(BlockPos start, BlockPos end) {
        this.start = start;
        this.end = end;
    }

    public static void encode(PacketCopyCoords msg, PacketBuffer buffer) {
        buffer.func_179255_a(msg.start);
        buffer.func_179255_a(msg.end);
    }

    public static PacketCopyCoords decode(PacketBuffer buffer) {
        return new PacketCopyCoords(buffer.func_179259_c(), buffer.func_179259_c());
    }

    public static class Handler {
        public static void handle(PacketCopyCoords msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayerEntity playerEntity = ctx.get().getSender();
            if (playerEntity == null) {
                return;
            }
            ctx.get().enqueueWork(() -> {
                ItemStack heldItem = GadgetCopyPaste.getGadget((PlayerEntity)playerEntity);
                if (heldItem.func_190926_b()) {
                    return;
                }
                BlockPos startPos = msg.start;
                BlockPos endPos = msg.end;
                GadgetCopyPaste tool = BGItems.gadgetCopyPaste;
                if (startPos.equals((Object)BlockPos.field_177992_a) && endPos.equals((Object)BlockPos.field_177992_a)) {
                    tool.setStartPos(heldItem, null);
                    tool.setEndPos(heldItem, null);
                    playerEntity.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + new TranslationTextComponent("message.gadget.areareset", new Object[0]).func_150261_e()), true);
                } else {
                    tool.setStartPos(heldItem, startPos);
                    tool.setEndPos(heldItem, endPos);
                    GadgetCopyPaste.copyBlocks(heldItem, (PlayerEntity)playerEntity, playerEntity.field_70170_p, tool.getStartPos(heldItem), tool.getEndPos(heldItem));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

