/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets.renderers;

import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BaseRenderer;
import com.direwolf20.buildinggadgets.common.registry.objects.BGBlocks;
import com.direwolf20.buildinggadgets.common.util.CapabilityUtil;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.tools.modes.ExchangingMode;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.lwjgl.opengl.GL14;

public class ExchangerRender
extends BaseRenderer {
    @Override
    public void render(RenderWorldLastEvent evt, PlayerEntity player, ItemStack heldItem) {
        super.render(evt, player, heldItem);
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, heldItem);
        Vec3d playerPos = BaseRenderer.getPlayerPos();
        BlockState state = AIR;
        List<BlockPos> coordinates = GadgetUtils.getAnchor(heldItem);
        if ((lookingAt == null || player.field_70170_p.func_180495_p(VectorHelper.getLookingAt(player, heldItem).func_216350_a()) == AIR) && coordinates.size() == 0) {
            return;
        }
        World world = player.field_70170_p;
        BlockState startBlock = AIR;
        startBlock = world.func_180495_p(new BlockPos((Vec3i)lookingAt.func_216350_a()));
        if (startBlock != BGBlocks.effectBlock.func_176223_P()) {
            BlockState renderBlockState = GadgetUtils.getToolBlock(heldItem).getState();
            ExchangerRender.getMc().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            if (renderBlockState == AIR) {
                return;
            }
            if (coordinates.size() == 0) {
                coordinates = ExchangingMode.collectPlacementPos((IWorld)world, player, lookingAt.func_216350_a(), lookingAt.func_216354_b(), heldItem, lookingAt.func_216350_a());
            }
            ItemStack itemStack = this.getItemStackForRender(renderBlockState, player, (IWorld)world);
            long hasBlocks = this.playerHasBlocks(itemStack, player, renderBlockState);
            int hasEnergy = this.getEnergy(player, heldItem);
            LazyOptional<IEnergyStorage> energy = CapabilityUtil.EnergyUtil.getCap((ICapabilityProvider)heldItem);
            HashSet<BlockPos> coords = new HashSet<BlockPos>(coordinates);
            ExchangerRender.getBuilderWorld().setWorldAndState(player.field_70170_p, renderBlockState, coords);
            GlStateManager.pushMatrix();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)32771, (int)32772);
            for (BlockPos coordinate : coordinates) {
                GlStateManager.pushMatrix();
                GlStateManager.translated((double)(-playerPos.func_82615_a()), (double)(-playerPos.func_82617_b()), (double)(-playerPos.func_82616_c()));
                GlStateManager.translatef((float)coordinate.func_177958_n(), (float)coordinate.func_177956_o(), (float)coordinate.func_177952_p());
                GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)-0.005f, (float)-0.005f, (float)0.005f);
                GlStateManager.scalef((float)1.01f, (float)1.01f, (float)1.01f);
                GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.55f);
                if (ExchangerRender.getBuilderWorld().getWorldType() != WorldType.field_180272_g) {
                    try {
                        state = renderBlockState;
                    }
                    catch (Exception var8) {
                        var8.printStackTrace();
                    }
                }
                if (renderBlockState.func_185901_i() != BlockRenderType.INVISIBLE) {
                    try {
                        ExchangerRender.getMc().func_175602_ab().func_175016_a(state, 1.0f);
                    }
                    catch (Throwable t) {
                        Tessellator tessellator = Tessellator.func_178181_a();
                        BufferBuilder bufferBuilder = tessellator.func_178180_c();
                        bufferBuilder.func_178977_d();
                    }
                    GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
                ExchangerRender.getMc().func_175602_ab().func_175016_a(Blocks.field_196807_gj.func_176223_P(), 1.0f);
                GlStateManager.popMatrix();
            }
            for (BlockPos coordinate : coordinates) {
                GlStateManager.pushMatrix();
                GlStateManager.translated((double)(-playerPos.func_82615_a()), (double)(-playerPos.func_82617_b()), (double)(-playerPos.func_82616_c()));
                GlStateManager.translatef((float)coordinate.func_177958_n(), (float)coordinate.func_177956_o(), (float)coordinate.func_177952_p());
                GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)-0.01f, (float)-0.01f, (float)0.01f);
                GlStateManager.scalef((float)1.02f, (float)1.02f, (float)1.02f);
                GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.55f);
                --hasBlocks;
                if (energy.isPresent()) {
                    hasEnergy -= ((AbstractGadget)heldItem.func_77973_b()).getEnergyCost(heldItem);
                }
                if (hasBlocks < 0L || hasEnergy < 0) {
                    ExchangerRender.getMc().func_175602_ab().func_175016_a(Blocks.field_196823_gx.func_176223_P(), 1.0f);
                }
                GlStateManager.popMatrix();
            }
            if (state.hasTileEntity()) {
                TileEntity te = ExchangerRender.getTileEntityWorld().getTE(state, world);
                TileEntityRenderer<TileEntity> teRender = ExchangerRender.getTileEntityWorld().getTER(state, world);
                if (teRender != null && !ExchangerRender.getInvalidTileEntities().contains(te)) {
                    for (BlockPos coordinate : coordinates) {
                        te.func_174878_a(coordinate);
                        GlStateManager.pushMatrix();
                        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GlStateManager.translated((double)(-playerPos.func_82615_a()), (double)(-playerPos.func_82617_b()), (double)(-playerPos.func_82616_c()));
                        GlStateManager.translatef((float)coordinate.func_177958_n(), (float)coordinate.func_177956_o(), (float)coordinate.func_177952_p());
                        GlStateManager.scalef((float)1.0f, (float)1.0f, (float)1.0f);
                        GlStateManager.enableBlend();
                        GlStateManager.blendFunc((int)32771, (int)32772);
                        try {
                            TileEntityRendererDispatcher.field_147556_a.func_203602_a(te, 0.0, 0.0, 0.0, evt.getPartialTicks(), -1, true);
                        }
                        catch (Exception e) {
                            System.out.println("TER Exception with block type: " + state);
                            ExchangerRender.getInvalidTileEntities().add(te);
                            GlStateManager.disableFog();
                            GlStateManager.popMatrix();
                            break;
                        }
                        GlStateManager.disableFog();
                        GlStateManager.popMatrix();
                    }
                }
            }
            GlStateManager.blendFunc((int)770, (int)771);
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)MinecraftForgeClient.getRenderLayer());
            GlStateManager.disableBlend();
            GlStateManager.popMatrix();
        }
    }

    @Override
    public boolean isLinkable() {
        return true;
    }
}

