/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets.renderers;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BaseRenderer;
import com.direwolf20.buildinggadgets.common.registry.objects.BGBlocks;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.tools.UniqueItemStack;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class DestructionRender
extends BaseRenderer {
    private static Cache<Triple<UniqueItemStack, BlockPos, Integer>, Integer> cacheDestructionOverlay = CacheBuilder.newBuilder().maximumSize(1L).expireAfterWrite(1L, TimeUnit.SECONDS).removalListener(removal -> GLAllocation.func_74523_b((int)((Integer)removal.getValue()))).build();

    @Override
    public void render(RenderWorldLastEvent evt, PlayerEntity player, ItemStack heldItem) {
        Direction facing;
        if (!GadgetDestruction.getOverlay(heldItem)) {
            return;
        }
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, heldItem);
        World world = player.field_70170_p;
        if ((lookingAt == null || world.func_180495_p(VectorHelper.getLookingAt(player, heldItem).func_216350_a()) == AIR) && GadgetDestruction.getAnchor(heldItem) == null) {
            return;
        }
        BlockPos startBlock = GadgetDestruction.getAnchor(heldItem) == null ? lookingAt.func_216350_a() : GadgetDestruction.getAnchor(heldItem);
        Direction direction = facing = GadgetDestruction.getAnchorSide(heldItem) == null ? lookingAt.func_216354_b() : GadgetDestruction.getAnchorSide(heldItem);
        if (world.func_180495_p(startBlock) == BGBlocks.effectBlock.func_176223_P()) {
            return;
        }
        Vec3d playerPos = DestructionRender.getPlayerPos();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(-playerPos.func_82615_a()), (double)(-playerPos.func_82617_b()), (double)(-playerPos.func_82616_c()));
        try {
            GlStateManager.callList((int)((Integer)cacheDestructionOverlay.get((Object)new ImmutableTriple((Object)new UniqueItemStack(heldItem), (Object)startBlock, (Object)facing.ordinal()), () -> {
                int displayList = GLAllocation.func_74526_a((int)1);
                GlStateManager.newList((int)displayList, (int)4864);
                this.renderOverlay(player, world, startBlock, facing, heldItem);
                GlStateManager.endList();
                return displayList;
            })));
        }
        catch (ExecutionException e) {
            BuildingGadgets.LOG.error("Error encountered while rendering destruction gadget overlay", (Throwable)e);
        }
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
    }

    private void renderOverlay(PlayerEntity player, World world, BlockPos startBlock, Direction facing, ItemStack heldItem) {
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = t.func_178180_c();
        for (BlockPos coordinate : GadgetDestruction.getClearingPositionsForRendering(world, startBlock, facing, player, heldItem)) {
            boolean invisible = true;
            BlockState state = world.func_180495_p(coordinate);
            for (Direction side : Direction.values()) {
                if (state.func_200017_a(state, side)) continue;
                invisible = false;
                break;
            }
            if (invisible) continue;
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)coordinate.func_177958_n(), (float)coordinate.func_177956_o(), (float)coordinate.func_177952_p());
            GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.005f, (float)-0.005f, (float)0.005f);
            GlStateManager.scalef((float)1.01f, (float)1.01f, (float)1.01f);
            GlStateManager.disableLighting();
            GlStateManager.disableTexture();
            DestructionRender.renderBoxSolid(t, bufferBuilder, 0.0, 0.0, -1.0, 1.0, 1.0, 0.0, 1.0f, 0.0f, 0.0f, 0.5f);
            GlStateManager.enableTexture();
            GlStateManager.enableLighting();
            GlStateManager.popMatrix();
        }
        GlStateManager.blendFunc((int)770, (int)771);
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)MinecraftForgeClient.getRenderLayer());
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    private static void renderBoxSolid(Tessellator tessellator, BufferBuilder bufferBuilder, double startX, double startY, double startZ, double endX, double endY, double endZ, float red, float green, float blue, float alpha) {
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }
}

