/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets.renderers;

import com.direwolf20.buildinggadgets.client.RemoteInventoryCache;
import com.direwolf20.buildinggadgets.client.renderer.FakeTERWorld;
import com.direwolf20.buildinggadgets.common.util.CapabilityUtil;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.exceptions.CapabilityNotPresentException;
import com.direwolf20.buildinggadgets.common.util.helpers.InventoryHelper;
import com.direwolf20.buildinggadgets.common.util.tools.UniqueItem;
import com.direwolf20.buildinggadgets.common.world.FakeBuilderWorld;
import com.google.common.collect.Multiset;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.lwjgl.opengl.GL14;

public abstract class BaseRenderer {
    public static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final FakeTERWorld tileEntityWorld = new FakeTERWorld();
    private static final FakeBuilderWorld builderWorld = new FakeBuilderWorld();
    private static final Set<TileEntity> invalidTileEntities = new HashSet<TileEntity>();
    private static RemoteInventoryCache cacheInventory = new RemoteInventoryCache(false);

    public void render(RenderWorldLastEvent evt, PlayerEntity player, ItemStack heldItem) {
        BaseRenderer.getMc().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        if (this.isLinkable()) {
            BaseRenderer.renderLinkedInventoryOutline(heldItem, player);
        }
    }

    private static void renderLinkedInventoryOutline(ItemStack item, PlayerEntity player) {
        ResourceLocation dim = GadgetUtils.getDIMFromNBT(item, "bound_te_pos");
        BlockPos pos = GadgetUtils.getPOSFromNBT(item, "bound_te_pos");
        if (dim == null || pos == null) {
            return;
        }
        DimensionType dimension = DimensionType.func_193417_a((ResourceLocation)dim);
        if (dimension == null || player.field_71093_bK != dimension) {
            return;
        }
        Vec3d renderPos = BaseRenderer.getPlayerPos().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_72441_c((double)0.005f, (double)0.005f, (double)-0.005f);
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)32771, (int)32772);
        GlStateManager.translated((double)(-renderPos.func_82615_a()), (double)(-renderPos.func_82617_b()), (double)(-renderPos.func_82616_c()));
        GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.scalef((float)1.01f, (float)1.01f, (float)1.01f);
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.35f);
        BaseRenderer.getMc().func_175602_ab().func_175016_a(Blocks.field_196811_gn.func_176223_P(), 1.0f);
        GlStateManager.popMatrix();
    }

    int getEnergy(PlayerEntity player, ItemStack heldItem) {
        LazyOptional<IEnergyStorage> energy = CapabilityUtil.EnergyUtil.getCap((ICapabilityProvider)heldItem);
        if (player.func_184812_l_() || !energy.isPresent()) {
            return Integer.MAX_VALUE;
        }
        return ((IEnergyStorage)energy.orElseThrow(CapabilityNotPresentException::new)).getEnergyStored();
    }

    long playerHasBlocks(ItemStack stack, PlayerEntity player, BlockState state) {
        long hasBlocks = InventoryHelper.countItem(stack, player, BaseRenderer.getCacheInventory());
        if (!state.hasTileEntity()) {
            hasBlocks += (long)InventoryHelper.countPaste(player);
        }
        return hasBlocks;
    }

    ItemStack getItemStackForRender(BlockState state, PlayerEntity player, IWorld world) {
        ItemStack itemStack = ItemStack.field_190927_a;
        itemStack = state.func_177230_c().getPickBlock(state, null, (IBlockReader)world, BlockPos.field_177992_a, player);
        return !itemStack.func_190926_b() ? itemStack : state.func_177230_c().getPickBlock(state, null, (IBlockReader)world, BlockPos.field_177992_a, player);
    }

    public boolean isLinkable() {
        return false;
    }

    static Minecraft getMc() {
        return Minecraft.func_71410_x();
    }

    static FakeTERWorld getTileEntityWorld() {
        return tileEntityWorld;
    }

    static FakeBuilderWorld getBuilderWorld() {
        return builderWorld;
    }

    static RemoteInventoryCache getCacheInventory() {
        return cacheInventory;
    }

    public static void setInventoryCache(Multiset<UniqueItem> cache) {
        cacheInventory.setCache(cache);
    }

    public static void updateInventoryCache() {
        cacheInventory.forceUpdate();
    }

    static Set<TileEntity> getInvalidTileEntities() {
        return invalidTileEntities;
    }

    static Vec3d getPlayerPos() {
        return new Vec3d(TileEntityRendererDispatcher.field_147554_b, TileEntityRendererDispatcher.field_147555_c, TileEntityRendererDispatcher.field_147552_d);
    }
}

