/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets;

import com.direwolf20.buildinggadgets.api.building.BlockData;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BaseRenderer;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.ExchangerRender;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketBindTool;
import com.direwolf20.buildinggadgets.common.registry.objects.BGItems;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.InventoryHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.LangUtil;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.tools.modes.ExchangingMode;
import com.direwolf20.buildinggadgets.common.world.FakeBuilderWorld;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class GadgetExchanger
extends AbstractGadget {
    private static final FakeBuilderWorld fakeWorld = new FakeBuilderWorld();

    public GadgetExchanger(Item.Properties builder) {
        super(builder);
    }

    @Override
    public int getEnergyMax() {
        return (Integer)Config.GADGETS.GADGET_EXCHANGER.maxEnergy.get();
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return (Integer)Config.GADGETS.GADGET_EXCHANGER.energyCost.get();
    }

    @Override
    protected Supplier<BaseRenderer> createRenderFactory() {
        return ExchangerRender::new;
    }

    public int func_77619_b() {
        return 3;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_185306_r) || super.isBookEnchantable(stack, book);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185306_r || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    private static void setToolMode(ItemStack tool, ExchangingMode mode) {
        CompoundNBT tagCompound = NBTHelper.getOrNewTag(tool);
        tagCompound.func_74778_a("mode", mode.getRegistryName());
    }

    public static ExchangingMode getToolMode(ItemStack tool) {
        CompoundNBT tagCompound = NBTHelper.getOrNewTag(tool);
        return ExchangingMode.byName(tagCompound.func_74779_i("mode"));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add(TooltipTranslation.GADGET_BLOCK.componentTranslation(LangUtil.getFormattedBlockName(GadgetUtils.getToolBlock(stack).getState())).func_150255_a(Styles.DK_GREEN));
        ExchangingMode mode = GadgetExchanger.getToolMode(stack);
        tooltip.add(TooltipTranslation.GADGET_MODE.componentTranslation(mode == ExchangingMode.SURFACE && GadgetExchanger.getConnectedArea(stack) ? TooltipTranslation.GADGET_CONNECTED.format(new Object[]{mode}) : mode).func_150255_a(Styles.AQUA));
        tooltip.add(TooltipTranslation.GADGET_RANGE.componentTranslation(GadgetUtils.getToolRange(stack)).func_150255_a(Styles.LT_PURPLE));
        tooltip.add(TooltipTranslation.GADGET_FUZZY.componentTranslation(String.valueOf(GadgetExchanger.getFuzzy(stack))).func_150255_a(Styles.GOLD));
        GadgetExchanger.addInformationRayTraceFluid(tooltip, stack);
        this.addEnergyInformation(tooltip, stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                GadgetUtils.selectBlock(itemstack, player);
            } else if (player instanceof ServerPlayerEntity) {
                this.exchange((ServerPlayerEntity)player, itemstack);
            }
        } else if (!player.func_70093_af()) {
            BaseRenderer.updateInventoryCache();
        } else if (Screen.hasControlDown()) {
            PacketHandler.sendToServer(new PacketBindTool());
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public void setMode(ItemStack heldItem, int modeInt) {
        ExchangingMode mode = ExchangingMode.values()[modeInt];
        GadgetExchanger.setToolMode(heldItem, mode);
    }

    public static void rangeChange(PlayerEntity player, ItemStack heldItem) {
        int changeAmount;
        int range = GadgetUtils.getToolRange(heldItem);
        int n = changeAmount = GadgetExchanger.getToolMode(heldItem) == ExchangingMode.GRID || range % 2 == 0 ? 1 : 2;
        range = player.func_70093_af() ? (range <= 1 ? (Integer)Config.GADGETS.maxRange.get() : range - changeAmount) : (range >= (Integer)Config.GADGETS.maxRange.get() ? 1 : range + changeAmount);
        GadgetUtils.setToolRange(heldItem, range);
        player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + new TranslationTextComponent("message.gadget.toolrange", new Object[0]).func_150261_e() + ": " + range), true);
    }

    private boolean exchange(ServerPlayerEntity player, ItemStack stack) {
        ServerWorld world = player.func_71121_q();
        List<BlockPos> coords = GadgetUtils.getAnchor(stack);
        if (coords.size() == 0) {
            BlockRayTraceResult lookingAt = VectorHelper.getLookingAt((PlayerEntity)player, stack);
            BlockPos startBlock = lookingAt.func_216350_a();
            Direction sideHit = lookingAt.func_216354_b();
            coords = ExchangingMode.collectPlacementPos((IWorld)world, (PlayerEntity)player, startBlock, sideHit, stack, startBlock);
        } else {
            GadgetUtils.setAnchor(stack, new ArrayList<BlockPos>());
        }
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>(coords);
        ItemStack heldItem = GadgetExchanger.getGadget((PlayerEntity)player);
        if (heldItem.func_190926_b()) {
            return false;
        }
        BlockData blockState = GadgetUtils.getToolBlock(heldItem);
        if (blockState.getState() != Blocks.field_150350_a.func_176223_P()) {
            fakeWorld.setWorldAndState(player.field_70170_p, blockState.getState(), coordinates);
            for (BlockPos coordinate : coords) {
                this.exchangeBlock(world, player, coordinate, blockState);
            }
        }
        return true;
    }

    private boolean exchangeBlock(ServerWorld world, ServerPlayerEntity player, BlockPos pos, BlockData setBlock) {
        ItemStack tool;
        BlockState currentBlock = world.func_180495_p(pos);
        boolean useConstructionPaste = false;
        ItemStack itemStack = setBlock.getState().canHarvestBlock((IBlockReader)world, pos, (PlayerEntity)player) ? InventoryHelper.getSilkTouchDrop(setBlock.getState()) : setBlock.getState().func_177230_c().getPickBlock(setBlock.getState(), null, (IBlockReader)world, pos, (PlayerEntity)player);
        if (itemStack.func_77973_b().equals(Items.field_190931_a)) {
            itemStack = setBlock.getState().func_177230_c().getPickBlock(setBlock.getState(), null, (IBlockReader)world, pos, (PlayerEntity)player);
        }
        if ((tool = GadgetExchanger.getGadget((PlayerEntity)player)).func_190926_b()) {
            return false;
        }
        List drops = Block.func_220077_a((BlockState)setBlock.getState(), (ServerWorld)world, (BlockPos)pos, (TileEntity)world.func_175625_s(pos), (Entity)player, (ItemStack)tool);
        int neededItems = 0;
        for (ItemStack drop : drops) {
            if (!drop.func_77973_b().equals(itemStack.func_77973_b())) continue;
            ++neededItems;
        }
        if (neededItems == 0) {
            neededItems = 1;
        }
        if (!setBlock.getState().hasTileEntity() && InventoryHelper.countItem(itemStack, (PlayerEntity)player, (World)world) < neededItems) {
            ItemStack constructionPaste = new ItemStack((IItemProvider)BGItems.constructionPaste);
            if (InventoryHelper.countPaste((PlayerEntity)player) < neededItems) {
                return false;
            }
            itemStack = constructionPaste.func_77946_l();
            useConstructionPaste = true;
        }
        if (!player.func_175142_cm()) {
            return false;
        }
        if (!world.func_175660_a((PlayerEntity)player, pos)) {
            return false;
        }
        BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((IWorld)world, (BlockPos)pos);
        if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blockSnapshot, (Direction)Direction.UP)) {
            return false;
        }
        BlockEvent.BreakEvent e = new BlockEvent.BreakEvent((World)world, pos, currentBlock, (PlayerEntity)player);
        if (MinecraftForge.EVENT_BUS.post((Event)e)) {
            return false;
        }
        if (!this.canUse(tool, (PlayerEntity)player)) {
            return false;
        }
        this.applyDamage(tool, player);
        boolean useItemSuccess = useConstructionPaste ? InventoryHelper.usePaste((PlayerEntity)player, 1) : InventoryHelper.useItem(itemStack, (PlayerEntity)player, neededItems, (World)world);
        if (useItemSuccess) {
            EffectBlock.spawnEffectBlock((World)world, pos, setBlock, EffectBlock.Mode.REPLACE, useConstructionPaste);
            currentBlock.func_177230_c();
            List blockDrops = Block.func_220070_a((BlockState)currentBlock, (ServerWorld)world, (BlockPos)pos, (TileEntity)world.func_175625_s(pos));
            for (ItemStack drop : blockDrops) {
                if (drop.func_77973_b().equals((Object)BGItems.constructionPaste)) {
                    InventoryHelper.addPasteToContainer((PlayerEntity)player, drop);
                }
                if (drop == null) continue;
                player.func_191521_c(drop);
            }
            return true;
        }
        return false;
    }

    public static ItemStack getGadget(PlayerEntity player) {
        ItemStack stack = AbstractGadget.getGadget(player);
        if (!(stack.func_77973_b() instanceof GadgetExchanger)) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 20;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }
}

