/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.capability;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class MultiCapabilityProvider
implements ICapabilityProvider {
    private final ImmutableList<ICapabilityProvider> childProviders;

    public MultiCapabilityProvider(ICapabilityProvider ... childProviders) {
        this((ImmutableList<ICapabilityProvider>)ImmutableList.copyOf((Object[])childProviders));
    }

    public MultiCapabilityProvider(ImmutableList<ICapabilityProvider> childProviders) {
        this.childProviders = childProviders;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        for (ICapabilityProvider provider : this.childProviders) {
            LazyOptional optional = provider.getCapability(cap, side);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return LazyOptional.empty();
    }
}

