/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.capability;

import com.direwolf20.buildinggadgets.common.capability.ConfigEnergyStorage;
import java.util.function.IntSupplier;

public abstract class CappedEnergyStorage
extends ConfigEnergyStorage {
    private int curReceiveCap;
    private int curExtractCap;

    public CappedEnergyStorage(IntSupplier capacitySupplier, IntSupplier extractSupplier, IntSupplier receiveSupplier) {
        super(capacitySupplier, extractSupplier, receiveSupplier);
        this.resetExtractCap();
        this.resetReceiveCap();
    }

    public void resetExtractCap() {
        this.curExtractCap = this.getExtractSupplier().getAsInt();
    }

    public void resetReceiveCap() {
        this.curReceiveCap = this.getReceiveSupplier().getAsInt();
    }

    @Override
    protected int evaluateEnergyExtracted(int maxExtract, boolean simulate) {
        int extract = Math.min(super.evaluateEnergyExtracted(maxExtract, simulate), this.curExtractCap);
        if (!simulate) {
            this.curExtractCap -= extract;
        }
        return extract;
    }

    @Override
    protected int evaluateEnergyReceived(int maxReceive, boolean simulate) {
        int receive = Math.min(super.evaluateEnergyReceived(maxReceive, simulate), this.curReceiveCap);
        if (!simulate) {
            this.curReceiveCap -= receive;
        }
        return receive;
    }
}

