/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.blocks;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets.common.items.ITemplate;
import com.direwolf20.buildinggadgets.common.items.Template;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketBlockMap;
import com.direwolf20.buildinggadgets.common.registry.objects.BGItems;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.blocks.BlockMap;
import com.direwolf20.buildinggadgets.common.util.blocks.BlockMapIntState;
import com.direwolf20.buildinggadgets.common.util.buffers.PasteToolBufferBuilder;
import com.direwolf20.buildinggadgets.common.util.tools.UniqueItem;
import com.direwolf20.buildinggadgets.common.world.WorldSave;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;

public class TemplateManagerCommands {
    private static final Set<Item> allowedItemsRight = Stream.of(Items.field_151121_aF, BGItems.template).collect(Collectors.toSet());

    public static void loadTemplate(TemplateManagerContainer container, PlayerEntity player) {
        ItemStack itemStack0 = container.func_75139_a(0).func_75211_c();
        ItemStack itemStack1 = container.func_75139_a(1).func_75211_c();
        if (!(itemStack0.func_77973_b() instanceof ITemplate) || !allowedItemsRight.contains(itemStack1.func_77973_b())) {
            return;
        }
        ITemplate template = (ITemplate)itemStack0.func_77973_b();
        if (itemStack1.func_77973_b().equals(Items.field_151121_aF)) {
            return;
        }
        World world = player.field_70170_p;
        BlockPos startPos = template.getStartPos(itemStack1);
        BlockPos endPos = template.getEndPos(itemStack1);
        Multiset<UniqueItem> tagMap = template.getItemCountMap(itemStack1);
        String UUIDTemplate = BGItems.template.getUUID(itemStack1);
        if (UUIDTemplate == null) {
            return;
        }
        WorldSave worldSave = WorldSave.getWorldSave(world);
        WorldSave templateWorldSave = WorldSave.getTemplateWorldSave(world);
        template.setStartPos(itemStack0, startPos);
        template.setEndPos(itemStack0, endPos);
        template.setItemCountMap(itemStack0, tagMap);
        String UUID = template.getUUID(itemStack0);
        if (UUID == null) {
            return;
        }
        CompoundNBT templateTagCompound = templateWorldSave.getCompoundFromUUID(UUIDTemplate);
        CompoundNBT tagCompound = templateTagCompound.func_74737_b();
        template.incrementCopyCounter(itemStack0);
        tagCompound.func_74768_a("copy_count", template.getCopyCounter(itemStack0));
        tagCompound.func_74778_a("uuid", template.getUUID(itemStack0));
        tagCompound.func_74778_a("owner", player.func_200200_C_().getString());
        if (template.equals(BGItems.gadgetCopyPaste)) {
            worldSave.addToMap(UUID, tagCompound);
        } else {
            templateWorldSave.addToMap(UUID, tagCompound);
            Template.setName(itemStack0, Template.getName(itemStack1));
        }
        container.func_75141_a(0, itemStack0);
        PacketHandler.sendTo(new PacketBlockMap(tagCompound), (ServerPlayerEntity)player);
    }

    public static void saveTemplate(TemplateManagerContainer container, PlayerEntity player, String templateName) {
        ItemStack templateStack;
        ItemStack itemStack0 = container.func_75139_a(0).func_75211_c();
        ItemStack itemStack1 = container.func_75139_a(1).func_75211_c();
        if (itemStack0.func_190926_b() && itemStack1.func_77973_b() instanceof Template && !templateName.isEmpty()) {
            Template.setName(itemStack1, templateName);
            container.func_75141_a(1, itemStack1);
            return;
        }
        if (!(itemStack0.func_77973_b() instanceof ITemplate) || !allowedItemsRight.contains(itemStack1.func_77973_b())) {
            return;
        }
        ITemplate template = (ITemplate)itemStack0.func_77973_b();
        World world = player.field_70170_p;
        if (itemStack1.func_77973_b().equals(Items.field_151121_aF)) {
            templateStack = new ItemStack((IItemProvider)BGItems.template, 1);
            container.func_75141_a(1, templateStack);
        }
        if (!container.func_75139_a(1).func_75211_c().func_77973_b().equals(BGItems.template)) {
            return;
        }
        templateStack = container.func_75139_a(1).func_75211_c();
        WorldSave worldSave = WorldSave.getWorldSave(world);
        WorldSave templateWorldSave = WorldSave.getTemplateWorldSave(world);
        String UUID = template.getUUID(itemStack0);
        String UUIDTemplate = BGItems.template.getUUID(templateStack);
        if (UUID == null) {
            return;
        }
        if (UUIDTemplate == null) {
            return;
        }
        boolean isTool = itemStack0.func_77973_b().equals(BGItems.gadgetCopyPaste);
        CompoundNBT tagCompound = isTool ? worldSave.getCompoundFromUUID(UUID) : templateWorldSave.getCompoundFromUUID(UUID);
        CompoundNBT templateTagCompound = tagCompound.func_74737_b();
        template.incrementCopyCounter(templateStack);
        templateTagCompound.func_74768_a("copy_count", template.getCopyCounter(templateStack));
        templateTagCompound.func_74778_a("uuid", BGItems.template.getUUID(templateStack));
        templateWorldSave.addToMap(UUIDTemplate, templateTagCompound);
        BlockPos startPos = template.getStartPos(itemStack0);
        BlockPos endPos = template.getEndPos(itemStack0);
        Multiset<UniqueItem> tagMap = template.getItemCountMap(itemStack0);
        template.setStartPos(templateStack, startPos);
        template.setEndPos(templateStack, endPos);
        template.setItemCountMap(templateStack, tagMap);
        if (isTool) {
            Template.setName(templateStack, templateName);
        } else if (templateName.isEmpty()) {
            Template.setName(templateStack, Template.getName(itemStack0));
        } else {
            Template.setName(templateStack, templateName);
        }
        container.func_75141_a(1, templateStack);
        PacketHandler.sendTo(new PacketBlockMap(templateTagCompound), (ServerPlayerEntity)player);
    }

    public static void pasteTemplate(TemplateManagerContainer container, PlayerEntity player, CompoundNBT sentTagCompound, String templateName) {
        ItemStack templateStack;
        ItemStack itemStack1 = container.func_75139_a(1).func_75211_c();
        if (!allowedItemsRight.contains(itemStack1.func_77973_b())) {
            return;
        }
        World world = player.field_70170_p;
        if (itemStack1.func_77973_b().equals(Items.field_151121_aF)) {
            templateStack = new ItemStack((IItemProvider)BGItems.template, 1);
            container.func_75141_a(1, templateStack);
        }
        if (!container.func_75139_a(1).func_75211_c().func_77973_b().equals(BGItems.template)) {
            return;
        }
        templateStack = container.func_75139_a(1).func_75211_c();
        WorldSave templateWorldSave = WorldSave.getTemplateWorldSave(world);
        Template template = BGItems.template;
        String UUIDTemplate = template.getUUID(templateStack);
        if (UUIDTemplate == null) {
            return;
        }
        CompoundNBT templateTagCompound = sentTagCompound.func_74737_b();
        BlockPos startPos = GadgetUtils.getPOSFromNBT(templateTagCompound, "start_pos");
        BlockPos endPos = GadgetUtils.getPOSFromNBT(templateTagCompound, "end_pos");
        template.incrementCopyCounter(templateStack);
        templateTagCompound.func_74768_a("copy_count", template.getCopyCounter(templateStack));
        templateTagCompound.func_74778_a("uuid", template.getUUID(templateStack));
        ListNBT MapIntStateTag = (ListNBT)templateTagCompound.func_74781_a("block_palette");
        BlockMapIntState mapIntState = new BlockMapIntState();
        mapIntState.getIntStateMapFromNBT(MapIntStateTag);
        mapIntState.makeStackMapFromStateMap(player);
        templateTagCompound.func_218657_a("map_int_stack", (INBT)mapIntState.putIntStackMapIntoNBT());
        templateTagCompound.func_74778_a("owner", player.func_200200_C_().getString());
        HashMultiset itemCountMap = HashMultiset.create();
        Map<BlockState, UniqueItem> intStackMap = mapIntState.intStackMap;
        List<BlockMap> blockMapList = GadgetCopyPaste.getBlockMapList(templateTagCompound);
        for (BlockMap blockMap : blockMapList) {
            UniqueItem uniqueItem = intStackMap.get(blockMap.state.getState());
            if (uniqueItem == null) continue;
            List drops = Block.func_220077_a((BlockState)blockMap.state.getState(), (ServerWorld)((ServerWorld)world), (BlockPos)blockMap.pos, (TileEntity)world.func_175625_s(blockMap.pos), (Entity)player, (ItemStack)ItemStack.field_190927_a);
            int neededItems = 0;
            for (ItemStack drop : drops) {
                if (!drop.func_77973_b().equals(uniqueItem.getItem())) continue;
                ++neededItems;
            }
            if (neededItems == 0) {
                neededItems = 1;
            }
            if (uniqueItem.getItem() == Items.field_190931_a) continue;
            itemCountMap.add((Object)uniqueItem, neededItems);
        }
        templateWorldSave.addToMap(UUIDTemplate, templateTagCompound);
        template.setStartPos(templateStack, startPos);
        template.setEndPos(templateStack, endPos);
        template.setItemCountMap(templateStack, (Multiset)itemCountMap);
        Template.setName(templateStack, templateName);
        container.func_75141_a(1, templateStack);
        PacketHandler.sendTo(new PacketBlockMap(templateTagCompound), (ServerPlayerEntity)player);
    }

    public static void copyTemplate(TemplateManagerContainer container) {
        ItemStack itemStack0 = container.func_75139_a(0).func_75211_c();
        if (itemStack0.func_77973_b() instanceof ITemplate) {
            CompoundNBT tagCompound = PasteToolBufferBuilder.getTagFromUUID(BGItems.gadgetCopyPaste.getUUID(itemStack0));
            if (tagCompound == null) {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + new TranslationTextComponent("message.gadget.copyfailed", new Object[0]).func_150261_e()), false);
                return;
            }
            CompoundNBT newCompound = new CompoundNBT();
            newCompound.func_74783_a("i2state_id", tagCompound.func_74759_k("i2state_id"));
            newCompound.func_74783_a("i2pos", tagCompound.func_74759_k("i2pos"));
            newCompound.func_218657_a("block_palette", (INBT)tagCompound.func_74775_l("block_palette"));
            GadgetUtils.writePOSToNBT(newCompound, GadgetUtils.getPOSFromNBT(tagCompound, "start_pos"), "start_pos", DimensionType.field_223227_a_);
            GadgetUtils.writePOSToNBT(newCompound, GadgetUtils.getPOSFromNBT(tagCompound, "end_pos"), "end_pos", DimensionType.field_223227_a_);
            try {
                if (GadgetUtils.getPasteStream(newCompound, tagCompound.func_74779_i("template_name")) != null) {
                    Minecraft.func_71410_x().field_195559_v.func_197960_a(newCompound.toString());
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + new TranslationTextComponent("message.gadget.copysuccess", new Object[0]).func_150261_e()), false);
                } else {
                    TemplateManagerCommands.pasteIsTooLarge();
                }
            }
            catch (IOException e) {
                BuildingGadgets.LOG.error("Failed to evaluate template network size. Template will be considered too large.", (Throwable)e);
                TemplateManagerCommands.pasteIsTooLarge();
            }
        }
    }

    private static void pasteIsTooLarge() {
        Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + new TranslationTextComponent("message.gadget.pastetoobig", new Object[0]).func_150261_e()), false);
    }
}

