/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.blocks;

import com.direwolf20.buildinggadgets.common.registry.objects.BGBlocks;
import com.direwolf20.buildinggadgets.common.tiles.ConstructionBlockTileEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class ConstructionBlock
extends Block {
    public static final IProperty<Boolean> BRIGHT = BooleanProperty.func_177716_a((String)"bright");
    public static final IProperty<Boolean> NEIGHBOR_BRIGHTNESS = BooleanProperty.func_177716_a((String)"neighbor_brightness");
    public static final IProperty<Boolean> AMBIENT_OCCLUSION = BooleanProperty.func_177716_a((String)"ambient_occlusion");

    public ConstructionBlock(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(BRIGHT, (Comparable)Boolean.valueOf(true))).func_206870_a(NEIGHBOR_BRIGHTNESS, (Comparable)Boolean.valueOf(false))).func_206870_a(AMBIENT_OCCLUSION, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_208619_r() {
        return true;
    }

    @Deprecated
    public boolean func_200124_e(BlockState state) {
        boolean bright = (Boolean)state.func_177229_b(BRIGHT);
        return !bright;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{BRIGHT, NEIGHBOR_BRIGHTNESS, AMBIENT_OCCLUSION});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return BGBlocks.BGTileEntities.CONSTRUCTION_BLOCK_TYPE.func_200968_a();
    }

    public boolean isMimicNull(BlockState mimicBlock) {
        return mimicBlock == null || mimicBlock == Blocks.field_150350_a.func_176223_P();
    }

    @Nullable
    private BlockState getActualMimicBlock(IBlockReader blockAccess, BlockPos pos) {
        TileEntity te = blockAccess.func_175625_s(pos);
        if (te instanceof ConstructionBlockTileEntity) {
            return ((ConstructionBlockTileEntity)te).getActualBlockData().getState();
        }
        return null;
    }

    @Deprecated
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean canRenderInLayer(BlockState state, BlockRenderLayer layer) {
        return true;
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Boolean bright = (Boolean)state.func_177229_b(BRIGHT);
        if (bright.booleanValue()) {
            return 0;
        }
        return 255;
    }

    public boolean doesSideBlockRendering(BlockState state, IEnviromentBlockReader world, BlockPos pos, Direction face) {
        BlockState mimic = this.getActualMimicBlock((IBlockReader)world, pos);
        return !this.isMimicNull(mimic) ? mimic.doesSideBlockRendering(world, pos, face) : super.doesSideBlockRendering(state, world, pos, face);
    }

    public void initColorHandler(BlockColors blockColors) {
        blockColors.func_186722_a((state, world, pos, tintIndex) -> {
            if (world != null) {
                BlockState mimicBlock = this.getActualMimicBlock((IBlockReader)world, pos);
                try {
                    return blockColors.func_216860_a(mimicBlock, world, pos, tintIndex);
                }
                catch (Exception var8) {
                    return -1;
                }
            }
            return -1;
        }, new Block[]{this});
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext selectionContext) {
        BlockState mimic = this.getActualMimicBlock(worldIn, pos);
        return !this.isMimicNull(mimic) ? mimic.func_196952_d(worldIn, pos) : super.func_220071_b(state, worldIn, pos, selectionContext);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        BlockState mimic = this.getActualMimicBlock((IBlockReader)worldIn, pos);
        if (!this.isMimicNull(mimic)) {
            mimic.func_196950_a(worldIn, pos, entityIn);
        } else {
            super.func_196262_a(state, worldIn, pos, entityIn);
        }
    }

    public void func_196242_c(BlockState stateIn, IWorld worldIn, BlockPos pos, int flags) {
        BlockState mimic = this.getActualMimicBlock((IBlockReader)worldIn, pos);
        if (!this.isMimicNull(mimic)) {
            mimic.func_196946_a(worldIn, pos, flags);
        } else {
            super.func_196242_c(stateIn, worldIn, pos, flags);
        }
    }

    public void func_196248_b(BlockState state, IWorld worldIn, BlockPos pos, int flags) {
        BlockState mimic = this.getActualMimicBlock((IBlockReader)worldIn, pos);
        if (!this.isMimicNull(mimic)) {
            mimic.func_196948_b(worldIn, pos, flags);
        } else {
            super.func_196248_b(state, worldIn, pos, flags);
        }
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        BlockState mimic = this.getActualMimicBlock(worldIn, pos);
        return !this.isMimicNull(mimic) ? mimic.func_196957_g(worldIn, pos, type) : super.func_196266_a(state, worldIn, pos, type);
    }

    public float func_176195_g(BlockState blockState, IBlockReader worldIn, BlockPos pos) {
        BlockState mimic = this.getActualMimicBlock(worldIn, pos);
        return !this.isMimicNull(mimic) ? mimic.func_185887_b(worldIn, pos) : super.func_176195_g(blockState, worldIn, pos);
    }

    public boolean func_149716_u() {
        return true;
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext selectionContext) {
        BlockState mimic = this.getActualMimicBlock(worldIn, pos);
        return !this.isMimicNull(mimic) ? mimic.func_196954_c(worldIn, pos) : super.func_220053_a(state, worldIn, pos, selectionContext);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        BlockState mimic = this.getActualMimicBlock(worldIn, pos);
        return !this.isMimicNull(mimic) ? mimic.func_196951_e(worldIn, pos) : super.func_196247_c(state, worldIn, pos);
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        BlockState mimic = this.getActualMimicBlock(worldIn, pos);
        return !this.isMimicNull(mimic) ? mimic.func_199611_f(worldIn, pos) : super.func_199600_g(state, worldIn, pos);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        BlockState mimic = this.getActualMimicBlock(reader, pos);
        return !this.isMimicNull(mimic) ? mimic.func_200131_a(reader, pos) : super.func_200123_i(state, reader, pos);
    }

    public void func_196265_a(BlockState state, World worldIn, BlockPos pos, Random random) {
        BlockState mimic = this.getActualMimicBlock((IBlockReader)worldIn, pos);
        if (!this.isMimicNull(mimic)) {
            mimic.func_196944_b(worldIn, pos, random);
        } else {
            super.func_196265_a(state, worldIn, pos, random);
        }
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        BlockState mimic = this.getActualMimicBlock((IBlockReader)worldIn, pos);
        if (!this.isMimicNull(mimic)) {
            mimic.func_177230_c().func_196267_b(state, worldIn, pos, random);
        } else {
            super.func_196267_b(state, worldIn, pos, random);
        }
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        BlockState mimic = this.getActualMimicBlock((IBlockReader)worldIn, pos);
        if (!this.isMimicNull(mimic)) {
            try {
                mimic.func_177230_c().func_180655_c(stateIn, worldIn, pos, rand);
            }
            catch (Exception var8) {
                super.func_180655_c(stateIn, worldIn, pos, rand);
            }
        } else {
            super.func_180655_c(stateIn, worldIn, pos, rand);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        BlockState mimic = this.getActualMimicBlock((IBlockReader)worldIn, pos);
        if (!this.isMimicNull(mimic)) {
            mimic.func_215697_a(worldIn, pos, blockIn, fromPos, p_220069_6_);
        } else {
            super.func_220069_a(state, worldIn, pos, blockIn, fromPos, p_220069_6_);
        }
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        BlockState mimic = this.getActualMimicBlock(worldIn, pos);
        return !this.isMimicNull(mimic) ? mimic.func_185903_a(player, worldIn, pos) : super.func_180647_a(state, player, worldIn, pos);
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        BlockState mimic = this.getActualMimicBlock((IBlockReader)worldIn, pos);
        return !this.isMimicNull(mimic) ? super.func_220051_a(state, worldIn, pos, player, hand, rayTraceResult) : super.func_220051_a(state, worldIn, pos, player, hand, rayTraceResult);
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        BlockState mimic = this.getActualMimicBlock((IBlockReader)worldIn, pos);
        if (!this.isMimicNull(mimic)) {
            mimic.func_177230_c().func_176199_a(worldIn, pos, entityIn);
        } else {
            super.func_176199_a(worldIn, pos, entityIn);
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return super.func_196258_a(context);
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        BlockState mimic = this.getActualMimicBlock((IBlockReader)worldIn, pos);
        if (!this.isMimicNull(mimic)) {
            super.func_196270_a(state, worldIn, pos, player);
        } else {
            super.func_196270_a(state, worldIn, pos, player);
        }
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        BlockState mimic = this.getActualMimicBlock(blockAccess, pos);
        return !this.isMimicNull(mimic) ? mimic.func_185911_a(blockAccess, pos, side) : super.func_180656_a(blockState, blockAccess, pos, side);
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        BlockState mimic = this.getActualMimicBlock(blockAccess, pos);
        return !this.isMimicNull(mimic) ? mimic.func_185893_b(blockAccess, pos, side) : super.func_176211_b(blockState, blockAccess, pos, side);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        BlockState mimic = this.getActualMimicBlock((IBlockReader)worldIn, pos);
        if (!this.isMimicNull(mimic)) {
            mimic.func_177230_c().func_180658_a(worldIn, pos, entityIn, fallDistance);
        } else {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        }
    }

    public void func_176224_k(World worldIn, BlockPos pos) {
        BlockState mimic = this.getActualMimicBlock((IBlockReader)worldIn, pos);
        if (!this.isMimicNull(mimic)) {
            mimic.func_177230_c().func_176224_k(worldIn, pos);
        } else {
            super.func_176224_k(worldIn, pos);
        }
    }

    public Vec3d func_190949_e(BlockState state, IBlockReader worldIn, BlockPos pos) {
        BlockState mimic = this.getActualMimicBlock(worldIn, pos);
        return !this.isMimicNull(mimic) ? mimic.func_191059_e(worldIn, pos) : super.func_190949_e(state, worldIn, pos);
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState mimic = this.getActualMimicBlock(world, pos);
        return !this.isMimicNull(mimic) ? mimic.canSustainPlant(world, pos, facing, plantable) : super.canSustainPlant(state, world, pos, facing, plantable);
    }

    public boolean func_220081_d(BlockState state, IBlockReader world, BlockPos pos) {
        BlockState mimicBlock = this.getActualMimicBlock(world, pos);
        if (mimicBlock == null) {
            return super.func_220081_d(state, world, pos);
        }
        try {
            return mimicBlock.func_177230_c().func_220081_d(mimicBlock, world, pos);
        }
        catch (Exception var8) {
            return super.func_220081_d(state, world, pos);
        }
    }
}

