/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.events;

import com.direwolf20.buildinggadgets.client.RemoteInventoryCache;
import com.direwolf20.buildinggadgets.common.items.ITemplate;
import com.direwolf20.buildinggadgets.common.registry.objects.BGItems;
import com.direwolf20.buildinggadgets.common.util.helpers.InventoryHelper;
import com.direwolf20.buildinggadgets.common.util.tools.UniqueItem;
import com.google.common.collect.Multiset;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="buildinggadgets", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class EventTooltip {
    private static final int STACKS_PER_LINE = 8;
    private static RemoteInventoryCache cache = new RemoteInventoryCache(true);

    public static void setCache(Multiset<UniqueItem> cache) {
        EventTooltip.cache.setCache(cache);
    }

    private static void tooltipIfShift(List<ITextComponent> tooltip, Runnable r) {
        if (Screen.hasShiftDown()) {
            r.run();
        }
    }

    public static void addTemplatePadding(ItemStack stack, List<ITextComponent> tooltip) {
        Minecraft mc = Minecraft.func_71410_x();
        if (stack.func_77973_b() instanceof ITemplate) {
            int count;
            ITemplate template = (ITemplate)stack.func_77973_b();
            String UUID2 = template.getUUID(stack);
            if (UUID2 == null) {
                return;
            }
            Multiset<UniqueItem> itemCountMap = template.getItemCountMap(stack);
            HashMap<ItemStack, Integer> itemStackCount = new HashMap<ItemStack, Integer>();
            for (Multiset.Entry entry : itemCountMap.entrySet()) {
                ItemStack itemStack = new ItemStack((IItemProvider)((UniqueItem)entry.getElement()).getItem(), 1);
                itemStackCount.put(itemStack, entry.getCount());
            }
            ArrayList list = new ArrayList(itemStackCount.entrySet());
            int totalMissing = 0;
            for (Map.Entry entry : list) {
                int hasAmt = InventoryHelper.countItem((ItemStack)entry.getKey(), (PlayerEntity)Minecraft.func_71410_x().field_71439_g, cache);
                if (hasAmt >= (Integer)entry.getValue()) continue;
                totalMissing += Math.abs((Integer)entry.getValue() - hasAmt);
            }
            int n = count = totalMissing > 0 ? itemStackCount.size() + 1 : itemStackCount.size();
            if (count > 0) {
                EventTooltip.tooltipIfShift(tooltip, () -> {
                    int lines = ((count - 1) / 8 + 1) * 2;
                    int width = Math.min(8, count) * 18;
                    String spaces = "\u00a7r\u00a7r\u00a7r\u00a7r\u00a7r";
                    while (mc.field_71466_p.func_78256_a(spaces) < width) {
                        spaces = spaces + " ";
                    }
                    for (int j = 0; j < lines; ++j) {
                        tooltip.add((ITextComponent)new StringTextComponent(spaces));
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onDrawTooltip(RenderTooltipEvent.PostText event) {
        ItemStack stack = event.getStack();
        if (stack.func_77973_b() instanceof ITemplate && Screen.hasShiftDown()) {
            Object s;
            long totalMissing = 0L;
            Multiset<UniqueItem> itemCountMap = ((ITemplate)stack.func_77973_b()).getItemCountMap(stack);
            HashMap<ItemStack, Integer> itemStackCount = new HashMap<ItemStack, Integer>();
            for (Multiset.Entry entry2 : itemCountMap.entrySet()) {
                ItemStack itemStack = new ItemStack((IItemProvider)((UniqueItem)entry2.getElement()).getItem(), 1);
                itemStackCount.put(itemStack, entry2.getCount());
            }
            ArrayList list = new ArrayList(itemStackCount.entrySet());
            Comparator<Map.Entry> comparator = Comparator.comparing(entry -> (Integer)entry.getValue());
            comparator = comparator.reversed();
            comparator = comparator.thenComparing(Comparator.comparing(entry -> Item.func_150891_b((Item)((ItemStack)entry.getKey()).func_77973_b())));
            list.sort(comparator);
            int bx = event.getX();
            int by = event.getY();
            List tooltip = event.getLines();
            Iterator iterator = tooltip.iterator();
            while (iterator.hasNext() && !((String)(s = (String)iterator.next())).trim().equals("\u00a77\u00a7r\u00a7r\u00a7r\u00a7r\u00a7r")) {
                by += 7;
            }
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)770, (int)771);
            int j = 0;
            for (Map.Entry entry2 : list) {
                int hasAmt = InventoryHelper.countItem((ItemStack)entry2.getKey(), (PlayerEntity)Minecraft.func_71410_x().field_71439_g, cache);
                int x = bx + j % 8 * 18;
                int y = by + j / 8 * 20;
                totalMissing += (long)EventTooltip.renderRequiredBlocks((ItemStack)entry2.getKey(), x, y, hasAmt, (Integer)entry2.getValue());
                ++j;
            }
            if (totalMissing > 0L) {
                ItemStack pasteItemStack = new ItemStack((IItemProvider)BGItems.constructionPaste);
                int n = InventoryHelper.countPaste((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
                int x = bx + j % 8 * 18;
                int y = by + j / 8 * 20;
                EventTooltip.renderRequiredBlocks(pasteItemStack, x, y, n, InventoryHelper.longToInt(totalMissing));
                ++j;
            }
        }
    }

    private static int renderRequiredBlocks(ItemStack itemStack, int x, int y, int count, int req) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.disableDepthTest();
        ItemRenderer render = mc.func_175599_af();
        RenderHelper.func_74520_c();
        render.func_175042_a(itemStack, x, y);
        String s1 = req == Integer.MAX_VALUE ? "\u221e" : Integer.toString(req);
        int w1 = mc.field_71466_p.func_78256_a(s1);
        int color = 0xFFFFFF;
        boolean hasReq = req > 0;
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(x + 8 - w1 / 4), (float)(y + (hasReq ? 12 : 14)), (float)0.0f);
        GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        mc.field_71466_p.func_175063_a(s1, 0.0f, 0.0f, color);
        GlStateManager.popMatrix();
        int missingCount = 0;
        if (hasReq && count < req) {
            String fs = Integer.toString(req - count);
            String s2 = "(" + fs + ")";
            int w2 = mc.field_71466_p.func_78256_a(s2);
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)(x + 8 - w2 / 4), (float)(y + 17), (float)0.0f);
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            mc.field_71466_p.func_175063_a(s2, 0.0f, 0.0f, 0xFF0000);
            GlStateManager.popMatrix();
            missingCount = req - count;
        }
        GlStateManager.enableDepthTest();
        return missingCount;
    }
}

