/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.template.transaction;

import com.direwolf20.buildinggadgets.api.building.BlockData;
import com.direwolf20.buildinggadgets.api.building.PlacementTarget;
import com.direwolf20.buildinggadgets.api.building.view.IBuildContext;
import com.direwolf20.buildinggadgets.api.exceptions.OperatorExecutionFailedException;
import com.direwolf20.buildinggadgets.api.exceptions.TransactionExecutionException;
import com.direwolf20.buildinggadgets.api.exceptions.TransactionInvalidException;
import com.direwolf20.buildinggadgets.api.serialisation.TemplateHeader;
import com.direwolf20.buildinggadgets.api.template.ITemplate;
import com.direwolf20.buildinggadgets.api.template.transaction.ITemplateTransaction;
import com.direwolf20.buildinggadgets.api.template.transaction.ITransactionExecutionContext;
import com.direwolf20.buildinggadgets.api.template.transaction.ITransactionOperator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;

public abstract class AbsTemplateTransaction
implements ITemplateTransaction {
    private List<ITransactionOperator> operators = new ArrayList<ITransactionOperator>();
    private boolean valid = true;

    @Override
    public ITemplateTransaction operate(ITransactionOperator operator) {
        Preconditions.checkState((boolean)this.isValid(), (Object)"Transaction has already been executed!");
        this.operators.add(Objects.requireNonNull(operator));
        return this;
    }

    @Override
    public ITemplate execute(@Nullable IBuildContext context) throws TransactionExecutionException {
        if (!this.isValid()) {
            throw new TransactionInvalidException("Cannot execute TemplateTransaction twice!");
        }
        this.invalidate();
        OperatorOrdering ordering = this.createOrdering(this.operators);
        ITransactionExecutionContext exContext = this.createContext();
        boolean changed = false;
        LinkedList<OperatorOrdering> orderingHistory = new LinkedList<OperatorOrdering>();
        while (ordering.hasActingTransformers()) {
            this.transformData(exContext, ordering);
            exContext = this.createContext();
            this.transformPositions(exContext, ordering);
            exContext = this.createContext();
            this.transformTargets(exContext, ordering);
            exContext = this.createContext();
            this.transformHeader(exContext, ordering);
            orderingHistory.add(ordering);
            exContext = this.createContext();
            ordering = this.createOrdering(this.operators);
            changed = true;
        }
        return this.createTemplate(exContext, orderingHistory, context, changed);
    }

    protected void invalidate() {
        this.valid = false;
    }

    protected boolean isValid() {
        return this.valid;
    }

    protected OperatorOrdering createOrdering(Collection<ITransactionOperator> operators) throws TransactionExecutionException {
        return new OperatorOrdering(operators);
    }

    protected abstract ITransactionExecutionContext createContext() throws TransactionExecutionException;

    protected void failOperatorExecution(ITransactionOperator operator, @Nullable Throwable cause) throws TransactionExecutionException {
        throw new OperatorExecutionFailedException("Failed to execute Transaction Operator of type " + operator.getClass().getName(), cause, operator);
    }

    protected Map<BlockPos, BlockData> createData(ITransactionExecutionContext exContext, OperatorOrdering ordering) throws TransactionExecutionException {
        HashMap<BlockPos, BlockData> created = new HashMap<BlockPos, BlockData>();
        for (ITransactionOperator operator : ordering.getDataCreators()) {
            LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
            BlockPos current = operator.createPos(exContext);
            while (current != null) {
                positions.add(current);
                try {
                    current = operator.createPos(exContext);
                }
                catch (Exception e) {
                    this.failOperatorExecution(operator, e);
                }
            }
            for (BlockPos pos : positions) {
                try {
                    created.put(pos, Objects.requireNonNull(operator.createDataForPos(exContext, pos), "Operator " + operator + " may not return null for position which he created himself!"));
                }
                catch (Exception e) {
                    this.failOperatorExecution(operator, e);
                }
            }
        }
        return created;
    }

    protected abstract void mergeCreated(ITransactionExecutionContext var1, OperatorOrdering var2, Map<BlockPos, BlockData> var3);

    protected abstract void transformAllData(ITransactionExecutionContext var1, OperatorOrdering var2, DataTransformer var3) throws TransactionExecutionException;

    protected abstract void transformAllPositions(ITransactionExecutionContext var1, OperatorOrdering var2, PositionTransformer var3) throws TransactionExecutionException;

    protected abstract void transformAllTargets(ITransactionExecutionContext var1, OperatorOrdering var2, TargetTransformer var3) throws TransactionExecutionException;

    protected abstract void updateHeader(ITransactionExecutionContext var1, OperatorOrdering var2, HeaderTransformer var3) throws TransactionExecutionException;

    protected abstract ITemplate createTemplate(ITransactionExecutionContext var1, Queue<OperatorOrdering> var2, @Nullable IBuildContext var3, boolean var4) throws TransactionExecutionException;

    protected void performCreateData(ITransactionExecutionContext exContext, OperatorOrdering ordering) throws TransactionExecutionException {
        Map<BlockPos, BlockData> created = this.createData(exContext, ordering);
        if (!created.isEmpty()) {
            this.mergeCreated(exContext, ordering, created);
        }
    }

    protected void transformData(ITransactionExecutionContext exContext, OperatorOrdering ordering) throws TransactionExecutionException {
        if (ordering.getDataTransformers().isEmpty()) {
            return;
        }
        this.transformAllData(exContext, ordering, d -> {
            for (ITransactionOperator operator : ordering.getDataTransformers()) {
                try {
                    d = operator.transformData(exContext, d);
                }
                catch (Exception e) {
                    this.failOperatorExecution(operator, e);
                }
                if (d != null) continue;
                break;
            }
            return d;
        });
    }

    protected void transformPositions(ITransactionExecutionContext exContext, OperatorOrdering ordering) throws TransactionExecutionException {
        if (ordering.getPositionTransformers().isEmpty()) {
            return;
        }
        this.transformAllPositions(exContext, ordering, (p, d) -> {
            for (ITransactionOperator operator : ordering.getPositionTransformers()) {
                try {
                    p = operator.transformPos(exContext, p, d);
                }
                catch (Exception e) {
                    this.failOperatorExecution(operator, e);
                }
                if (p != null) continue;
                break;
            }
            return p;
        });
    }

    protected void transformTargets(ITransactionExecutionContext exContext, OperatorOrdering ordering) throws TransactionExecutionException {
        if (ordering.getTargetTransformers().isEmpty()) {
            return;
        }
        this.transformAllTargets(exContext, ordering, target -> {
            for (ITransactionOperator operator : ordering.getTargetTransformers()) {
                try {
                    target = operator.transformTarget(exContext, target);
                }
                catch (Exception e) {
                    this.failOperatorExecution(operator, e);
                }
                if (target != null) continue;
                break;
            }
            return target;
        });
    }

    protected void transformHeader(ITransactionExecutionContext exContext, OperatorOrdering ordering) throws TransactionExecutionException {
        this.updateHeader(exContext, ordering, header -> {
            for (ITransactionOperator operator : ordering.getHeaderTransformers()) {
                try {
                    header = Objects.requireNonNull(operator.transformHeader(exContext, header), "Operator " + operator + " may not return a null TemplateHeader!");
                }
                catch (Exception e) {
                    this.failOperatorExecution(operator, e);
                }
            }
            return header;
        });
    }

    public static class OperatorOrdering {
        private final ImmutableList<ITransactionOperator> headerTransformers;
        private final ImmutableList<ITransactionOperator> positionTransformers;
        private final ImmutableList<ITransactionOperator> dataTransformers;
        private final ImmutableList<ITransactionOperator> targetTransformers;
        private final ImmutableList<ITransactionOperator> dataCreators;
        private final boolean hasActingTransformers;

        protected OperatorOrdering(Collection<ITransactionOperator> operators) {
            this.headerTransformers = (ImmutableList)operators.stream().filter(op -> op.remainingOperations().contains((Object)ITransactionOperator.TransactionOperation.TRANSFORM_HEADER)).collect(ImmutableList.toImmutableList());
            this.positionTransformers = (ImmutableList)operators.stream().filter(op -> op.remainingOperations().contains((Object)ITransactionOperator.TransactionOperation.TRANSFORM_POSITION)).collect(ImmutableList.toImmutableList());
            this.dataTransformers = (ImmutableList)operators.stream().filter(op -> op.remainingOperations().contains((Object)ITransactionOperator.TransactionOperation.TRANSFORM_DATA)).collect(ImmutableList.toImmutableList());
            this.targetTransformers = (ImmutableList)operators.stream().filter(op -> op.remainingOperations().contains((Object)ITransactionOperator.TransactionOperation.TRANSFORM_TARGET)).collect(ImmutableList.toImmutableList());
            this.dataCreators = (ImmutableList)operators.stream().filter(op -> op.remainingOperations().contains((Object)ITransactionOperator.TransactionOperation.CREATE_DATA)).collect(ImmutableList.toImmutableList());
            this.hasActingTransformers = !this.headerTransformers.isEmpty() || !this.positionTransformers.isEmpty() || !this.dataTransformers.isEmpty() || !this.targetTransformers.isEmpty() || !this.dataCreators.isEmpty();
        }

        public ImmutableList<ITransactionOperator> getHeaderTransformers() {
            return this.headerTransformers;
        }

        public ImmutableList<ITransactionOperator> getPositionTransformers() {
            return this.positionTransformers;
        }

        public ImmutableList<ITransactionOperator> getDataTransformers() {
            return this.dataTransformers;
        }

        public ImmutableList<ITransactionOperator> getDataCreators() {
            return this.dataCreators;
        }

        public ImmutableList<ITransactionOperator> getTargetTransformers() {
            return this.targetTransformers;
        }

        public boolean hasActingTransformers() {
            return this.hasActingTransformers;
        }
    }

    @FunctionalInterface
    protected static interface HeaderTransformer {
        public TemplateHeader transformHeader(TemplateHeader var1) throws TransactionExecutionException;
    }

    @FunctionalInterface
    protected static interface TargetTransformer {
        @Nullable
        public PlacementTarget transformTarget(PlacementTarget var1) throws TransactionExecutionException;
    }

    @FunctionalInterface
    protected static interface PositionTransformer {
        @Nullable
        public BlockPos transformPos(BlockPos var1, BlockData var2) throws TransactionExecutionException;
    }

    @FunctionalInterface
    protected static interface DataTransformer {
        @Nullable
        public BlockData transformData(BlockData var1) throws TransactionExecutionException;
    }
}

