/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.serialisation;

import com.direwolf20.buildinggadgets.api.building.tilesupport.ITileEntityData;
import com.direwolf20.buildinggadgets.api.building.tilesupport.NBTTileEntityData;
import com.direwolf20.buildinggadgets.api.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.api.materials.MaterialList;
import com.direwolf20.buildinggadgets.api.serialisation.ITemplateSerializer;
import com.direwolf20.buildinggadgets.api.serialisation.ITileDataSerializer;
import com.google.common.base.Preconditions;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

public final class SerialisationSupport {
    @ObjectHolder(value="buildinggadgets:dummy_serializer")
    private static ITileDataSerializer DUMMY_TILE_DATA_SERIALIZER = new DummyTileDataSerializer();
    @ObjectHolder(value="buildinggadgets:nbt_tile_data_serializer")
    private static ITileDataSerializer NBT_TILE_DATA_SERIALIZER = new NBTTileEntityDataSerializer();
    @ObjectHolder(value="buildinggadgets:immutable_template_serializer")
    private static ITemplateSerializer IMMUTABLE_TEMPLATE_SERIALIZER;
    @ObjectHolder(value="buildinggadgets:delegating_template_serializer")
    private static ITemplateSerializer DELEGATING_TEMPLATE_SERIALIZER;

    private SerialisationSupport() {
    }

    public static ITileDataSerializer dummyDataSerializer() {
        return DUMMY_TILE_DATA_SERIALIZER;
    }

    public static ITileDataSerializer nbtTileDataSerializer() {
        return NBT_TILE_DATA_SERIALIZER;
    }

    public static ITemplateSerializer immutableTemplateSerializer() {
        return IMMUTABLE_TEMPLATE_SERIALIZER;
    }

    public static ITemplateSerializer delegatingTemplateSerializer() {
        return DELEGATING_TEMPLATE_SERIALIZER;
    }

    private static final class NBTTileEntityDataSerializer
    extends ForgeRegistryEntry<ITileDataSerializer>
    implements ITileDataSerializer {
        private NBTTileEntityDataSerializer() {
        }

        @Override
        public CompoundNBT serialize(ITileEntityData data, boolean persisted) {
            Preconditions.checkArgument((boolean)(data instanceof NBTTileEntityData));
            NBTTileEntityData nbtData = (NBTTileEntityData)data;
            CompoundNBT res = new CompoundNBT();
            res.func_218657_a("data", (INBT)nbtData.getNBT());
            if (nbtData.getRequiredMaterials() != null) {
                res.func_218657_a("materials", (INBT)nbtData.getRequiredMaterials().serialize(persisted));
            }
            return res;
        }

        @Override
        public ITileEntityData deserialize(CompoundNBT tagCompound, boolean persisted) {
            CompoundNBT data = tagCompound.func_74775_l("data");
            MaterialList materialList = null;
            if (tagCompound.func_150297_b("materials", 10)) {
                materialList = MaterialList.deserialize(tagCompound.func_74775_l("materials"));
            }
            return new NBTTileEntityData(data, materialList);
        }
    }

    private static final class DummyTileDataSerializer
    extends ForgeRegistryEntry<ITileDataSerializer>
    implements ITileDataSerializer {
        private DummyTileDataSerializer() {
        }

        @Override
        public CompoundNBT serialize(ITileEntityData data, boolean persisted) {
            return new CompoundNBT();
        }

        @Override
        public ITileEntityData deserialize(CompoundNBT tagCompound, boolean persisted) {
            return TileSupport.dummyTileEntityData();
        }
    }
}

