/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.building.placement;

import com.direwolf20.buildinggadgets.api.building.Region;
import com.direwolf20.buildinggadgets.api.building.placement.ConnectedSurfaceSequence;
import com.direwolf20.buildinggadgets.api.building.placement.GridSequence;
import com.direwolf20.buildinggadgets.api.building.placement.IPositionPlacementSequence;
import com.direwolf20.buildinggadgets.api.building.placement.StairSequence;
import com.direwolf20.buildinggadgets.api.building.placement.SurfaceSequence;
import com.direwolf20.buildinggadgets.api.util.MathUtils;
import com.direwolf20.buildinggadgets.api.util.VectorUtils;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;

public final class PlacementSequences {
    private PlacementSequences() {
    }

    public static final class ConnectedSurface {
        private ConnectedSurface() {
        }

        public static IPositionPlacementSequence create(IBlockReader world, BlockPos searchingCenter, Direction side, int range, boolean fuzzy) {
            Region searchingRegion = Wall.clickedSide(searchingCenter, side, range / 2).getBoundingBox();
            return ConnectedSurface.create(world, searchingRegion, (BlockPos pos) -> pos.func_177972_a(side), searchingCenter, side, fuzzy);
        }

        public static IPositionPlacementSequence create(IBlockReader world, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, @Nullable Direction side, boolean fuzzy) {
            return new ConnectedSurfaceSequence(world, searchingRegion, searching2referenceMapper, searchingCenter, side, fuzzy);
        }

        public static IPositionPlacementSequence create(IBlockReader world, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, @Nullable Direction side, BiPredicate<BlockState, BlockPos> predicate) {
            return new ConnectedSurfaceSequence(world, searchingRegion, searching2referenceMapper, searchingCenter, side, predicate);
        }
    }

    public static final class Surface {
        private Surface() {
        }

        public static IPositionPlacementSequence create(IBlockReader world, BlockPos searchingCenter, Direction side, int range, boolean fuzzy) {
            Region searchingRegion = Wall.clickedSide(searchingCenter, side, range / 2).getBoundingBox();
            return Surface.create(world, searchingCenter, searchingRegion, pos -> pos.func_177972_a(side), fuzzy);
        }

        public static IPositionPlacementSequence create(IBlockReader world, BlockPos center, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, boolean fuzzy) {
            return new SurfaceSequence(Objects.requireNonNull(world, "Surface mode is required to have at least an IBlockReader"), Objects.requireNonNull(center), Objects.requireNonNull(searchingRegion), Objects.requireNonNull(searching2referenceMapper), fuzzy);
        }
    }

    public static final class Stair {
        private Stair() {
        }

        public static IPositionPlacementSequence create(BlockPos base, Direction horizontalAdvance, Direction verticalAdvance, int range) {
            return new StairSequence(base, horizontalAdvance, verticalAdvance, range);
        }
    }

    public static final class Grid {
        private Grid() {
        }

        public static IPositionPlacementSequence create(BlockPos base, int range, int periodSize) {
            return new GridSequence(base, range, periodSize);
        }
    }

    public static final class Wall {
        private Wall() {
        }

        public static IPositionPlacementSequence clickedSide(BlockPos center, Direction side, int radius) {
            return Wall.create(center, side, radius, null, 0);
        }

        public static IPositionPlacementSequence extendingFrom(BlockPos posHit, Direction extension, Direction flatSide, int radius, int extra) {
            Preconditions.checkArgument((extension != flatSide ? 1 : 0) != 0, (Object)("Cannot have a wall extending to " + extension + " and flat at " + flatSide));
            return Wall.create(posHit.func_177967_a(extension, radius + 1), flatSide, radius, extension, extra);
        }

        private static IPositionPlacementSequence create(BlockPos posHit, Direction side, int radius, @Nullable Direction extendingSide, int extendingSize) {
            Region createdRegion = new Region((Vec3i)posHit).expand(radius * (1 - Math.abs(side.func_82601_c())), radius * (1 - Math.abs(side.func_96559_d())), radius * (1 - Math.abs(side.func_82599_e())));
            if (extendingSize != 0 && extendingSide != null) {
                createdRegion = extendingSide.func_176743_c() == Direction.AxisDirection.POSITIVE ? new Region((Vec3i)createdRegion.getMin(), (Vec3i)createdRegion.getMax().func_177967_a(extendingSide, extendingSize)) : new Region((Vec3i)createdRegion.getMin().func_177967_a(extendingSide, extendingSize), (Vec3i)createdRegion.getMax());
            }
            return createdRegion;
        }
    }

    public static final class Column {
        private Column() {
        }

        public static IPositionPlacementSequence extendFrom(BlockPos hit, Direction side, int range) {
            return new Region((Vec3i)hit, (Vec3i)hit.func_177967_a(side, range - 1));
        }

        public static IPositionPlacementSequence centerAt(BlockPos center, Direction.Axis axis, int length) {
            Direction positive = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
            Direction negative = positive.func_176734_d();
            BlockPos base = center.func_177967_a(negative, (length - 1) / 2);
            return new Region((Vec3i)base, (Vec3i)base.func_177967_a(positive, MathUtils.floorToOdd(length) - 1));
        }

        public static IPositionPlacementSequence createAxisChasing(BlockPos source, BlockPos target, Direction.Axis axis, int maxProgression) {
            int difference = VectorUtils.getAxisValue(target, axis) - VectorUtils.getAxisValue(source, axis);
            if (difference < 0) {
                return Column.createAxisChasing(source, target, Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis), maxProgression);
            }
            return Column.createAxisChasing(source, target, Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis), maxProgression);
        }

        public static IPositionPlacementSequence createAxisChasing(BlockPos source, BlockPos target, Direction offsetDirection, int maxProgression) {
            Direction.Axis axis = offsetDirection.func_176740_k();
            int difference = VectorUtils.getAxisValue(target, axis) - VectorUtils.getAxisValue(source, axis);
            maxProgression = Math.min(Math.abs(difference), maxProgression);
            return Column.extendFrom(source, offsetDirection, maxProgression);
        }
    }
}

