/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.building.placement;

import com.direwolf20.buildinggadgets.api.building.Region;
import com.direwolf20.buildinggadgets.api.building.placement.IPositionPlacementSequence;
import com.direwolf20.buildinggadgets.api.util.VectorUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;

final class ConnectedSurfaceSequence
implements IPositionPlacementSequence {
    private final IBlockReader world;
    private final Region searchingRegion;
    private final Function<BlockPos, BlockPos> searching2referenceMapper;
    private final BlockPos searchingCenter;
    @Nullable
    private final Direction side;
    private final BiPredicate<BlockState, BlockPos> predicate;

    @VisibleForTesting
    ConnectedSurfaceSequence(IBlockReader world, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, @Nullable Direction side, boolean fuzzy) {
        this(world, searchingRegion, searching2referenceMapper, searchingCenter, side, (filter, pos) -> {
            BlockState reference = world.func_180495_p((BlockPos)searching2referenceMapper.apply((BlockPos)pos));
            boolean isAir = reference.isAir(world, pos);
            return !isAir && (fuzzy || filter == reference);
        });
    }

    ConnectedSurfaceSequence(IBlockReader world, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, @Nullable Direction side, BiPredicate<BlockState, BlockPos> predicate) {
        this.world = world;
        this.searchingRegion = searchingRegion;
        this.searching2referenceMapper = searching2referenceMapper;
        this.searchingCenter = searchingCenter;
        this.side = side;
        this.predicate = predicate;
    }

    @Override
    public Region getBoundingBox() {
        return this.searchingRegion;
    }

    @Override
    public boolean mayContain(int x, int y, int z) {
        return this.searchingRegion.mayContain(x, y, z);
    }

    @Override
    public IPositionPlacementSequence copy() {
        return new ConnectedSurfaceSequence(this.world, this.searchingRegion, this.searching2referenceMapper, this.searchingCenter, this.side, this.predicate);
    }

    @Override
    @Nonnull
    public Iterator<BlockPos> iterator() {
        final BlockState selectedBlock = this.getReferenceFor(this.searchingCenter);
        return new AbstractIterator<BlockPos>(){
            private Queue<BlockPos> queue = new LinkedList<BlockPos>();
            private Set<BlockPos> searched = new HashSet<BlockPos>(ConnectedSurfaceSequence.access$000(ConnectedSurfaceSequence.this).size());
            {
                if (this.isValid(ConnectedSurfaceSequence.this.searchingCenter)) {
                    this.queue.add(ConnectedSurfaceSequence.this.searchingCenter);
                    this.searched.add(ConnectedSurfaceSequence.this.searchingCenter);
                }
            }

            protected BlockPos computeNext() {
                if (this.queue.isEmpty()) {
                    return (BlockPos)this.endOfData();
                }
                BlockPos current = this.queue.remove();
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        if (ConnectedSurfaceSequence.this.side != null) {
                            BlockPos neighbor = VectorUtils.perpendicularSurfaceOffset(current, ConnectedSurfaceSequence.this.side, i, j);
                            this.addNeighbour(neighbor);
                            continue;
                        }
                        for (int k = -1; k <= 1; ++k) {
                            BlockPos neighbor = current.func_177982_a(i, j, k);
                            this.addNeighbour(neighbor);
                        }
                    }
                }
                return current;
            }

            private void addNeighbour(BlockPos neighbor) {
                boolean isSearched;
                boolean bl = isSearched = !this.searched.add(neighbor);
                if (isSearched || !this.isValid(neighbor)) {
                    return;
                }
                this.queue.add(neighbor);
            }

            private boolean isValid(BlockPos pos) {
                return ConnectedSurfaceSequence.this.searchingRegion.contains((Vec3i)pos) && ConnectedSurfaceSequence.this.predicate.test(selectedBlock, pos);
            }
        };
    }

    private BlockState getReferenceFor(BlockPos pos) {
        return this.world.func_180495_p(this.searching2referenceMapper.apply(pos));
    }
}

