/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.building;

import com.direwolf20.buildinggadgets.api.BuildingGadgetsAPI;
import com.direwolf20.buildinggadgets.api.Registries;
import com.direwolf20.buildinggadgets.api.building.tilesupport.ITileEntityData;
import com.direwolf20.buildinggadgets.api.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.api.building.view.IBuildContext;
import com.direwolf20.buildinggadgets.api.materials.MaterialList;
import com.direwolf20.buildinggadgets.api.serialisation.ITileDataSerializer;
import com.direwolf20.buildinggadgets.api.util.RegistryUtils;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;

public final class BlockData {
    public static final BlockData AIR = new BlockData(Blocks.field_150350_a.func_176223_P(), TileSupport.dummyTileEntityData());
    private final BlockState state;
    private final ITileEntityData tileData;

    @Nullable
    public static BlockData tryDeserialize(@Nullable CompoundNBT tag, boolean persisted) {
        ITileDataSerializer serializer;
        if (!(tag != null && tag.func_74764_b("state") && tag.func_74764_b("serializer") && tag.func_74764_b("data"))) {
            return null;
        }
        BlockState state = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("state"));
        try {
            serializer = persisted ? RegistryUtils.getFromString(Registries.TileEntityData.getTileDataSerializers(), tag.func_74779_i("serializer")) : RegistryUtils.getById(Registries.TileEntityData.getTileDataSerializers(), tag.func_74762_e("serializer"));
        }
        catch (Exception e) {
            BuildingGadgetsAPI.LOG.error("Failed to create deserializer!", (Throwable)e);
            return null;
        }
        if (serializer == null) {
            return null;
        }
        ITileEntityData data = serializer.deserialize(tag.func_74775_l("data"), persisted);
        return new BlockData(state, data);
    }

    public static BlockData deserialize(CompoundNBT tag, boolean persisted) {
        ITileDataSerializer serializer;
        Preconditions.checkNotNull((Object)tag, (Object)"Cannot deserialize from a null tag compound");
        Preconditions.checkArgument((tag.func_74764_b("state") && tag.func_74764_b("serializer") && tag.func_74764_b("data") ? 1 : 0) != 0, (String)"Given NBTTagCompound does not contain a valid BlockData instance. Missing NBT-Keys in Tag {}!", (Object)tag.toString());
        BlockState state = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("state"));
        try {
            serializer = persisted ? RegistryUtils.getFromString(Registries.TileEntityData.getTileDataSerializers(), tag.func_74779_i("serializer")) : RegistryUtils.getById(Registries.TileEntityData.getTileDataSerializers(), tag.func_74762_e("serializer"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not retrieve serializer with persisted=" + persisted + "!", e);
        }
        Preconditions.checkArgument((serializer != null ? 1 : 0) != 0, (String)"Failed to retrieve serializer for tag {} and persisted={}", (Object)tag.toString(), (Object)persisted);
        ITileEntityData data = serializer.deserialize(tag.func_74775_l("data"), persisted);
        return new BlockData(state, data);
    }

    public BlockData(BlockState state, ITileEntityData tileData) {
        this.state = Objects.requireNonNull(state);
        this.tileData = Objects.requireNonNull(tileData);
    }

    public BlockState getState() {
        return this.state;
    }

    public ITileEntityData getTileData() {
        return this.tileData;
    }

    public boolean placeIn(IBuildContext context, BlockPos pos) {
        return this.tileData.allowPlacement(context, this.state, pos) && this.tileData.placeIn(context, this.state, pos);
    }

    public CompoundNBT serialize(boolean persisted) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("state", (INBT)NBTUtil.func_190009_a((BlockState)this.state));
        if (persisted) {
            tag.func_74778_a("serializer", this.tileData.getSerializer().getRegistryName().toString());
        } else {
            tag.func_74768_a("serializer", RegistryUtils.getId(Registries.TileEntityData.getTileDataSerializers(), this.tileData.getSerializer()));
        }
        tag.func_218657_a("data", (INBT)this.tileData.getSerializer().serialize(this.tileData, persisted));
        return tag;
    }

    public BlockData mirror(Mirror mirror) {
        return new BlockData(this.getState().func_185902_a(mirror), this.getTileData());
    }

    public BlockData rotate(Rotation rotation) {
        return new BlockData(this.getState().func_185907_a(rotation), this.getTileData());
    }

    public MaterialList getRequiredItems(IBuildContext context, @Nullable RayTraceResult target, @Nullable BlockPos pos) {
        return this.getTileData().getRequiredItems(context, this.getState(), target, pos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockData)) {
            return false;
        }
        BlockData blockData = (BlockData)o;
        if (!this.getState().equals((Object)blockData.getState())) {
            return false;
        }
        return this.getTileData().equals(blockData.getTileData());
    }

    public int hashCode() {
        int result = this.getState().hashCode();
        result = 31 * result + this.getTileData().hashCode();
        return result;
    }
}

