/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.items;

import com.progwml6.ironchest.common.blocks.ChestBlock;
import com.progwml6.ironchest.common.blocks.ChestType;
import com.progwml6.ironchest.common.items.ChestChangerType;
import com.progwml6.ironchest.common.items.TooltipItem;
import com.progwml6.ironchest.common.tileentity.IronChestTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ChestChangerItem
extends TooltipItem {
    public final ChestChangerType type;

    public ChestChangerItem(Item.Properties properties, ChestChangerType chestChangerType) {
        super(properties);
        this.type = chestChangerType;
        this.setRegistryName(chestChangerType.itemName);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity entityPlayer = context.func_195999_j();
        BlockPos blockPos = context.func_195995_a();
        World world = context.func_195991_k();
        ItemStack itemStack = context.func_195996_i();
        if (world.field_72995_K) {
            return ActionResultType.PASS;
        }
        if (this.type.canUpgrade(ChestType.WOOD) ? !(world.func_180495_p(blockPos).func_177230_c() instanceof net.minecraft.block.ChestBlock) : world.func_180495_p(blockPos).func_177230_c().func_176223_P() != ChestType.get(this.type.source)) {
            return ActionResultType.PASS;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        IronChestTileEntity newChest = new IronChestTileEntity();
        ITextComponent customName = null;
        NonNullList chestContents = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
        Direction chestFacing = Direction.NORTH;
        if (tileEntity != null) {
            if (tileEntity instanceof IronChestTileEntity) {
                IronChestTileEntity chest = (IronChestTileEntity)tileEntity;
                BlockState chestState = world.func_180495_p(blockPos);
                chestContents = chest.func_190576_q();
                chestFacing = (Direction)chestState.func_177229_b((IProperty)ChestBlock.FACING);
                customName = chest.func_200201_e();
                newChest = this.type.target.makeEntity();
                if (newChest == null) {
                    return ActionResultType.PASS;
                }
            } else if (tileEntity instanceof ChestTileEntity) {
                BlockState chestState = world.func_180495_p(blockPos);
                chestFacing = (Direction)chestState.func_177229_b((IProperty)net.minecraft.block.ChestBlock.field_176459_a);
                ChestTileEntity chest = (ChestTileEntity)tileEntity;
                if (ChestTileEntity.func_195481_a((IBlockReader)world, (BlockPos)blockPos) > 0) {
                    return ActionResultType.PASS;
                }
                if (!this.type.canUpgrade(ChestType.WOOD)) {
                    return ActionResultType.PASS;
                }
                chestContents = NonNullList.func_191197_a((int)chest.func_70302_i_(), (Object)ItemStack.field_190927_a);
                for (int slot = 0; slot < chestContents.size(); ++slot) {
                    chestContents.set(slot, (Object)chest.func_70301_a(slot));
                }
                customName = chest.func_200201_e();
                newChest = this.type.target.makeEntity();
            }
        }
        tileEntity.func_145836_u();
        world.func_175713_t(blockPos);
        world.func_217377_a(blockPos, false);
        BlockState iBlockState = (BlockState)ChestType.get(this.type.target).func_206870_a((IProperty)ChestBlock.FACING, (Comparable)chestFacing);
        world.func_175690_a(blockPos, (TileEntity)newChest);
        world.func_180501_a(blockPos, iBlockState, 3);
        world.func_184138_a(blockPos, iBlockState, iBlockState, 3);
        TileEntity tileEntity2 = world.func_175625_s(blockPos);
        if (tileEntity2 instanceof IronChestTileEntity) {
            if (customName != null) {
                ((IronChestTileEntity)tileEntity2).func_213903_a(customName);
            }
            ((IronChestTileEntity)tileEntity2).func_199721_a((NonNullList<ItemStack>)chestContents);
        }
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            itemStack.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }
}

