/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public class BigBrownMushroomFeature
extends Feature<BigMushroomFeatureConfig> {
    public BigBrownMushroomFeature(Function<Dynamic<?>, ? extends BigMushroomFeatureConfig> p_i49864_1_) {
        super(p_i49864_1_);
    }

    @Override
    public boolean func_212245_a(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, BigMushroomFeatureConfig config) {
        int j;
        int i = rand.nextInt(3) + 4;
        if (rand.nextInt(12) == 0) {
            i *= 2;
        }
        if ((j = pos.func_177956_o()) >= 1 && j + i + 1 < worldIn.func_201672_e().func_201675_m().getHeight()) {
            Block block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
            if (!Block.func_196245_f(block) && block != Blocks.field_196658_i && block != Blocks.field_150391_bh) {
                return false;
            }
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = 0; k <= 1 + i; ++k) {
                int l = k <= 3 ? 0 : 3;
                for (int i1 = -l; i1 <= l; ++i1) {
                    for (int j1 = -l; j1 <= l; ++j1) {
                        BlockState blockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_189533_g((Vec3i)pos).func_196234_d(i1, k, j1));
                        if (blockstate.isAir((IBlockReader)worldIn, (BlockPos)blockpos$mutableblockpos) || blockstate.func_203425_a(BlockTags.field_206952_E)) continue;
                        return false;
                    }
                }
            }
            BlockState blockstate1 = (BlockState)((Object)((BlockState)((Object)Blocks.field_150420_aW.func_176223_P().func_206870_a((IProperty)HugeMushroomBlock.field_196465_z, Boolean.valueOf(true)))).func_206870_a((IProperty)HugeMushroomBlock.field_196460_A, Boolean.valueOf(false)));
            int k1 = 3;
            for (int l1 = -3; l1 <= 3; ++l1) {
                for (int i2 = -3; i2 <= 3; ++i2) {
                    boolean flag4;
                    boolean flag9 = l1 == -3;
                    boolean flag = l1 == 3;
                    boolean flag1 = i2 == -3;
                    boolean flag2 = i2 == 3;
                    boolean flag3 = flag9 || flag;
                    boolean bl = flag4 = flag1 || flag2;
                    if (flag3 && flag4) continue;
                    blockpos$mutableblockpos.func_189533_g((Vec3i)pos).func_196234_d(l1, i, i2);
                    if (!worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).canBeReplacedByLeaves(worldIn, (BlockPos)blockpos$mutableblockpos)) continue;
                    boolean flag5 = flag9 || flag4 && l1 == -2;
                    boolean flag6 = flag || flag4 && l1 == 2;
                    boolean flag7 = flag1 || flag3 && i2 == -2;
                    boolean flag8 = flag2 || flag3 && i2 == 2;
                    this.func_202278_a((IWorldWriter)worldIn, (BlockPos)blockpos$mutableblockpos, (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)blockstate1.func_206870_a((IProperty)HugeMushroomBlock.field_196464_y, Boolean.valueOf(flag5)))).func_206870_a((IProperty)HugeMushroomBlock.field_196461_b, Boolean.valueOf(flag6)))).func_206870_a((IProperty)HugeMushroomBlock.field_196459_a, Boolean.valueOf(flag7)))).func_206870_a((IProperty)HugeMushroomBlock.field_196463_c, Boolean.valueOf(flag8))));
                }
            }
            BlockState blockstate2 = (BlockState)((Object)((BlockState)((Object)Blocks.field_196706_do.func_176223_P().func_206870_a((IProperty)HugeMushroomBlock.field_196465_z, Boolean.valueOf(false)))).func_206870_a((IProperty)HugeMushroomBlock.field_196460_A, Boolean.valueOf(false)));
            for (int j2 = 0; j2 < i; ++j2) {
                blockpos$mutableblockpos.func_189533_g((Vec3i)pos).func_189534_c(Direction.UP, j2);
                if (!worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).canBeReplacedByLeaves(worldIn, (BlockPos)blockpos$mutableblockpos)) continue;
                if (config.field_222854_a) {
                    worldIn.func_180501_a((BlockPos)blockpos$mutableblockpos, blockstate2, 3);
                    continue;
                }
                this.func_202278_a((IWorldWriter)worldIn, (BlockPos)blockpos$mutableblockpos, blockstate2);
            }
            return true;
        }
        return false;
    }
}

