/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.fluid;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.state.IStateHolder;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.Tag;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeFluidState;

public interface IFluidState
extends IStateHolder<IFluidState>,
IForgeFluidState {
    public Fluid func_206886_c();

    default public boolean func_206889_d() {
        return this.func_206886_c().func_207193_c(this);
    }

    default public boolean func_206888_e() {
        return this.func_206886_c().func_204538_c();
    }

    default public float func_215679_a(IBlockReader p_215679_1_, BlockPos p_215679_2_) {
        return this.func_206886_c().func_215662_a(this, p_215679_1_, p_215679_2_);
    }

    default public float func_223408_f() {
        return this.func_206886_c().func_223407_a(this);
    }

    default public int func_206882_g() {
        return this.func_206886_c().func_207192_d(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean func_205586_a(IBlockReader worldIn, BlockPos pos) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                BlockPos blockpos = pos.func_177982_a(i, 0, j);
                IFluidState ifluidstate = worldIn.func_204610_c(blockpos);
                if (ifluidstate.func_206886_c().func_207187_a(this.func_206886_c()) || worldIn.func_180495_p(blockpos).func_200015_d(worldIn, blockpos)) continue;
                return true;
            }
        }
        return false;
    }

    default public void func_206880_a(World worldIn, BlockPos pos) {
        this.func_206886_c().func_207191_a(worldIn, pos, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void func_206881_a(World p_206881_1_, BlockPos p_206881_2_, Random p_206881_3_) {
        this.func_206886_c().func_204522_a(p_206881_1_, p_206881_2_, this, p_206881_3_);
    }

    default public boolean func_206890_h() {
        return this.func_206886_c().func_207196_h();
    }

    default public void func_206891_b(World worldIn, BlockPos pos, Random random) {
        this.func_206886_c().func_207186_b(worldIn, pos, this, random);
    }

    default public Vec3d func_215673_c(IBlockReader p_215673_1_, BlockPos p_215673_2_) {
        return this.func_206886_c().func_215663_a(p_215673_1_, p_215673_2_, this);
    }

    default public BlockState func_206883_i() {
        return this.func_206886_c().func_204527_a(this);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    default public IParticleData func_204521_c() {
        return this.func_206886_c().func_204521_c();
    }

    @OnlyIn(value=Dist.CLIENT)
    default public BlockRenderLayer func_180664_k() {
        return this.func_206886_c().func_180664_k();
    }

    default public boolean func_206884_a(Tag<Fluid> tagIn) {
        return this.func_206886_c().func_207185_a(tagIn);
    }

    @Deprecated
    default public float func_210200_l() {
        return this.func_206886_c().func_210195_d();
    }

    default public boolean func_215677_a(IBlockReader p_215677_1_, BlockPos p_215677_2_, Fluid p_215677_3_, Direction p_215677_4_) {
        return this.func_206886_c().func_215665_a(this, p_215677_1_, p_215677_2_, p_215677_3_, p_215677_4_);
    }

    public static <T> Dynamic<T> func_215680_a(DynamicOps<T> p_215680_0_, IFluidState p_215680_1_) {
        ImmutableMap immutablemap = p_215680_1_.func_206871_b();
        Object t = immutablemap.isEmpty() ? p_215680_0_.createMap((Map)ImmutableMap.of((Object)p_215680_0_.createString("Name"), (Object)p_215680_0_.createString(Registry.field_212619_h.func_177774_c((Object)p_215680_1_.func_206886_c()).toString()))) : p_215680_0_.createMap((Map)ImmutableMap.of((Object)p_215680_0_.createString("Name"), (Object)p_215680_0_.createString(Registry.field_212619_h.func_177774_c((Object)p_215680_1_.func_206886_c()).toString()), (Object)p_215680_0_.createString("Properties"), (Object)p_215680_0_.createMap(immutablemap.entrySet().stream().map(p_215675_1_ -> Pair.of((Object)p_215680_0_.createString(((IProperty)p_215675_1_.getKey()).func_177701_a()), (Object)p_215680_0_.createString(IStateHolder.func_215670_b((IProperty)((IProperty)p_215675_1_.getKey()), (Comparable)((Comparable)p_215675_1_.getValue()))))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)))));
        return new Dynamic(p_215680_0_, t);
    }

    public static <T> IFluidState func_215681_a(Dynamic<T> p_215681_0_) {
        DefaultedRegistry<Fluid> defaultedregistry = Registry.field_212619_h;
        Optional optional = p_215681_0_.getElement("Name");
        DynamicOps dynamicops = p_215681_0_.getOps();
        Fluid fluid = (Fluid)((Object)defaultedregistry.func_82594_a(new ResourceLocation(optional.flatMap(arg_0 -> ((DynamicOps)dynamicops).getStringValue(arg_0)).orElse("minecraft:empty"))));
        Map map = p_215681_0_.get("Properties").asMap(p_215678_0_ -> p_215678_0_.asString(""), p_215674_0_ -> p_215674_0_.asString(""));
        IFluidState ifluidstate = fluid.func_207188_f();
        StateContainer<Fluid, IFluidState> statecontainer = fluid.func_207182_e();
        for (Map.Entry entry : map.entrySet()) {
            String s = (String)entry.getKey();
            IProperty iproperty = statecontainer.func_185920_a(s);
            if (iproperty == null) continue;
            ifluidstate = (IFluidState)IStateHolder.func_215671_a((IStateHolder)ifluidstate, (IProperty)iproperty, (String)s, (String)p_215681_0_.toString(), (String)((String)entry.getValue()));
        }
        return ifluidstate;
    }

    default public VoxelShape func_215676_d(IBlockReader p_215676_1_, BlockPos p_215676_2_) {
        return this.func_206886_c().func_215664_b(this, p_215676_1_, p_215676_2_);
    }
}

