/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.cache.LoadingCache;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class NetherPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> field_176550_a = BlockStateProperties.field_208199_z;
    protected static final VoxelShape field_185683_b = Block.func_208617_a(0.0, 0.0, 6.0, 16.0, 16.0, 10.0);
    protected static final VoxelShape field_185684_c = Block.func_208617_a(6.0, 0.0, 0.0, 10.0, 16.0, 16.0);

    public NetherPortalBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176550_a, (Comparable)((Object)Direction.Axis.X))));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)((Object)state.func_177229_b((IProperty)field_176550_a))) {
            case Z: {
                return field_185684_c;
            }
        }
        return field_185683_b;
    }

    @Override
    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (worldIn.field_73011_w.func_76569_d() && worldIn.func_82736_K().func_223586_b(GameRules.field_223601_d) && random.nextInt(2000) < worldIn.func_175659_aa().func_151525_a()) {
            ZombiePigmanEntity entity;
            while (worldIn.func_180495_p(pos).func_177230_c() == this) {
                pos = pos.func_177977_b();
            }
            if (worldIn.func_180495_p(pos).func_215688_a((IBlockReader)worldIn, pos, EntityType.field_200785_Y) && (entity = EntityType.field_200785_Y.func_220342_a(worldIn, null, null, null, pos.func_177984_a(), SpawnReason.STRUCTURE, false, false)) != null) {
                entity.field_71088_bW = entity.func_82147_ab();
            }
        }
    }

    public boolean func_176548_d(IWorld worldIn, BlockPos pos) {
        Size netherportalblock$size = this.func_201816_b(worldIn, pos);
        if (netherportalblock$size != null && !ForgeEventFactory.onTrySpawnPortal((IWorld)worldIn, (BlockPos)pos, (Size)netherportalblock$size)) {
            netherportalblock$size.func_150859_c();
            return true;
        }
        return false;
    }

    @Nullable
    public Size func_201816_b(IWorld p_201816_1_, BlockPos p_201816_2_) {
        Size netherportalblock$size = new Size(p_201816_1_, p_201816_2_, Direction.Axis.X);
        if (netherportalblock$size.func_150860_b() && netherportalblock$size.field_150864_e == 0) {
            return netherportalblock$size;
        }
        Size netherportalblock$size1 = new Size(p_201816_1_, p_201816_2_, Direction.Axis.Z);
        return netherportalblock$size1.func_150860_b() && netherportalblock$size1.field_150864_e == 0 ? netherportalblock$size1 : null;
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis direction$axis = facing.func_176740_k();
        Direction.Axis direction$axis1 = (Direction.Axis)((Object)stateIn.func_177229_b((IProperty)field_176550_a));
        boolean flag = direction$axis1 != direction$axis && direction$axis.func_176722_c();
        return !flag && facingState.func_177230_c() != this && !new Size(worldIn, currentPos, direction$axis1).func_208508_f() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.func_184222_aU()) {
            entityIn.func_181015_d(pos);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0, d1, d2, d3, d4, d5);
        }
    }

    @Override
    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)((Object)state.func_177229_b((IProperty)field_176550_a))) {
                    case Z: {
                        return (BlockState)((Object)state.func_206870_a((IProperty)field_176550_a, (Comparable)((Object)Direction.Axis.X)));
                    }
                    case X: {
                        return (BlockState)((Object)state.func_206870_a((IProperty)field_176550_a, (Comparable)((Object)Direction.Axis.Z)));
                    }
                }
                return state;
            }
        }
        return state;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176550_a});
    }

    public BlockPattern.PatternHelper func_181089_f(IWorld worldIn, BlockPos p_181089_2_) {
        Direction.Axis direction$axis = Direction.Axis.Z;
        Size netherportalblock$size = new Size(worldIn, p_181089_2_, Direction.Axis.X);
        LoadingCache loadingcache = BlockPattern.func_181627_a((IWorldReader)worldIn, (boolean)true);
        if (!netherportalblock$size.func_150860_b()) {
            direction$axis = Direction.Axis.X;
            netherportalblock$size = new Size(worldIn, p_181089_2_, Direction.Axis.Z);
        }
        if (!netherportalblock$size.func_150860_b()) {
            return new BlockPattern.PatternHelper(p_181089_2_, Direction.NORTH, Direction.UP, loadingcache, 1, 1, 1);
        }
        int[] aint = new int[Direction.AxisDirection.values().length];
        Direction direction = netherportalblock$size.field_150866_c.func_176735_f();
        BlockPos blockpos = netherportalblock$size.field_150861_f.func_177981_b(netherportalblock$size.func_181100_a() - 1);
        for (Direction.AxisDirection direction$axisdirection : Direction.AxisDirection.values()) {
            BlockPattern.PatternHelper blockpattern$patternhelper = new BlockPattern.PatternHelper(direction.func_176743_c() == direction$axisdirection ? blockpos : blockpos.func_177967_a(netherportalblock$size.field_150866_c, netherportalblock$size.func_181101_b() - 1), Direction.func_181076_a(direction$axisdirection, direction$axis), Direction.UP, loadingcache, netherportalblock$size.func_181101_b(), netherportalblock$size.func_181100_a(), 1);
            for (int i = 0; i < netherportalblock$size.func_181101_b(); ++i) {
                for (int j = 0; j < netherportalblock$size.func_181100_a(); ++j) {
                    CachedBlockInfo cachedblockinfo = blockpattern$patternhelper.func_177670_a(i, j, 1);
                    if (cachedblockinfo.func_177509_a().func_196958_f()) continue;
                    int n = direction$axisdirection.ordinal();
                    aint[n] = aint[n] + 1;
                }
            }
        }
        Direction.AxisDirection direction$axisdirection1 = Direction.AxisDirection.POSITIVE;
        for (Direction.AxisDirection direction$axisdirection2 : Direction.AxisDirection.values()) {
            if (aint[direction$axisdirection2.ordinal()] >= aint[direction$axisdirection1.ordinal()]) continue;
            direction$axisdirection1 = direction$axisdirection2;
        }
        return new BlockPattern.PatternHelper(direction.func_176743_c() == direction$axisdirection1 ? blockpos : blockpos.func_177967_a(netherportalblock$size.field_150866_c, netherportalblock$size.func_181101_b() - 1), Direction.func_181076_a(direction$axisdirection1, direction$axis), Direction.UP, loadingcache, netherportalblock$size.func_181101_b(), netherportalblock$size.func_181100_a(), 1);
    }

    public static class Size {
        private final IWorld field_150867_a;
        private final Direction.Axis field_150865_b;
        private final Direction field_150866_c;
        private final Direction field_150863_d;
        private int field_150864_e;
        @Nullable
        private BlockPos field_150861_f;
        private int field_150862_g;
        private int field_150868_h;

        public Size(IWorld p_i48740_1_, BlockPos p_i48740_2_, Direction.Axis p_i48740_3_) {
            this.field_150867_a = p_i48740_1_;
            this.field_150865_b = p_i48740_3_;
            if (p_i48740_3_ == Direction.Axis.X) {
                this.field_150863_d = Direction.EAST;
                this.field_150866_c = Direction.WEST;
            } else {
                this.field_150863_d = Direction.NORTH;
                this.field_150866_c = Direction.SOUTH;
            }
            BlockPos blockpos = p_i48740_2_;
            while (p_i48740_2_.func_177956_o() > blockpos.func_177956_o() - 21 && p_i48740_2_.func_177956_o() > 0 && this.func_196900_a(p_i48740_1_.func_180495_p(p_i48740_2_.func_177977_b()))) {
                p_i48740_2_ = p_i48740_2_.func_177977_b();
            }
            int i = this.func_180120_a(p_i48740_2_, this.field_150863_d) - 1;
            if (i >= 0) {
                this.field_150861_f = p_i48740_2_.func_177967_a(this.field_150863_d, i);
                this.field_150868_h = this.func_180120_a(this.field_150861_f, this.field_150866_c);
                if (this.field_150868_h < 2 || this.field_150868_h > 21) {
                    this.field_150861_f = null;
                    this.field_150868_h = 0;
                }
            }
            if (this.field_150861_f != null) {
                this.field_150862_g = this.func_150858_a();
            }
        }

        protected int func_180120_a(BlockPos p_180120_1_, Direction p_180120_2_) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.func_196900_a(this.field_150867_a.func_180495_p(blockpos = p_180120_1_.func_177967_a(p_180120_2_, i))) && this.field_150867_a.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_150343_Z; ++i) {
            }
            Block block = this.field_150867_a.func_180495_p(p_180120_1_.func_177967_a(p_180120_2_, i)).func_177230_c();
            return block == Blocks.field_150343_Z ? i : 0;
        }

        public int func_181100_a() {
            return this.field_150862_g;
        }

        public int func_181101_b() {
            return this.field_150868_h;
        }

        protected int func_150858_a() {
            this.field_150862_g = 0;
            block0: while (this.field_150862_g < 21) {
                for (int i = 0; i < this.field_150868_h; ++i) {
                    BlockPos blockpos = this.field_150861_f.func_177967_a(this.field_150866_c, i).func_177981_b(this.field_150862_g);
                    BlockState blockstate = this.field_150867_a.func_180495_p(blockpos);
                    if (!this.func_196900_a(blockstate)) break block0;
                    Block block = blockstate.func_177230_c();
                    if (block == Blocks.field_150427_aO) {
                        ++this.field_150864_e;
                    }
                    if (i == 0 ? (block = this.field_150867_a.func_180495_p(blockpos.func_177972_a(this.field_150863_d)).func_177230_c()) != Blocks.field_150343_Z : i == this.field_150868_h - 1 && (block = this.field_150867_a.func_180495_p(blockpos.func_177972_a(this.field_150866_c)).func_177230_c()) != Blocks.field_150343_Z) break block0;
                }
                ++this.field_150862_g;
            }
            for (int j = 0; j < this.field_150868_h; ++j) {
                if (this.field_150867_a.func_180495_p(this.field_150861_f.func_177967_a(this.field_150866_c, j).func_177981_b(this.field_150862_g)).func_177230_c() == Blocks.field_150343_Z) continue;
                this.field_150862_g = 0;
                break;
            }
            if (this.field_150862_g <= 21 && this.field_150862_g >= 3) {
                return this.field_150862_g;
            }
            this.field_150861_f = null;
            this.field_150868_h = 0;
            this.field_150862_g = 0;
            return 0;
        }

        protected boolean func_196900_a(BlockState p_196900_1_) {
            Block block = p_196900_1_.func_177230_c();
            return p_196900_1_.func_196958_f() || block == Blocks.field_150480_ab || block == Blocks.field_150427_aO;
        }

        public boolean func_150860_b() {
            return this.field_150861_f != null && this.field_150868_h >= 2 && this.field_150868_h <= 21 && this.field_150862_g >= 3 && this.field_150862_g <= 21;
        }

        public void func_150859_c() {
            for (int i = 0; i < this.field_150868_h; ++i) {
                BlockPos blockpos = this.field_150861_f.func_177967_a(this.field_150866_c, i);
                for (int j = 0; j < this.field_150862_g; ++j) {
                    this.field_150867_a.func_180501_a(blockpos.func_177981_b(j), (BlockState)((Object)Blocks.field_150427_aO.func_176223_P().func_206870_a((IProperty)field_176550_a, (Comparable)((Object)this.field_150865_b))), 18);
                }
            }
        }

        private boolean func_196899_f() {
            return this.field_150864_e >= this.field_150868_h * this.field_150862_g;
        }

        public boolean func_208508_f() {
            return this.func_150860_b() && this.func_196899_f();
        }
    }
}

