/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomlib.config.adapter;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.therandomlabs.randomlib.TRLUtils;
import com.therandomlabs.randomlib.config.adapter.TypeAdapter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public final class ResourceLocationTypeAdapter
implements TypeAdapter {
    private final Class<?> registryEntryClass;
    private final IForgeRegistry<?> registry;
    private final boolean isArray;

    public ResourceLocationTypeAdapter(Class<IForgeRegistryEntry<?>> registryEntryClass, boolean isArray) {
        this.registryEntryClass = registryEntryClass;
        this.registry = RegistryManager.ACTIVE.getRegistry(registryEntryClass);
        this.isArray = isArray;
    }

    @Override
    public Object getValue(CommentedFileConfig config, String name, Object defaultValue) {
        if (!this.isArray) {
            String location = (String)config.get(name);
            if (location.isEmpty()) {
                return null;
            }
            IForgeRegistryEntry object = this.registry.getValue(new ResourceLocation(location.replaceAll("\\s", "")));
            return object == null ? defaultValue : object;
        }
        List list = (List)config.get(name);
        ArrayList<IForgeRegistryEntry> values = new ArrayList<IForgeRegistryEntry>(list.size());
        for (String element : list) {
            IForgeRegistryEntry object = this.registry.getValue(new ResourceLocation(element.replaceAll("\\s", "")));
            if (object == null) continue;
            values.add(object);
        }
        return values.toArray((Object[])Array.newInstance(this.registryEntryClass, 0));
    }

    @Override
    public void setValue(CommentedFileConfig config, String name, Object value) {
        if (this.isArray) {
            config.set(name, Arrays.stream((Object[])value).map(this::asString).collect(Collectors.toList()));
        } else {
            config.set(name, (Object)this.asString(value));
        }
    }

    @Override
    public String asString(Object value) {
        return value == null ? "" : ((IForgeRegistryEntry)value).getRegistryName().toString();
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public boolean shouldLoad() {
        return TRLUtils.hasReachedStage(ModLoadingStage.COMMON_SETUP);
    }
}

