/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomlib.config;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.therandomlabs.randomlib.config.ConfigManager;
import net.minecraft.command.CommandSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;

public final class CommandConfigReload {
    private CommandConfigReload() {
    }

    public static void client(CommandDispatcher<CommandSource> dispatcher, String name, Class<?> configClass) {
        CommandConfigReload.client(dispatcher, name, configClass, null);
    }

    public static void client(CommandDispatcher<CommandSource> dispatcher, String name, Class<?> configClass, ConfigReloader reloader) {
        CommandConfigReload.register(dispatcher, name, name, configClass, reloader, Dist.CLIENT, null);
    }

    public static void server(CommandDispatcher<CommandSource> dispatcher, String name, String clientName, Class<?> configClass) {
        CommandConfigReload.server(dispatcher, name, clientName, configClass, null, null);
    }

    public static void server(CommandDispatcher<CommandSource> dispatcher, String name, String clientName, Class<?> configClass, String successMessage) {
        CommandConfigReload.server(dispatcher, name, clientName, configClass, successMessage, null);
    }

    public static void server(CommandDispatcher<CommandSource> dispatcher, String name, String clientName, Class<?> configClass, String successMessage, ConfigReloader reloader) {
        CommandConfigReload.register(dispatcher, name, clientName, configClass, reloader, Dist.DEDICATED_SERVER, successMessage);
    }

    private static void register(CommandDispatcher<CommandSource> dispatcher, String name, String clientName, Class<?> configClass, ConfigReloader reloader, Dist dist, String successMessage) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)name).requires(source -> source.func_197034_c(dist == Dist.CLIENT ? 0 : 4))).executes(context -> CommandConfigReload.execute((CommandSource)context.getSource(), name, clientName, configClass, reloader, dist, successMessage)));
    }

    private static int execute(CommandSource source, String name, String clientName, Class<?> configClass, ConfigReloader reloader, Dist dist, String successMessage) {
        MinecraftServer server;
        boolean serverSided;
        if (reloader != null) {
            reloader.reload(ReloadPhase.PRE, source);
        }
        ConfigManager.reloadFromDisk(configClass);
        if (reloader != null) {
            reloader.reload(ReloadPhase.POST, source);
        }
        boolean bl = serverSided = (server = source.func_197028_i()) != null && server.func_71262_S();
        if (successMessage != null && serverSided) {
            source.func_197030_a((ITextComponent)new StringTextComponent(successMessage), true);
        } else {
            String actualName = serverSided ? name : clientName;
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands." + actualName + ".success", new Object[0]), true);
        }
        return 1;
    }

    public static enum ReloadPhase {
        PRE,
        POST;

    }

    @FunctionalInterface
    public static interface ConfigReloader {
        public void reload(ReloadPhase var1, CommandSource var2);
    }
}

