/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomlib;

import cpw.mods.modlauncher.ArgumentHandler;
import cpw.mods.modlauncher.Launcher;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.versions.forge.ForgeVersion;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public final class TRLUtils {
    public static final boolean IS_DEOBFUSCATED;
    public static final boolean IS_CLIENT;
    public static final String MC_VERSION;
    public static final int MC_VERSION_NUMBER;
    public static final ArtifactVersion MC_ARTIFACT_VERSION;
    public static final int FORGE_BUILD;
    private static final Logger LOGGER;
    private static Field modifiers;

    private TRLUtils() {
    }

    public static Object toPrimitiveArray(Object[] boxedArray) {
        if (boxedArray instanceof Boolean[]) {
            return ArrayUtils.toPrimitive((Boolean[])((Boolean[])boxedArray));
        }
        if (boxedArray instanceof Byte[]) {
            return ArrayUtils.toPrimitive((Byte[])((Byte[])boxedArray));
        }
        if (boxedArray instanceof Character[]) {
            return ArrayUtils.toPrimitive((Character[])((Character[])boxedArray));
        }
        if (boxedArray instanceof Double[]) {
            return ArrayUtils.toPrimitive((Double[])((Double[])boxedArray));
        }
        if (boxedArray instanceof Float[]) {
            return ArrayUtils.toPrimitive((Float[])((Float[])boxedArray));
        }
        if (boxedArray instanceof Integer[]) {
            return ArrayUtils.toPrimitive((Integer[])((Integer[])boxedArray));
        }
        if (boxedArray instanceof Long[]) {
            return ArrayUtils.toPrimitive((Long[])((Long[])boxedArray));
        }
        if (boxedArray instanceof Short[]) {
            return ArrayUtils.toPrimitive((Short[])((Short[])boxedArray));
        }
        return boxedArray;
    }

    public static Object[] toBoxedArray(Object primitiveArray) {
        if (primitiveArray instanceof Object[]) {
            return (Object[])primitiveArray;
        }
        if (primitiveArray instanceof boolean[]) {
            return ArrayUtils.toObject((byte[])((byte[])primitiveArray));
        }
        if (primitiveArray instanceof byte[]) {
            return ArrayUtils.toObject((byte[])((byte[])primitiveArray));
        }
        if (primitiveArray instanceof char[]) {
            return ArrayUtils.toObject((char[])((char[])primitiveArray));
        }
        if (primitiveArray instanceof double[]) {
            return ArrayUtils.toObject((double[])((double[])primitiveArray));
        }
        if (primitiveArray instanceof float[]) {
            return ArrayUtils.toObject((float[])((float[])primitiveArray));
        }
        if (primitiveArray instanceof int[]) {
            return ArrayUtils.toObject((int[])((int[])primitiveArray));
        }
        if (primitiveArray instanceof long[]) {
            return ArrayUtils.toObject((long[])((long[])primitiveArray));
        }
        if (primitiveArray instanceof short[]) {
            return ArrayUtils.toObject((long[])((long[])primitiveArray));
        }
        return (Object[])primitiveArray;
    }

    public static Path getPath(String path) {
        try {
            return Paths.get(path, new String[0]).normalize();
        }
        catch (InvalidPathException invalidPathException) {
            return null;
        }
    }

    public static String toStringWithUnixPathSeparators(Path path) {
        return path.toString().replace('\\', '/');
    }

    public static Field findField(Class<?> clazz, String ... names) {
        for (Field field : clazz.getDeclaredFields()) {
            for (String name : names) {
                if (!name.equals(field.getName())) continue;
                field.setAccessible(true);
                return field;
            }
        }
        return null;
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        return TRLUtils.findMethod(clazz, name, name, parameterTypes);
    }

    public static Method findMethod(Class<?> clazz, String name, String obfName, Class<?> ... parameterTypes) {
        for (Method method : clazz.getDeclaredMethods()) {
            String methodName = method.getName();
            if (!name.equals(methodName) && !obfName.equals(methodName) || !Arrays.equals(method.getParameterTypes(), parameterTypes)) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    public static Field removeFinalModifier(Field field) {
        try {
            if (modifiers == null) {
                modifiers = Field.class.getDeclaredField("modifiers");
                modifiers.setAccessible(true);
            }
            modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (Exception ex) {
            TRLUtils.crashReport("Failed to make " + field.getName() + " non-final", ex);
        }
        return field;
    }

    public static Class<?> getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static ModLoadingStage getModLoadingStage() {
        return ((ModContainer)ModList.get().getModContainerById("forge").get()).getCurrentState();
    }

    public static boolean hasReachedStage(ModLoadingStage stage) {
        return stage.ordinal() <= TRLUtils.getModLoadingStage().ordinal();
    }

    public static void crashReport(String message, Throwable throwable) {
        throw new ReportedException(new CrashReport(message, throwable));
    }

    static {
        IS_CLIENT = FMLEnvironment.dist.isClient();
        MC_VERSION = MCPVersion.getMCVersion();
        MC_VERSION_NUMBER = Integer.parseInt(MC_VERSION.split("\\.")[1]);
        MC_ARTIFACT_VERSION = new DefaultArtifactVersion(MC_VERSION);
        FORGE_BUILD = Integer.parseInt(ForgeVersion.getVersion().split("\\.")[2]);
        LOGGER = LogManager.getLogger((String)"randomlib");
        boolean isDeobfuscated = false;
        try {
            Object argumentHandler = TRLUtils.findField(Launcher.class, "argumentHandler").get(Launcher.INSTANCE);
            Object launchTarget = TRLUtils.findMethod(ArgumentHandler.class, "getLaunchTarget", new Class[0]).invoke(argumentHandler, new Object[0]);
            isDeobfuscated = "fmluserdevclient".equals(launchTarget) || "fmluserdevserver".equals(launchTarget);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            LOGGER.error("Failed to determine launch target", (Throwable)ex);
        }
        IS_DEOBFUSCATED = isDeobfuscated;
    }
}

