/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Supplier;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.rendering.OverlayRenderer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketReturnEntityInfo {
    private UUID uuid;
    private ProbeInfo probeInfo;

    public PacketReturnEntityInfo(ByteBuf buf) {
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        if (buf.readBoolean()) {
            this.probeInfo = new ProbeInfo();
            this.probeInfo.fromBytes(buf);
        } else {
            this.probeInfo = null;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        if (this.probeInfo != null) {
            buf.writeBoolean(true);
            this.probeInfo.toBytes(buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    public PacketReturnEntityInfo() {
    }

    public PacketReturnEntityInfo(UUID uuid, ProbeInfo probeInfo) {
        this.uuid = uuid;
        this.probeInfo = probeInfo;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> OverlayRenderer.registerProbeInfo(this.uuid, this.probeInfo));
        ctx.get().setPacketHandled(true);
    }
}

