/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.function.Supplier;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeHitData;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.network.PacketHandler;
import mcjty.theoneprobe.network.PacketReturnInfo;
import mcjty.theoneprobe.network.ThrowableIdentity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGetInfo {
    private int dim;
    private BlockPos pos;
    private ProbeMode mode;
    private Direction sideHit;
    private Vec3d hitVec;
    private ItemStack pickBlock;

    public PacketGetInfo(PacketBuffer buf) {
        this.dim = buf.readInt();
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.mode = ProbeMode.values()[buf.readByte()];
        byte sideByte = buf.readByte();
        this.sideHit = sideByte == 127 ? null : Direction.values()[sideByte];
        if (buf.readBoolean()) {
            this.hitVec = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
        this.pickBlock = buf.func_150791_c();
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.dim);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeByte(this.mode.ordinal());
        buf.writeByte(this.sideHit == null ? 127 : this.sideHit.ordinal());
        if (this.hitVec == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeDouble(this.hitVec.field_72450_a);
            buf.writeDouble(this.hitVec.field_72448_b);
            buf.writeDouble(this.hitVec.field_72449_c);
        }
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.func_150788_a(this.pickBlock);
        if (buffer.writerIndex() <= (Integer)Config.maxPacketToServer.get()) {
            buf.writeBytes((ByteBuf)buffer);
        } else {
            ItemStack copy = new ItemStack((IItemProvider)this.pickBlock.func_77973_b(), this.pickBlock.func_190916_E());
            buf.func_150788_a(copy);
        }
    }

    public PacketGetInfo() {
    }

    public PacketGetInfo(int dim, BlockPos pos, ProbeMode mode, RayTraceResult mouseOver, ItemStack pickBlock) {
        this.dim = dim;
        this.pos = pos;
        this.mode = mode;
        this.sideHit = ((BlockRayTraceResult)mouseOver).func_216354_b();
        this.hitVec = mouseOver.func_216347_e();
        this.pickBlock = pickBlock;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            DimensionType type = DimensionType.func_186069_a((int)this.dim);
            ServerWorld world = DimensionManager.getWorld((MinecraftServer)((NetworkEvent.Context)ctx.get()).getSender().field_71133_b, (DimensionType)type, (boolean)true, (boolean)false);
            if (world != null) {
                ProbeInfo probeInfo = PacketGetInfo.getProbeInfo((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), this.mode, (World)world, this.pos, this.sideHit, this.hitVec, this.pickBlock);
                PacketHandler.INSTANCE.sendTo((Object)new PacketReturnInfo(this.dim, this.pos, probeInfo), ((NetworkEvent.Context)ctx.get()).getSender().field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static ProbeInfo getProbeInfo(PlayerEntity player, ProbeMode mode, World world, BlockPos blockPos, Direction sideHit, Vec3d hitVec, ItemStack pickBlock) {
        if ((Integer)Config.needsProbe.get() == 3) {
            if (!ModItems.hasAProbeSomewhere(player) && mode == ProbeMode.EXTENDED) {
                mode = ProbeMode.NORMAL;
            }
        } else if ((Integer)Config.needsProbe.get() == 2 && !ModItems.hasAProbeSomewhere(player)) {
            return null;
        }
        BlockState state = world.func_180495_p(blockPos);
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        ProbeHitData data = new ProbeHitData(blockPos, hitVec, sideHit, pickBlock);
        IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
        List<IProbeConfigProvider> configProviders = TheOneProbe.theOneProbeImp.getConfigProviders();
        for (IProbeConfigProvider configProvider : configProviders) {
            configProvider.getProbeConfig(probeConfig, player, world, state, data);
        }
        Config.setRealConfig(probeConfig);
        List<IProbeInfoProvider> providers = TheOneProbe.theOneProbeImp.getProviders();
        for (IProbeInfoProvider provider : providers) {
            try {
                provider.addProbeInfo(mode, probeInfo, player, world, state, data);
            }
            catch (Throwable e) {
                ThrowableIdentity.registerThrowable(e);
                probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Error: " + (Object)((Object)TextStyleClass.ERROR) + provider.getID());
            }
        }
        return probeInfo;
    }
}

