/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.blay09.mods.craftingtweaks.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.minecraft.inventory.container.Container;
import net.minecraftforge.fml.ModList;

public class CraftingTweaksProviderManager {
    private static final Map<Class<? extends Container>, TweakProvider> providerMap = Maps.newHashMap();

    public static <T extends Container> void registerProvider(Class<T> clazz, TweakProvider<T> provider) {
        if (!provider.getModId().equals("minecraft") && !ModList.get().isLoaded(provider.getModId())) {
            return;
        }
        if (provider.load()) {
            providerMap.put(clazz, provider);
        }
    }

    public static void registerProvider(String className, TweakProvider provider) {
        CraftingTweaksConfig.addModSupportOption(provider.getModId());
        if (ModList.get().isLoaded(provider.getModId()) && provider.load()) {
            try {
                Class<?> clazz = Class.forName(className);
                if (Container.class.isAssignableFrom(clazz)) {
                    providerMap.put(clazz, provider);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Nullable
    public static <T extends Container> TweakProvider<T> getProvider(@Nullable T container) {
        if (container == null) {
            return null;
        }
        for (Class<? extends Container> clazz : providerMap.keySet()) {
            if (container.getClass() != clazz) continue;
            return providerMap.get(clazz);
        }
        for (Class<? extends Container> clazz : providerMap.keySet()) {
            if (!clazz.isAssignableFrom(container.getClass())) continue;
            return providerMap.get(clazz);
        }
        return null;
    }
}

