/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class JSONSerializableDataHandler {
    private static HashMap<Class, Pair<Writer, Reader>> FIELD_SERIALIZER = new HashMap();

    private static <T> void map(Class<T> type, Writer<T> writer, Reader<T> reader) {
        FIELD_SERIALIZER.put(type, (Pair<Writer, Reader>)Pair.of(writer, reader));
    }

    public static boolean acceptField(Field f, Class<?> type) {
        int mods = f.getModifiers();
        return !Modifier.isFinal(mods) && !Modifier.isStatic(mods) && !Modifier.isTransient(mods) && FIELD_SERIALIZER.containsKey(type);
    }

    public static <T> T read(Class<T> type, JsonElement element) {
        return ((Reader)FIELD_SERIALIZER.get(type).getSecond()).read(element);
    }

    public static JsonElement write(Class<?> type, Object value) {
        return ((Writer)FIELD_SERIALIZER.get(type).getFirst()).write(value);
    }

    public static JsonObject writeItemStack(ItemStack stack) {
        JsonObject object = new JsonObject();
        object.addProperty("item", stack.func_77973_b().getRegistryName().toString());
        object.addProperty("count", (Number)stack.func_190916_E());
        if (stack.func_77942_o()) {
            object.addProperty("nbt", stack.func_77978_p().toString());
        }
        return object;
    }

    public static JsonElement writeFluidStack(FluidStack fluidStack) {
        return new JsonPrimitive(fluidStack.writeToNBT(new CompoundNBT()).toString());
    }

    public static FluidStack readFluidStack(JsonElement object) {
        try {
            return FluidStack.loadFluidStackFromNBT((CompoundNBT)JsonToNBT.func_180713_a((String)object.getAsString()));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return FluidStack.EMPTY;
        }
    }

    public static ItemStack readItemStack(JsonObject object) {
        ItemStack stack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(object.get("item").getAsString())), object.get("count").getAsInt());
        if (object.has("nbt")) {
            try {
                stack.func_77982_d(JsonToNBT.func_180713_a((String)object.get("nbt").getAsString()));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        return stack;
    }

    static {
        JSONSerializableDataHandler.map(Byte.TYPE, JsonPrimitive::new, JsonElement::getAsByte);
        JSONSerializableDataHandler.map(Short.TYPE, JsonPrimitive::new, JsonElement::getAsShort);
        JSONSerializableDataHandler.map(Integer.TYPE, JsonPrimitive::new, JsonElement::getAsInt);
        JSONSerializableDataHandler.map(Long.TYPE, JsonPrimitive::new, JsonElement::getAsLong);
        JSONSerializableDataHandler.map(Float.TYPE, JsonPrimitive::new, JsonElement::getAsFloat);
        JSONSerializableDataHandler.map(Double.TYPE, JsonPrimitive::new, JsonElement::getAsDouble);
        JSONSerializableDataHandler.map(Boolean.TYPE, JsonPrimitive::new, JsonElement::getAsBoolean);
        JSONSerializableDataHandler.map(Character.TYPE, JsonPrimitive::new, JsonElement::getAsCharacter);
        JSONSerializableDataHandler.map(Byte.class, JsonPrimitive::new, JsonElement::getAsByte);
        JSONSerializableDataHandler.map(Short.class, JsonPrimitive::new, JsonElement::getAsShort);
        JSONSerializableDataHandler.map(Integer.class, JsonPrimitive::new, JsonElement::getAsInt);
        JSONSerializableDataHandler.map(Long.class, JsonPrimitive::new, JsonElement::getAsLong);
        JSONSerializableDataHandler.map(Float.class, JsonPrimitive::new, JsonElement::getAsFloat);
        JSONSerializableDataHandler.map(Double.class, JsonPrimitive::new, JsonElement::getAsDouble);
        JSONSerializableDataHandler.map(Boolean.class, JsonPrimitive::new, JsonElement::getAsBoolean);
        JSONSerializableDataHandler.map(Character.class, JsonPrimitive::new, JsonElement::getAsCharacter);
        JSONSerializableDataHandler.map(String.class, JsonPrimitive::new, JsonElement::getAsString);
        JSONSerializableDataHandler.map(Ingredient.class, Ingredient::func_200304_c, Ingredient::func_199802_a);
        JSONSerializableDataHandler.map(ItemStack.class, JSONSerializableDataHandler::writeItemStack, element -> JSONSerializableDataHandler.readItemStack(element.getAsJsonObject()));
        JSONSerializableDataHandler.map(ResourceLocation.class, type -> new JsonPrimitive(type.toString()), element -> new ResourceLocation(element.getAsString()));
        JSONSerializableDataHandler.map(Block.class, type -> new JsonPrimitive(type.getRegistryName().toString()), element -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(element.getAsString())));
        JSONSerializableDataHandler.map(FluidStack.class, JSONSerializableDataHandler::writeFluidStack, JSONSerializableDataHandler::readFluidStack);
        JSONSerializableDataHandler.map(Ingredient.IItemList.class, Ingredient.IItemList::func_200303_b, element -> Ingredient.func_199803_a((JsonObject)element.getAsJsonObject()));
        JSONSerializableDataHandler.map(Ingredient.IItemList[].class, type -> {
            JsonArray array = new JsonArray();
            for (Ingredient.IItemList ingredient : type) {
                array.add((JsonElement)ingredient.func_200303_b());
            }
            return array;
        }, element -> {
            Ingredient.IItemList[] ingredient = new Ingredient.IItemList[element.getAsJsonArray().size()];
            int i = 0;
            for (JsonElement jsonElement : element.getAsJsonArray()) {
                ingredient[i] = Ingredient.func_199803_a((JsonObject)jsonElement.getAsJsonObject());
                ++i;
            }
            return ingredient;
        });
    }

    public static interface Reader<T> {
        public T read(JsonElement var1);
    }

    public static interface Writer<T> {
        public JsonElement write(T var1);
    }
}

