/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.generator;

import com.hrznstudio.titanium.recipe.generator.IIngredient;
import com.hrznstudio.titanium.recipe.generator.IJsonFile;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class CraftingJsonData
implements IJsonFile {
    private String type;
    private String[] pattern;
    private PatternKey key;
    private IIngredient[] ingredients;
    private IIngredient result;

    private CraftingJsonData(String type, String[] pattern, PatternKey key, IIngredient result) {
        this.type = type;
        this.pattern = pattern;
        this.key = key;
        this.result = result;
    }

    private CraftingJsonData(String type, String[] pattern, IIngredient[] ingredients, IIngredient result) {
        this.type = type;
        this.pattern = pattern;
        this.ingredients = ingredients;
        this.result = result;
    }

    public static CraftingJsonData ofShaped(ItemStack stack, String[] pattern, Object ... keyPairs) {
        IIngredient.ItemStackIngredient result = IIngredient.ItemStackIngredient.of(stack);
        HashMap<Character, Character> charMapping = new HashMap<Character, Character>();
        for (int i = 0; i < pattern.length; ++i) {
            pattern[i] = pattern[i].toLowerCase();
        }
        char letter = 'A';
        for (String patternLine : pattern) {
            for (char c : patternLine.toCharArray()) {
                if (c == ' ' || charMapping.containsKey(Character.valueOf(c))) continue;
                charMapping.put(Character.valueOf(c), Character.valueOf(letter));
                letter = (char)(letter + '\u0001');
            }
        }
        charMapping.forEach((key, value) -> {
            for (int i = 0; i < pattern.length; ++i) {
                pattern[i] = pattern[i].replace(key.charValue(), value.charValue());
            }
        });
        PatternKey patternKey = new PatternKey();
        for (int i = 0; i < keyPairs.length; i += 2) {
            char key2 = Character.toLowerCase(((Character)keyPairs[i]).charValue());
            IIngredient value2 = (IIngredient)keyPairs[i + 1];
            patternKey.set(((Character)charMapping.get(Character.valueOf(key2))).charValue() - 65, value2);
        }
        return new CraftingJsonData("minecraft:crafting_shaped", pattern, patternKey, (IIngredient)result);
    }

    public static CraftingJsonData ofShapeless(ItemStack stack, IIngredient ... keys) {
        IIngredient.ItemStackIngredient result = IIngredient.ItemStackIngredient.of(stack);
        return new CraftingJsonData("minecraft:crafting_shapeless", null, keys, (IIngredient)result);
    }

    @Override
    public String getRecipeKey() {
        return this.result.getKey();
    }

    @Override
    @Nullable
    public String getRecipeSubfolder() {
        return "crafting";
    }

    private static class PatternKey {
        public IIngredient A;
        public IIngredient B;
        public IIngredient C;
        public IIngredient D;
        public IIngredient E;
        public IIngredient F;
        public IIngredient G;
        public IIngredient H;
        public IIngredient I;

        private PatternKey() {
        }

        public void set(int i, IIngredient ingredient) {
            switch (i) {
                case 0: {
                    this.A = ingredient;
                    break;
                }
                case 1: {
                    this.B = ingredient;
                    break;
                }
                case 2: {
                    this.C = ingredient;
                    break;
                }
                case 3: {
                    this.D = ingredient;
                    break;
                }
                case 4: {
                    this.E = ingredient;
                    break;
                }
                case 5: {
                    this.F = ingredient;
                    break;
                }
                case 6: {
                    this.G = ingredient;
                    break;
                }
                case 7: {
                    this.H = ingredient;
                    break;
                }
                case 8: {
                    this.I = ingredient;
                }
            }
        }
    }
}

