/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.gui.addon;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.api.client.IGuiAddon;
import com.hrznstudio.titanium.api.client.assets.types.IBackgroundAsset;
import com.hrznstudio.titanium.block.tile.button.PosButton;
import com.hrznstudio.titanium.block.tile.sideness.IFacingHandler;
import com.hrznstudio.titanium.block.tile.sideness.SidedHandlerManager;
import com.hrznstudio.titanium.client.gui.IGuiAddonConsumer;
import com.hrznstudio.titanium.client.gui.addon.BasicGuiAddon;
import com.hrznstudio.titanium.client.gui.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.gui.addon.StateButtonInfo;
import com.hrznstudio.titanium.client.gui.addon.interfaces.IClickable;
import com.hrznstudio.titanium.client.gui.asset.IAssetProvider;
import com.hrznstudio.titanium.client.gui.container.GuiContainerTileBase;
import com.hrznstudio.titanium.container.impl.ContainerTileBase;
import com.hrznstudio.titanium.network.NetworkHandler;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.util.AssetUtil;
import com.hrznstudio.titanium.util.FacingUtil;
import com.hrznstudio.titanium.util.LangUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TextFormatting;

public class FacingHandlerGuiAddon
extends BasicGuiAddon
implements IClickable {
    private final IFacingHandler handler;
    private final SidedHandlerManager manager;
    private List<StateButtonAddon> buttonAddons;
    private int xSize;
    private int ySize;
    private boolean clicked;
    private Point inventoryPoint;
    private Point hotbarPoint;
    private IAssetType assetType;

    public FacingHandlerGuiAddon(SidedHandlerManager manager, IFacingHandler facingHandler, IAssetType assetType) {
        super(manager.getPosX(), manager.getPosY());
        this.manager = manager;
        this.handler = facingHandler;
        this.buttonAddons = new ArrayList<StateButtonAddon>();
        this.xSize = 0;
        this.ySize = 0;
        this.clicked = false;
        this.assetType = assetType;
    }

    public static Point getPointFromFacing(FacingUtil.Sideness sideness, Point inventory) {
        Point origin = new Point(inventory.x + 73, inventory.y + 19);
        switch (sideness) {
            case TOP: {
                origin.translate(0, -16);
                break;
            }
            case BOTTOM: {
                origin.translate(0, 16);
                break;
            }
            case LEFT: {
                origin.translate(-16, 0);
                break;
            }
            case RIGHT: {
                origin.translate(16, 0);
                break;
            }
            case BACK: {
                origin.translate(16, 16);
            }
        }
        return origin;
    }

    @Override
    public void drawGuiContainerBackgroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        IBackgroundAsset backgroundInfo = provider.getAsset(AssetTypes.BACKGROUND);
        this.inventoryPoint = backgroundInfo.getInventoryPosition();
        this.hotbarPoint = backgroundInfo.getHotbarPosition();
        this.xSize = provider.getAsset(AssetTypes.BUTTON_SIDENESS_MANAGER).getArea().width;
        this.ySize = provider.getAsset(AssetTypes.BUTTON_SIDENESS_MANAGER).getArea().height;
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AssetUtil.drawAsset(screen, provider.getAsset(AssetTypes.BUTTON_SIDENESS_MANAGER), guiX + this.getPosX(), guiY + this.getPosY());
        int offset = 2;
        AbstractGui.fill((int)(guiX + this.getPosX() + offset), (int)(guiY + this.getPosY() + offset), (int)(guiX + this.getPosX() + this.getXSize() - offset), (int)(guiY + this.getPosY() + this.getYSize() - offset), (int)this.handler.getColor());
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isClicked()) {
            screen.blit(guiX + backgroundInfo.getInventoryPosition().x - 1, guiY + backgroundInfo.getInventoryPosition().y - 1, 16, 231, 14, 14);
            screen.blit(guiX + backgroundInfo.getInventoryPosition().x - 1, guiY + backgroundInfo.getInventoryPosition().y - 1, 56, 185, 162, 54);
        }
    }

    @Override
    public void drawGuiContainerForegroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
        if (this.isInside(screen, mouseX - guiX, mouseY - guiY) || this.isClicked()) {
            Object asset = provider.getAsset(this.assetType);
            Rectangle area = this.handler.getRectangle((IAsset)asset);
            AssetUtil.drawHorizontalLine(area.x, area.x + area.width, area.y, this.handler.getColor());
            AssetUtil.drawHorizontalLine(area.x, area.x + area.width, area.y + area.height, this.handler.getColor());
            AssetUtil.drawVerticalLine(area.x, area.y, area.y + area.height, this.handler.getColor());
            AssetUtil.drawVerticalLine(area.x + area.width, area.y, area.y + area.height, this.handler.getColor());
        }
    }

    @Override
    public List<String> getTooltipLines() {
        return Arrays.asList(LangUtil.get("tooltip.titanium.facing_handler." + this.handler.getName().toLowerCase(), new Object[0]));
    }

    @Override
    public int getXSize() {
        return this.xSize;
    }

    @Override
    public int getYSize() {
        return this.ySize;
    }

    @Override
    public void handleClick(final Screen screen, int guiX, int guiY, double mouseX, double mouseY, int button) {
        if (screen instanceof GuiContainerTileBase) {
            for (IGuiAddon addon : new ArrayList<IGuiAddon>(((IGuiAddonConsumer)screen).getAddons())) {
                if (!(addon instanceof FacingHandlerGuiAddon) || addon == this) continue;
                ((FacingHandlerGuiAddon)addon).setClicked((GuiContainerTileBase)screen, false);
                ((ContainerTileBase)((GuiContainerTileBase)screen).func_212873_a_()).setDisabled(true);
            }
            this.setClicked((GuiContainerTileBase)screen, !this.clicked);
            if (this.clicked) {
                for (final FacingUtil.Sideness facing : FacingUtil.Sideness.values()) {
                    if (!this.handler.getFacingModes().containsKey((Object)facing)) continue;
                    Point point = FacingHandlerGuiAddon.getPointFromFacing(facing, this.inventoryPoint);
                    StateButtonAddon addon = new StateButtonAddon(new PosButton(point.x, point.y, 14, 14), new StateButtonInfo[]{IFacingHandler.FaceMode.NONE.getInfo(), IFacingHandler.FaceMode.ENABLED.getInfo(), IFacingHandler.FaceMode.PULL.getInfo(), IFacingHandler.FaceMode.PUSH.getInfo()}){

                        @Override
                        public int getState() {
                            IFacingHandler handler = ((ContainerTileBase)((GuiContainerTileBase)screen).func_212873_a_()).getTile().getHandlerFromName(FacingHandlerGuiAddon.this.handler.getName());
                            return handler != null && handler.getFacingModes().containsKey((Object)facing) ? handler.getFacingModes().get((Object)facing).getIndex() : 0;
                        }

                        @Override
                        public void handleClick(Screen gui, int guiX, int guiY, double mouseX, double mouseY, int mouse) {
                            StateButtonInfo info = this.getStateInfo();
                            if (info != null && gui instanceof GuiContainerTileBase) {
                                CompoundNBT compound = new CompoundNBT();
                                compound.func_74778_a("Facing", facing.name());
                                int faceMode = (this.getState() + (mouse == 0 ? 1 : -1)) % IFacingHandler.FaceMode.values().length;
                                if (faceMode < 0) {
                                    faceMode = IFacingHandler.FaceMode.values().length - 1;
                                }
                                compound.func_74768_a("Next", faceMode);
                                compound.func_74778_a("Name", FacingHandlerGuiAddon.this.handler.getName());
                                NetworkHandler.NETWORK.sendToServer((Object)new ButtonClickNetworkMessage(((ContainerTileBase)((GuiContainerTileBase)gui).func_212873_a_()).getTile().func_174877_v(), -1, compound));
                                FacingHandlerGuiAddon.this.handler.getFacingModes().put(facing, IFacingHandler.FaceMode.values()[faceMode]);
                                ((ContainerTileBase)((GuiContainerTileBase)gui).func_212873_a_()).getTile().updateNeigh();
                            }
                        }

                        @Override
                        public List<String> getTooltipLines() {
                            ArrayList<String> strings = new ArrayList<String>();
                            IFacingHandler.FaceMode mode = IFacingHandler.FaceMode.values()[this.getState()];
                            strings.add(TextFormatting.GOLD + LangUtil.get("tooltip.titanium.facing_handler.direction", new Object[0]) + TextFormatting.RESET + LangUtil.get("tooltip.titanium.facing_handler." + facing.name().toLowerCase(), new Object[0]));
                            strings.add(TextFormatting.GOLD + LangUtil.get("tooltip.titanium.facing_handler.action", new Object[0]) + mode.getColor() + LangUtil.get("tooltip.titanium.facing_handler." + this.getStateInfo().getTooltip()[0], new Object[0]));
                            return strings;
                        }
                    };
                    this.buttonAddons.add(addon);
                    ((GuiContainerTileBase)screen).getAddons().add(addon);
                }
            }
        }
    }

    public boolean isClicked() {
        return this.clicked;
    }

    public void setClicked(GuiContainerTileBase information, boolean clicked) {
        this.clicked = clicked;
        if (!clicked) {
            information.getAddons().removeIf(iGuiAddon -> this.buttonAddons.contains(iGuiAddon));
            this.buttonAddons.clear();
            ((ContainerTileBase)information.func_212873_a_()).setDisabled(false);
        }
    }
}

