/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.gui.addon;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.gui.addon.BasicGuiAddon;
import com.hrznstudio.titanium.client.gui.asset.IAssetProvider;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyBarGuiAddon
extends BasicGuiAddon {
    private final IEnergyStorage handler;
    private IAsset background;

    public EnergyBarGuiAddon(int posX, int posY, IEnergyStorage handler) {
        super(posX, posY);
        this.handler = handler;
    }

    @Override
    public void drawGuiContainerBackgroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.background = IAssetProvider.getAsset(provider, AssetTypes.ENERGY_BACKGROUND);
        Point offset = this.background.getOffset();
        Rectangle area = this.background.getArea();
        screen.getMinecraft().func_110434_K().func_110577_a(this.background.getResourceLocation());
        screen.blit(guiX + this.getPosX() + offset.x, guiY + this.getPosY() + offset.y, area.x, area.y, area.width, area.height);
    }

    @Override
    public void drawGuiContainerForegroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
        IAsset asset = IAssetProvider.getAsset(provider, AssetTypes.ENERGY_BAR);
        Point offset = asset.getOffset();
        Rectangle area = asset.getArea();
        screen.getMinecraft().func_110434_K().func_110577_a(asset.getResourceLocation());
        long stored = this.handler.getEnergyStored();
        long capacity = this.handler.getMaxEnergyStored();
        int powerOffset = (int)(stored * (long)area.height / capacity);
        screen.blit(this.getPosX() + offset.x, this.getPosY() + offset.y + area.height - powerOffset, area.x, area.y + (area.height - powerOffset), area.width, powerOffset);
    }

    @Override
    public List<String> getTooltipLines() {
        return Arrays.asList(TextFormatting.GOLD + "Power:", new DecimalFormat().format(this.handler.getEnergyStored()) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(this.handler.getMaxEnergyStored()) + TextFormatting.DARK_AQUA + " FE");
    }

    @Override
    public int getXSize() {
        return this.background != null ? this.background.getArea().width : 0;
    }

    @Override
    public int getYSize() {
        return this.background != null ? this.background.getArea().height : 0;
    }
}

