/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium;

import com.hrznstudio.titanium.TitaniumClient;
import com.hrznstudio.titanium._impl.creative.BlockCreativeFEGenerator;
import com.hrznstudio.titanium._impl.test.BlockAssetTest;
import com.hrznstudio.titanium._impl.test.BlockTest;
import com.hrznstudio.titanium._impl.test.BlockTwentyFourTest;
import com.hrznstudio.titanium._impl.test.recipe.TestSerializableRecipe;
import com.hrznstudio.titanium.block.BlockBase;
import com.hrznstudio.titanium.block.tile.TileActive;
import com.hrznstudio.titanium.client.gui.container.GuiContainerTileBase;
import com.hrznstudio.titanium.command.RewardCommand;
import com.hrznstudio.titanium.command.RewardGrantCommand;
import com.hrznstudio.titanium.container.impl.ContainerTileBase;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.Feature;
import com.hrznstudio.titanium.module.Module;
import com.hrznstudio.titanium.module.ModuleController;
import com.hrznstudio.titanium.network.NetworkHandler;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.reward.Reward;
import com.hrznstudio.titanium.reward.RewardManager;
import com.hrznstudio.titanium.reward.RewardSyncMessage;
import com.hrznstudio.titanium.reward.storage.RewardWorldStorage;
import com.hrznstudio.titanium.util.SidedHandler;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="titanium")
public class Titanium
extends ModuleController {
    public static final String MODID = "titanium";
    public static final Logger LOGGER = LogManager.getLogger((String)"titanium");

    public Titanium() {
        NetworkHandler.registerMessage(ButtonClickNetworkMessage.class);
        NetworkHandler.registerMessage(RewardSyncMessage.class);
        SidedHandler.runOn(Dist.CLIENT, () -> () -> EventManager.mod(FMLClientSetupEvent.class).process(this::clientSetup).subscribe());
        EventManager.mod(FMLCommonSetupEvent.class).process(this::commonSetup).subscribe();
        EventManager.forge(PlayerEvent.PlayerLoggedInEvent.class).process(this::onPlayerLoggedIn).subscribe();
        EventManager.forge(FMLServerStartingEvent.class).process(this::onServerStart).subscribe();
    }

    public static void openGui(TileActive tile, ServerPlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)tile, (BlockPos)tile.func_174877_v());
    }

    @Override
    protected void initModules() {
        this.addModule(Module.builder("core").force().feature((Feature.Builder)Feature.builder("core").force().content(ContainerType.class, (IForgeRegistryEntry)((ContainerType)IForgeContainerType.create(ContainerTileBase::new).setRegistryName(new ResourceLocation(MODID, "tile_container"))))));
        BlockTest.TEST = new BlockTest();
        BlockTwentyFourTest.TEST = new BlockTwentyFourTest();
        BlockAssetTest.TEST = new BlockAssetTest();
        this.addModule(Module.builder("test_module").disableByDefault().description("Test module for titanium features").feature((Feature.Builder)((Feature.Builder)((Feature.Builder)Feature.builder("blocks").description("Adds test titanium blocks").content(Block.class, (IForgeRegistryEntry)BlockTest.TEST)).content(Block.class, (IForgeRegistryEntry)BlockTwentyFourTest.TEST)).content(Block.class, (IForgeRegistryEntry)BlockAssetTest.TEST)).feature(Feature.builder("events").description("Adds test titanium events").event(EventManager.forge(EntityItemPickupEvent.class).filter(ev -> ev.getItem().func_92059_d().func_77973_b() == Items.field_151055_y).process(ev -> {
            ev.getItem().lifespan = 0;
        }).cancel())).feature(((Feature.Builder)Feature.builder("recipe").description("Testing of recipe stuff").content(IRecipeSerializer.class, (IForgeRegistryEntry)TestSerializableRecipe.SERIALIZER)).event(EventManager.mod(FMLCommonSetupEvent.class).process(event -> {
            IRecipeType cfr_ignored_0 = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)TestSerializableRecipe.SERIALIZER.getRegistryName(), TestSerializableRecipe.SERIALIZER.getRecipeType());
        })).event(EventManager.forge(PlayerInteractEvent.LeftClickBlock.class).filter(leftClickBlock -> !leftClickBlock.getWorld().field_72995_K && leftClickBlock.getPlayer() != null).process(leftClickBlock -> {
            Map recipes = (Map)ObfuscationReflectionHelper.getPrivateValue(RecipeManager.class, (Object)leftClickBlock.getWorld().func_199532_z(), (String)"field_199522_d");
            ((Map)recipes.get(TestSerializableRecipe.SERIALIZER.getRecipeType())).values().stream().map(iRecipe -> (TestSerializableRecipe)iRecipe).filter(testSerializableRecipe -> testSerializableRecipe.isValid(leftClickBlock.getPlayer().func_184586_b(leftClickBlock.getHand()), leftClickBlock.getWorld().func_180495_p(leftClickBlock.getPos()).func_177230_c())).findFirst().ifPresent(testSerializableRecipe -> {
                leftClickBlock.getPlayer().func_184586_b(leftClickBlock.getHand()).func_190918_g(1);
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)leftClickBlock.getPlayer(), (ItemStack)testSerializableRecipe.func_77571_b().func_77946_l());
                leftClickBlock.setCanceled(true);
            });
        }))));
        this.addModule(Module.builder("creative").disableByDefault().description("Creative features").feature((Feature.Builder)Feature.builder("blocks").description("Adds creative machine features").content(Block.class, (IForgeRegistryEntry)BlockCreativeFEGenerator.INSTANCE)));
    }

    @Override
    public void initJsonGenerators() {
        this.addJsonDataGenerator(BlockBase.BLOCK_LOOT);
        this.addJsonDataGenerator(TestSerializableRecipe.RECIPE);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        RewardManager.get().getRewards().values().forEach(rewardGiver -> rewardGiver.getRewards().forEach(reward -> reward.register(Dist.DEDICATED_SERVER)));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        EventManager.forge(DrawBlockHighlightEvent.class).process(TitaniumClient::blockOverlayEvent).subscribe();
        TitaniumClient.registerModelLoader();
        RewardManager.get().getRewards().values().forEach(rewardGiver -> rewardGiver.getRewards().forEach(reward -> reward.register(Dist.CLIENT)));
        ScreenManager.func_216911_a(ContainerTileBase.TYPE, GuiContainerTileBase::new);
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        event.getPlayer().func_184102_h().execute(() -> {
            RewardWorldStorage storage = RewardWorldStorage.get(event.getPlayer().func_184102_h().func_71218_a(DimensionType.field_223227_a_));
            if (!storage.getConfiguredPlayers().contains(event.getPlayer().func_110124_au())) {
                for (ResourceLocation collectRewardsResourceLocation : RewardManager.get().collectRewardsResourceLocations(event.getPlayer().func_110124_au())) {
                    Reward reward = RewardManager.get().getReward(collectRewardsResourceLocation);
                    storage.add(event.getPlayer().func_110124_au(), reward.getResourceLocation(), reward.getOptions()[0]);
                }
                storage.getConfiguredPlayers().add(event.getPlayer().func_110124_au());
                storage.func_76185_a();
            }
            CompoundNBT nbt = storage.serializeSimple();
            event.getPlayer().func_184102_h().func_184103_al().func_181057_v().forEach(serverPlayerEntity -> NetworkHandler.NETWORK.sendTo((Object)new RewardSyncMessage(nbt), serverPlayerEntity.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT));
        });
    }

    private void onServerStart(FMLServerStartingEvent event) {
        RewardCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        RewardGrantCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }
}

