/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.blocks;

import com.direwolf20.buildinggadgets.api.building.BlockData;
import com.direwolf20.buildinggadgets.api.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.tools.UniqueItem;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;

@Deprecated
public class BlockMapIntState {
    public Map<Short, BlockState> intStateMap = new HashMap<Short, BlockState>();
    public Map<BlockState, UniqueItem> intStackMap = new HashMap<BlockState, UniqueItem>();

    public Map<BlockState, UniqueItem> getIntStackMap() {
        return this.intStackMap;
    }

    public void addToMap(BlockState mapState) {
        if (this.findSlot(mapState) == -1) {
            short nextSlot = (short)this.intStateMap.size();
            nextSlot = (short)(nextSlot + 1);
            this.intStateMap.put(nextSlot, mapState);
        }
    }

    public void addToStackMap(UniqueItem uniqueItem, BlockState blockState) {
        if (this.findStackSlot(uniqueItem) != blockState) {
            this.intStackMap.put(blockState, uniqueItem);
        }
    }

    public Short findSlot(BlockState mapState) {
        for (Map.Entry<Short, BlockState> entry : this.intStateMap.entrySet()) {
            if (entry.getValue() != mapState) continue;
            return entry.getKey();
        }
        return (short)-1;
    }

    @Nullable
    private BlockState findStackSlot(UniqueItem uniqueItem) {
        for (Map.Entry<BlockState, UniqueItem> entry : this.intStackMap.entrySet()) {
            if (entry.getValue().getItem() != uniqueItem.getItem()) continue;
            return entry.getKey();
        }
        return null;
    }

    public BlockState getStateFromSlot(Short slot) {
        return this.intStateMap.get(slot);
    }

    public UniqueItem getStackFromSlot(BlockState blockState) {
        return this.intStackMap.get(blockState);
    }

    public Map<Short, BlockState> getIntStateMapFromNBT(ListNBT tagList) {
        this.intStateMap = new HashMap<Short, BlockState>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT compound = tagList.func_150305_b(i);
            this.intStateMap.put(compound.func_74765_d("slot"), NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("state")));
        }
        return this.intStateMap;
    }

    public ListNBT putIntStateMapIntoNBT() {
        ListNBT tagList = new ListNBT();
        for (Map.Entry<Short, BlockState> entry : this.intStateMap.entrySet()) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74777_a("slot", entry.getKey().shortValue());
            compound.func_218657_a("state", (INBT)NBTUtil.func_190009_a((BlockState)entry.getValue()));
            tagList.add((Object)compound);
        }
        return tagList;
    }

    public Map<BlockState, UniqueItem> getIntStackMapFromNBT(ListNBT tagList) {
        this.intStackMap = new HashMap<BlockState, UniqueItem>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT compound = tagList.func_150305_b(i);
            this.intStackMap.put(GadgetUtils.compoundToState(compound.func_74775_l("state")), UniqueItem.readFromNBT(compound));
        }
        return this.intStackMap;
    }

    public ListNBT putIntStackMapIntoNBT() {
        ListNBT tagList = new ListNBT();
        for (Map.Entry<BlockState, UniqueItem> entry : this.intStackMap.entrySet()) {
            CompoundNBT compound = new CompoundNBT();
            entry.getValue().writeToNBT(compound);
            compound.func_218657_a("state", (INBT)GadgetUtils.stateToCompound(entry.getKey()));
            tagList.add((Object)compound);
        }
        return tagList;
    }

    @Nonnull
    public static UniqueItem blockStateToUniqueItem(BlockData state, PlayerEntity player, BlockPos pos) {
        return UniqueItem.fromBlockState(state.getState(), player, pos);
    }

    public void makeStackMapFromStateMap(PlayerEntity player) {
        this.intStackMap.clear();
        for (Map.Entry<Short, BlockState> entry : this.intStateMap.entrySet()) {
            try {
                this.intStackMap.put(entry.getValue(), BlockMapIntState.blockStateToUniqueItem(new BlockData(entry.getValue(), TileSupport.dummyTileEntityData()), player, new BlockPos(0, 0, 0)));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }
}

