/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReflectionUtil {
    public static final Predicate<Field> PREDICATE_STATIC = field -> Modifier.isStatic(field.getModifiers());

    public static List<Field> getFilteredFields(Class<?> clazz, Predicate<Field> filter) {
        return (List)Stream.of(clazz.getDeclaredFields()).filter(filter).collect(ImmutableList.toImmutableList());
    }

    public static boolean isInstanceProvidedForField(@Nonnull Field field, @Nullable Object instance) {
        return instance != null && !PREDICATE_STATIC.test(field) && field.getDeclaringClass().isAssignableFrom(instance.getClass()) || instance == null && PREDICATE_STATIC.test(field);
    }
}

