/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util;

import com.direwolf20.buildinggadgets.api.building.BlockData;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.InventoryWrapper;
import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.network.packets.PacketRotateMirror;
import com.direwolf20.buildinggadgets.common.tiles.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.exceptions.CapabilityNotPresentException;
import com.direwolf20.buildinggadgets.common.util.helpers.InventoryHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.tools.NetworkIO;
import com.direwolf20.buildinggadgets.common.util.tools.UndoState;
import com.direwolf20.buildinggadgets.common.util.tools.UniqueItem;
import com.direwolf20.buildinggadgets.common.util.tools.modes.BuildingMode;
import com.direwolf20.buildinggadgets.common.util.tools.modes.ExchangingMode;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class GadgetUtils {
    private static final ImmutableList<String> LINK_STARTS = ImmutableList.of((Object)"http", (Object)"www");

    public static boolean mightBeLink(String s) {
        return LINK_STARTS.stream().anyMatch(s::startsWith);
    }

    public static String getStackErrorSuffix(ItemStack stack) {
        return GadgetUtils.getStackErrorText(stack) + " with NBT tag: " + stack.func_77978_p();
    }

    private static String getStackErrorText(ItemStack stack) {
        return "the following stack: [" + stack + "]";
    }

    public static CompoundNBT enforceHasTag(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    @Nullable
    public static ByteArrayOutputStream getPasteStream(@Nonnull CompoundNBT compound, @Nullable String name) throws IOException {
        CompoundNBT withText;
        CompoundNBT compoundNBT = withText = name != null && !name.isEmpty() ? compound.func_74737_b() : compound;
        if (name != null && !name.isEmpty()) {
            withText.func_74778_a("template_name", name);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompressedStreamTools.func_74799_a((CompoundNBT)withText, (OutputStream)baos);
        return baos.size() < 32567 ? baos : null;
    }

    @Nonnull
    public static CompoundNBT getStackTag(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            throw new IllegalArgumentException("An NBT tag could net be retrieved from " + GadgetUtils.getStackErrorText(stack));
        }
        return tag;
    }

    public static void pushUndoList(ItemStack stack, UndoState undoState) {
        ListNBT undoStates;
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        if ((undoStates = (ListNBT)tagCompound.func_74781_a("undo_stack")) == null) {
            undoStates = new ListNBT();
        }
        if (undoStates.size() >= 10) {
            undoStates.remove(0);
        }
        undoStates.add((Object)GadgetUtils.undoStateToNBT(undoState));
        tagCompound.func_218657_a("undo_stack", (INBT)undoStates);
        stack.func_77982_d(tagCompound);
    }

    @Nullable
    public static UndoState popUndoList(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        ListNBT undoStates = (ListNBT)tagCompound.func_74781_a("undo_stack");
        if (undoStates == null || undoStates.size() == 0) {
            return null;
        }
        UndoState undoState = GadgetUtils.NBTToUndoState(undoStates.func_150305_b(undoStates.size() - 1));
        undoStates.remove(undoStates.size() - 1);
        tagCompound.func_218657_a("undo_stack", (INBT)undoStates);
        return undoState;
    }

    private static CompoundNBT undoStateToNBT(UndoState undoState) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("dim", DimensionType.func_212678_a((DimensionType)undoState.dimension).toString());
        BlockPos startBlock = undoState.coordinates.get(0);
        int[] array = new int[undoState.coordinates.size()];
        int idx = 0;
        for (BlockPos coord : undoState.coordinates) {
            int px = (coord.func_177958_n() - startBlock.func_177958_n() & 0xFF) << 16;
            int py = (coord.func_177956_o() - startBlock.func_177956_o() & 0xFF) << 8;
            int pz = coord.func_177952_p() - startBlock.func_177952_p() & 0xFF;
            int p = px + py + pz;
            array[idx++] = p;
        }
        compound.func_218657_a("undo_start_pos", (INBT)NBTUtil.func_186859_a((BlockPos)startBlock));
        compound.func_74783_a("undo_int_coords", array);
        return compound;
    }

    @Nullable
    private static UndoState NBTToUndoState(CompoundNBT compound) {
        DimensionType dim = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(compound.func_74779_i("dim")));
        if (dim == null) {
            return null;
        }
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        int[] array = compound.func_74759_k("undo_int_coords");
        BlockPos startBlock = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("undo_start_pos"));
        for (int i = 0; i <= array.length - 1; ++i) {
            int p = array[i];
            int x = startBlock.func_177958_n() + (byte)((p & 0xFF0000) >> 16);
            int y = startBlock.func_177956_o() + (byte)((p & 0xFF00) >> 8);
            int z = startBlock.func_177952_p() + (byte)(p & 0xFF);
            coordinates.add(new BlockPos(x, y, z));
        }
        return new UndoState(dim, coordinates);
    }

    public static void setAnchor(ItemStack stack, List<BlockPos> coordinates) {
        CompoundNBT tagCompound = stack.func_77978_p();
        ListNBT coords = new ListNBT();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        for (BlockPos coord : coordinates) {
            coords.add((Object)NBTUtil.func_186859_a((BlockPos)coord));
        }
        tagCompound.func_218657_a("anchor_coords", (INBT)coords);
        stack.func_77982_d(tagCompound);
    }

    public static List<BlockPos> getAnchor(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        if (tagCompound == null) {
            GadgetUtils.setAnchor(stack, coordinates);
            return coordinates;
        }
        ListNBT coordList = (ListNBT)tagCompound.func_74781_a("anchor_coords");
        if (coordList == null) {
            GadgetUtils.setAnchor(stack, coordinates);
            return coordinates;
        }
        if (coordList.size() == 0) {
            return coordinates;
        }
        for (int i = 0; i < coordList.size(); ++i) {
            coordinates.add(NBTUtil.func_186861_c((CompoundNBT)coordList.func_150305_b(i)));
        }
        return coordinates;
    }

    public static void setToolRange(ItemStack stack, int range) {
        CompoundNBT tagCompound = NBTHelper.getOrNewTag(stack);
        tagCompound.func_74768_a("range", range);
    }

    public static int getToolRange(ItemStack stack) {
        CompoundNBT tagCompound = NBTHelper.getOrNewTag(stack);
        return MathHelper.func_76125_a((int)tagCompound.func_74762_e("range"), (int)1, (int)15);
    }

    public static BlockData rotateOrMirrorBlock(PlayerEntity player, PacketRotateMirror.Operation operation, BlockData data) {
        if (operation == PacketRotateMirror.Operation.MIRROR) {
            return data.mirror(player.func_174811_aO().func_176740_k() == Direction.Axis.X ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK);
        }
        return data.rotate(Rotation.CLOCKWISE_90);
    }

    public static void rotateOrMirrorToolBlock(ItemStack stack, ServerPlayerEntity player, PacketRotateMirror.Operation operation) {
        GadgetUtils.setToolBlock(stack, GadgetUtils.rotateOrMirrorBlock((PlayerEntity)player, operation, GadgetUtils.getToolBlock(stack)));
        GadgetUtils.setToolActualBlock(stack, GadgetUtils.rotateOrMirrorBlock((PlayerEntity)player, operation, GadgetUtils.getToolActualBlock(stack)));
    }

    private static void setToolBlock(ItemStack stack, @Nullable BlockData data) {
        CompoundNBT tagCompound = NBTHelper.getOrNewTag(stack);
        if (data == null) {
            data = BlockData.AIR;
        }
        CompoundNBT stateTag = data.serialize(true);
        tagCompound.func_218657_a("state", (INBT)stateTag);
        stack.func_77982_d(tagCompound);
    }

    private static void setToolActualBlock(ItemStack stack, @Nullable BlockData data) {
        CompoundNBT tagCompound = NBTHelper.getOrNewTag(stack);
        if (data == null) {
            data = BlockData.AIR;
        }
        CompoundNBT dataTag = data.serialize(true);
        tagCompound.func_218657_a("state_actual", (INBT)dataTag);
        stack.func_77982_d(tagCompound);
    }

    @Nonnull
    public static BlockData getToolBlock(ItemStack stack) {
        CompoundNBT tagCompound = NBTHelper.getOrNewTag(stack);
        BlockData res = BlockData.tryDeserialize(tagCompound.func_74775_l("state"), true);
        if (res == null) {
            GadgetUtils.setToolActualBlock(stack, BlockData.AIR);
            return BlockData.AIR;
        }
        return res;
    }

    @Nonnull
    public static BlockData getToolActualBlock(ItemStack stack) {
        CompoundNBT tagCompound = NBTHelper.getOrNewTag(stack);
        BlockData res = BlockData.tryDeserialize(tagCompound.func_74775_l("state_actual"), true);
        if (res == null) {
            GadgetUtils.setToolActualBlock(stack, BlockData.AIR);
            return BlockData.AIR;
        }
        return res;
    }

    public static void bindToolToTE(ItemStack stack, PlayerEntity player) {
        World world = player.field_70170_p;
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, AbstractGadget.shouldRayTraceFluid(stack) ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE);
        if (lookingAt == null || world.func_180495_p(VectorHelper.getLookingAt(player, stack).func_216350_a()) == Blocks.field_150350_a.func_176223_P()) {
            return;
        }
        ActionResultType result = GadgetUtils.setRemoteInventory(stack, player, world, lookingAt.func_216350_a(), true);
    }

    public static void selectBlock(ItemStack stack, PlayerEntity player) {
        World world = player.field_70170_p;
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, AbstractGadget.shouldRayTraceFluid(stack) ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE);
        if (lookingAt == null || world.func_180495_p(VectorHelper.getLookingAt(player, stack).func_216350_a()) == Blocks.field_150350_a.func_176223_P()) {
            return;
        }
        BlockState state = world.func_180495_p(lookingAt.func_216350_a());
        if (!Config.BLACKLIST.isAllowedBlock(state.func_177230_c())) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + new TranslationTextComponent("message.gadget.invalidblock", new Object[0]).func_150261_e()), true);
            return;
        }
        BlockData placeState = InventoryHelper.getSpecificStates(state, world, player, lookingAt.func_216350_a(), stack);
        BlockState actualState = placeState.getState().getExtendedState((IBlockReader)world, lookingAt.func_216350_a());
        GadgetUtils.setToolBlock(stack, placeState);
        GadgetUtils.setToolActualBlock(stack, new BlockData(actualState, placeState.getTileData()));
    }

    public static ActionResultType setRemoteInventory(ItemStack stack, PlayerEntity player, World world, BlockPos pos, boolean setTool) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return ActionResultType.PASS;
        }
        if (setTool && te instanceof ConstructionBlockTileEntity && ((ConstructionBlockTileEntity)te).getConstructionBlockData() != null) {
            GadgetUtils.setToolBlock(stack, ((ConstructionBlockTileEntity)te).getActualBlockData());
            GadgetUtils.setToolActualBlock(stack, ((ConstructionBlockTileEntity)te).getActualBlockData());
            return ActionResultType.SUCCESS;
        }
        if (GadgetUtils.setRemoteInventory(player, stack, pos, world)) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public static boolean anchorBlocks(PlayerEntity player, ItemStack stack) {
        World world = player.field_70170_p;
        List<BlockPos> currentCoords = GadgetUtils.getAnchor(stack);
        if (currentCoords.size() == 0) {
            BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, stack);
            if (lookingAt == null || world.func_180495_p(VectorHelper.getLookingAt(player, stack).func_216350_a()) == Blocks.field_150350_a.func_176223_P()) {
                return false;
            }
            BlockPos startBlock = lookingAt.func_216350_a();
            Direction sideHit = lookingAt.func_216354_b();
            if (startBlock == null || world.func_180495_p(startBlock) == Blocks.field_150350_a.func_176223_P()) {
                return false;
            }
            List<BlockPos> coords = new ArrayList<BlockPos>();
            if (stack.func_77973_b() instanceof GadgetBuilding) {
                coords = BuildingMode.collectPlacementPos((IWorld)world, player, startBlock, sideHit, stack, startBlock);
            } else if (stack.func_77973_b() instanceof GadgetExchanger) {
                coords = ExchangingMode.collectPlacementPos((IWorld)world, player, startBlock, sideHit, stack, startBlock);
            }
            GadgetUtils.setAnchor(stack, coords);
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + new TranslationTextComponent("message.gadget.anchorrender", new Object[0]).func_150261_e()), true);
        } else {
            GadgetUtils.setAnchor(stack, new ArrayList<BlockPos>());
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + new TranslationTextComponent("message.gadget.anchorremove", new Object[0]).func_150261_e()), true);
        }
        return true;
    }

    public static boolean setRemoteInventory(PlayerEntity player, ItemStack tool, BlockPos pos, World world) {
        if (GadgetUtils.getRemoteInventory(pos, DimensionType.func_212678_a((DimensionType)player.field_71093_bK), world) != null) {
            boolean same = pos.equals((Object)GadgetUtils.getPOSFromNBT(tool, "bound_te_pos"));
            GadgetUtils.writePOSToNBT(tool, same ? null : pos, "bound_te_pos", player.field_71093_bK);
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + new TranslationTextComponent("message.gadget." + (same ? "unboundTE" : "boundTE"), new Object[0]).func_150261_e()), true);
            return true;
        }
        return false;
    }

    @Nullable
    public static IItemHandler getRemoteInventory(ItemStack tool, World world) {
        return GadgetUtils.getRemoteInventory(tool, world, NetworkIO.Operation.EXTRACT);
    }

    @Nullable
    public static IItemHandler getRemoteInventory(ItemStack tool, World world, NetworkIO.Operation operation) {
        ResourceLocation dim = GadgetUtils.getDIMFromNBT(tool, "bound_te_pos");
        if (dim == null) {
            return null;
        }
        BlockPos pos = GadgetUtils.getPOSFromNBT(tool, "bound_te_pos");
        return pos == null ? null : GadgetUtils.getRemoteInventory(pos, dim, world);
    }

    @Nullable
    public static IItemHandler getRemoteInventory(BlockPos pos, ResourceLocation dim, World world) {
        return GadgetUtils.getRemoteInventory(pos, dim, world, NetworkIO.Operation.EXTRACT);
    }

    @Nullable
    public static IItemHandler getRemoteInventory(BlockPos pos, ResourceLocation dimName, World world, NetworkIO.Operation operation) {
        DimensionType dim = DimensionType.func_193417_a((ResourceLocation)dimName);
        if (dim == null) {
            return null;
        }
        MinecraftServer server = world.func_73046_m();
        if (server == null) {
            return null;
        }
        ServerWorld worldServer = server.func_71218_a(dim);
        if (worldServer == null) {
            return null;
        }
        return GadgetUtils.getRemoteInventory(pos, (World)worldServer, operation);
    }

    @Nullable
    public static IItemHandler getRemoteInventory(BlockPos pos, World world, NetworkIO.Operation operation) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        LazyOptional cap = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!cap.isPresent()) {
            return null;
        }
        return (IItemHandler)cap.orElseThrow(CapabilityNotPresentException::new);
    }

    public static String withSuffix(int count) {
        if (count < 1000) {
            return "" + count;
        }
        int exp = (int)(Math.log(count) / Math.log(1000.0));
        return String.format("%.1f%c", (double)count / Math.pow(1000.0, exp), Character.valueOf("kMGTPE".charAt(exp - 1)));
    }

    public static void writePOSToNBT(ItemStack stack, @Nullable BlockPos pos, String tagName) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        if (pos == null) {
            if (tagCompound.func_74781_a(tagName) != null) {
                tagCompound.func_82580_o(tagName);
                stack.func_77982_d(tagCompound);
            }
            return;
        }
        tagCompound.func_218657_a(tagName, (INBT)NBTUtil.func_186859_a((BlockPos)pos));
        stack.func_77982_d(tagCompound);
    }

    public static void writePOSToNBT(ItemStack stack, @Nullable BlockPos pos, String tagName, DimensionType dimension) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        if (pos == null) {
            tagCompound.func_74781_a(tagName);
            tagCompound.func_82580_o(tagName);
            stack.func_77982_d(tagCompound);
            return;
        }
        CompoundNBT posTag = NBTUtil.func_186859_a((BlockPos)pos);
        posTag.func_74778_a("dim", DimensionType.func_212678_a((DimensionType)dimension).toString());
        tagCompound.func_218657_a(tagName, (INBT)posTag);
        stack.func_77982_d(tagCompound);
    }

    public static void writePOSToNBT(CompoundNBT tagCompound, @Nullable BlockPos pos, String tagName, DimensionType dimension) {
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        if (pos == null) {
            tagCompound.func_74781_a(tagName);
            tagCompound.func_82580_o(tagName);
            return;
        }
        tagCompound.func_218657_a(tagName, (INBT)NBTUtil.func_186859_a((BlockPos)pos));
        tagCompound.func_74778_a("dim", DimensionType.func_212678_a((DimensionType)dimension).toString());
    }

    @Nullable
    public static BlockPos getPOSFromNBT(ItemStack stack, String tagName) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        CompoundNBT posTag = tagCompound.func_74775_l(tagName);
        if (posTag.equals((Object)new CompoundNBT())) {
            return null;
        }
        return NBTUtil.func_186861_c((CompoundNBT)posTag);
    }

    public static void writeIntToNBT(ItemStack stack, int tagInt, String tagName) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        tagCompound.func_74768_a(tagName, tagInt);
        stack.func_77982_d(tagCompound);
    }

    public static int getIntFromNBT(ItemStack stack, String tagName) {
        CompoundNBT tagCompound = stack.func_77978_p();
        return tagCompound == null ? 0 : tagCompound.func_74762_e(tagName);
    }

    public static void writeStringToNBT(ItemStack stack, String string, String tagName) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        if (string.equals(null)) {
            if (tagCompound.func_74781_a(tagName) != null) {
                tagCompound.func_82580_o(tagName);
            }
            return;
        }
        tagCompound.func_74778_a(tagName, string);
    }

    public static void writeStringToNBT(CompoundNBT tagCompound, String string, String tagName) {
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        if (string.equals(null)) {
            if (tagCompound.func_74781_a(tagName) != null) {
                tagCompound.func_82580_o(tagName);
            }
            return;
        }
        tagCompound.func_74778_a(tagName, string);
    }

    @Nullable
    public static String getStringFromNBT(ItemStack stack, String tagName) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        return tagCompound.func_74779_i(tagName);
    }

    @Nullable
    public static BlockPos getPOSFromNBT(CompoundNBT tagCompound, String tagName) {
        if (tagCompound == null) {
            return null;
        }
        CompoundNBT posTag = tagCompound.func_74775_l(tagName);
        if (posTag.equals((Object)new CompoundNBT())) {
            return null;
        }
        return NBTUtil.func_186861_c((CompoundNBT)posTag);
    }

    @Nullable
    public static ResourceLocation getDIMFromNBT(ItemStack stack, String tagName) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        CompoundNBT posTag = tagCompound.func_74775_l(tagName);
        if (posTag.equals((Object)new CompoundNBT())) {
            return null;
        }
        return new ResourceLocation(posTag.func_74779_i("dim"));
    }

    public static CompoundNBT stateToCompound(BlockState state) {
        return NBTUtil.func_190009_a((BlockState)state);
    }

    @Nullable
    public static BlockState compoundToState(@Nullable CompoundNBT tagCompound) {
        if (tagCompound == null) {
            return null;
        }
        return NBTUtil.func_190008_d((CompoundNBT)tagCompound);
    }

    public static int relPosToInt(BlockPos startPos, BlockPos relPos) {
        int px = (relPos.func_177958_n() - startPos.func_177958_n() & 0xFF) << 16;
        int py = (relPos.func_177956_o() - startPos.func_177956_o() & 0xFF) << 8;
        int pz = relPos.func_177952_p() - startPos.func_177952_p() & 0xFF;
        int p = px + py + pz;
        return p;
    }

    public static BlockPos relIntToPos(BlockPos startPos, int relInt) {
        int p = relInt;
        int x = startPos.func_177958_n() + (byte)((p & 0xFF0000) >> 16);
        int y = startPos.func_177956_o() + (byte)((p & 0xFF00) >> 8);
        int z = startPos.func_177952_p() + (byte)(p & 0xFF);
        return new BlockPos(x, y, z);
    }

    public static ListNBT itemCountToNBT(Multiset<UniqueItem> itemCountMap) {
        ListNBT tagList = new ListNBT();
        for (Multiset.Entry entry : itemCountMap.entrySet()) {
            int item = Item.func_150891_b((Item)((UniqueItem)entry.getElement()).getItem());
            int count = entry.getCount();
            CompoundNBT tagCompound = new CompoundNBT();
            tagCompound.func_74768_a("item", item);
            tagCompound.func_74768_a("count", count);
            tagList.add((Object)tagCompound);
        }
        return tagList;
    }

    public static Multiset<UniqueItem> nbtToItemCount(@Nullable ListNBT tagList) {
        if (tagList == null) {
            return HashMultiset.create();
        }
        HashMultiset itemCountMap = HashMultiset.create((int)tagList.size());
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tagCompound = tagList.func_150305_b(i);
            UniqueItem uniqueItem = new UniqueItem(Item.func_150899_d((int)tagCompound.func_74762_e("item")));
            int count = tagCompound.func_74762_e("count");
            itemCountMap.setCount((Object)uniqueItem, count);
        }
        return itemCountMap;
    }

    public static int getItemBurnTime(ItemStack stack) {
        return ForgeEventFactory.getItemBurnTime((ItemStack)stack, (int)(stack.getBurnTime() == -1 ? AbstractFurnaceTileEntity.func_214001_f().getOrDefault(stack.func_77973_b(), 0).intValue() : stack.getBurnTime()));
    }

    public static void dropTileEntityInventory(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            LazyOptional cap = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            cap.ifPresent(handler -> {
                if (handler instanceof IItemHandlerModifiable) {
                    net.minecraft.inventory.InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)new InventoryWrapper((IItemHandlerModifiable)handler));
                }
            });
        }
    }
}

