/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.registry.entity;

import com.direwolf20.buildinggadgets.common.registry.RegistryObjectBuilder;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public final class EntityBuilder<T extends Entity>
extends RegistryObjectBuilder<EntityType<?>, EntityType.Builder<T>> {
    private Class<T> entityClass;
    private Supplier<Supplier<IRenderFactory<? super T>>> renderFactory;

    public EntityBuilder(String registryName) {
        super(registryName);
    }

    public EntityBuilder(ResourceLocation registryName) {
        super(registryName);
    }

    public EntityBuilder<T> factory(Function<EntityType.Builder<T>, EntityType<?>> factory) {
        return (EntityBuilder)super.factory(factory);
    }

    public EntityBuilder<T> builder(EntityType.Builder<T> builder) {
        return (EntityBuilder)super.builder(builder);
    }

    public EntityBuilder<T> renderer(Class<T> entityClass, Supplier<Supplier<IRenderFactory<? super T>>> renderFactory) {
        this.entityClass = Objects.requireNonNull(entityClass);
        this.renderFactory = Objects.requireNonNull(renderFactory);
        return this;
    }

    @Override
    public EntityType<?> construct() {
        Preconditions.checkState((this.renderFactory != null ? 1 : 0) != 0, (Object)"Cannot construct an Entity without an Renderer!");
        Preconditions.checkState((this.entityClass != null ? 1 : 0) != 0, (Object)"Cannot construct an Entity of unknown class!");
        return (EntityType)super.construct();
    }

    private Class<T> getEntityClass() {
        Preconditions.checkState((this.entityClass != null ? 1 : 0) != 0, (Object)"Cannot request Entity class before type has been constructed!");
        return this.entityClass;
    }

    private IRenderFactory<? super T> getRenderFactory() {
        Preconditions.checkState((this.renderFactory != null && this.renderFactory.get() != null && this.renderFactory.get().get() != null ? 1 : 0) != 0, (Object)"Expected Renderer to be present before EntityType has been constructed!");
        return this.renderFactory.get().get();
    }

    void registerRenderer() {
        RenderingRegistry.registerEntityRenderingHandler(this.getEntityClass(), this.getRenderFactory());
    }
}

