/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.registry.block.tile;

import com.direwolf20.buildinggadgets.common.registry.RegistryObjectBuilder;
import com.direwolf20.buildinggadgets.common.registry.block.tile.TileEntityTypeBuilder;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public final class TileEntityBuilder<T extends TileEntity>
extends RegistryObjectBuilder<TileEntityType<?>, TileEntityTypeBuilder<T>> {
    private Class<T> tileClass;
    private Supplier<Supplier<TileEntityRenderer<? super T>>> renderer;

    public TileEntityBuilder(String registryName) {
        super(registryName);
    }

    public TileEntityBuilder(ResourceLocation registryName) {
        super(registryName);
    }

    public TileEntityBuilder<T> factory(Function<TileEntityTypeBuilder<T>, TileEntityType<?>> factory) {
        return (TileEntityBuilder)super.factory(factory);
    }

    public TileEntityBuilder<T> builder(TileEntityTypeBuilder<T> builder) {
        return (TileEntityBuilder)super.builder(builder);
    }

    public TileEntityBuilder<T> renderer(Class<T> clazz, Supplier<Supplier<TileEntityRenderer<? super T>>> renderer) {
        this.tileClass = Objects.requireNonNull(clazz);
        this.renderer = Objects.requireNonNull(renderer);
        return this;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return super.getRegistryName();
    }

    public TileEntityBuilder<T> addValidBlock(ResourceLocation ... blocks) {
        ((TileEntityTypeBuilder)this.getBuilder()).addBlocks(blocks);
        return this;
    }

    private Class<T> getTileClass() {
        return this.tileClass;
    }

    @Nullable
    private TileEntityRenderer<? super T> getRenderer() {
        return this.renderer != null ? this.renderer.get().get() : null;
    }

    boolean hasRenderer() {
        return this.getRenderer() != null;
    }

    void registerRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(this.getTileClass(), this.getRenderer());
    }
}

