/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.registry;

import com.direwolf20.buildinggadgets.common.registry.RegistryObjectBuilder;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SimpleRegistryObjectBuilder<T extends IForgeRegistryEntry<T>>
extends RegistryObjectBuilder<T, ConstantObjectBuilder<T>> {
    private T obj;

    public SimpleRegistryObjectBuilder(String registryName) {
        super(registryName);
    }

    public SimpleRegistryObjectBuilder(ResourceLocation registryName) {
        super(registryName);
    }

    public SimpleRegistryObjectBuilder<T> factory(Function<ConstantObjectBuilder<T>, T> factory) {
        throw new AssertionError((Object)"This Object does not provide a builder. It should therefore also not need a factory.");
    }

    public SimpleRegistryObjectBuilder<T> builder(ConstantObjectBuilder<T> builder) {
        throw new AssertionError((Object)"This Object does not provide a builder. It should therefore also not need a builder.");
    }

    public SimpleRegistryObjectBuilder<T> object(T obj) {
        super.builder(new ConstantObjectBuilder<T>(obj));
        super.factory(ConstantObjectBuilder::build);
        this.obj = obj;
        return this;
    }

    public T getObj() {
        return this.obj;
    }

    static class ConstantObjectBuilder<T extends IForgeRegistryEntry<T>> {
        private final T object;

        ConstantObjectBuilder(T object) {
            this.object = (IForgeRegistryEntry)Objects.requireNonNull(object);
        }

        public T build() {
            return this.object;
        }
    }
}

