/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.blocks.TemplateManagerCommands;
import com.direwolf20.buildinggadgets.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets.common.tiles.TemplateManagerTileEntity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketTemplateManagerPaste {
    private final BlockPos pos;
    private final byte[] data;
    private final String templateName;

    public PacketTemplateManagerPaste(ByteArrayOutputStream pasteStream, BlockPos pos, String name) {
        this(pasteStream.toByteArray(), pos, name);
    }

    public PacketTemplateManagerPaste(byte[] data, BlockPos pos, String name) {
        this.pos = pos;
        this.data = data;
        this.templateName = name;
    }

    public static void encode(PacketTemplateManagerPaste msg, PacketBuffer buffer) {
        buffer.func_179250_a(msg.data);
        buffer.func_179255_a(msg.pos);
        buffer.func_211400_a(msg.templateName, 125);
    }

    public static PacketTemplateManagerPaste decode(PacketBuffer buffer) {
        return new PacketTemplateManagerPaste(buffer.func_179251_a(), buffer.func_179259_c(), buffer.func_150789_c(125));
    }

    public static class Handler {
        public static void handle(PacketTemplateManagerPaste msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(msg.data);
                try {
                    CompoundNBT newTag = CompressedStreamTools.func_74796_a((InputStream)inputStream);
                    if (newTag.equals((Object)new CompoundNBT())) {
                        return;
                    }
                    ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                    if (player == null) {
                        return;
                    }
                    World world = player.field_70170_p;
                    BlockPos pos = msg.pos;
                    TileEntity te = world.func_175625_s(pos);
                    if (!(te instanceof TemplateManagerTileEntity)) {
                        return;
                    }
                    TemplateManagerContainer container = ((TemplateManagerTileEntity)te).getContainer((PlayerEntity)player);
                    TemplateManagerCommands.pasteTemplate(container, (PlayerEntity)player, newTag, msg.templateName);
                }
                catch (IOException e) {
                    BuildingGadgets.LOG.error("Template Manager paste failed", (Throwable)e);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

