/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.common.blocks.TemplateManagerCommands;
import com.direwolf20.buildinggadgets.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets.common.tiles.TemplateManagerTileEntity;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketTemplateManagerLoad {
    private final BlockPos pos;

    public PacketTemplateManagerLoad(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(PacketTemplateManagerLoad msg, PacketBuffer buffer) {
        buffer.func_179255_a(msg.pos);
    }

    public static PacketTemplateManagerLoad decode(PacketBuffer buffer) {
        return new PacketTemplateManagerLoad(buffer.func_179259_c());
    }

    public static class Handler {
        public static void handle(PacketTemplateManagerLoad msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                World world = player.field_70170_p;
                BlockPos pos = msg.pos;
                TileEntity te = world.func_175625_s(pos);
                if (!(te instanceof TemplateManagerTileEntity)) {
                    return;
                }
                TemplateManagerContainer container = ((TemplateManagerTileEntity)te).getContainer((PlayerEntity)player);
                TemplateManagerCommands.loadTemplate(container, (PlayerEntity)player);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

