/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets;

import com.direwolf20.buildinggadgets.api.building.BlockData;
import com.direwolf20.buildinggadgets.api.building.Region;
import com.direwolf20.buildinggadgets.api.building.placement.IPositionPlacementSequence;
import com.direwolf20.buildinggadgets.api.building.placement.PlacementSequences;
import com.direwolf20.buildinggadgets.api.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.api.util.CommonUtils;
import com.direwolf20.buildinggadgets.client.gui.GuiMod;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BaseRenderer;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.DestructionRender;
import com.direwolf20.buildinggadgets.common.registry.objects.BGBlocks;
import com.direwolf20.buildinggadgets.common.tiles.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.blocks.RegionSnapshot;
import com.direwolf20.buildinggadgets.common.util.exceptions.PaletteOverflowException;
import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.SortingHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.tools.SetBackedPlacementSequence;
import com.direwolf20.buildinggadgets.common.world.WorldSave;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;

public class GadgetDestruction
extends AbstractGadget {
    public GadgetDestruction(Item.Properties builder) {
        super(builder);
    }

    @Override
    public int getEnergyMax() {
        return (Integer)Config.GADGETS.GADGET_DESTRUCTION.maxEnergy.get();
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return (Integer)Config.GADGETS.GADGET_DESTRUCTION.energyCost.get() * this.getCostMultiplier(tool);
    }

    @Override
    protected Supplier<BaseRenderer> createRenderFactory() {
        return DestructionRender::new;
    }

    private int getCostMultiplier(ItemStack tool) {
        return (int)(!GadgetDestruction.getFuzzy(tool) ? (Double)Config.GADGETS.GADGET_DESTRUCTION.nonFuzzyMultiplier.get() : 1.0);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add(TooltipTranslation.GADGET_DESTROYWARNING.componentTranslation(new Object[0]).func_150255_a(Styles.RED));
        tooltip.add(TooltipTranslation.GADGET_DESTROYSHOWOVERLAY.componentTranslation(String.valueOf(GadgetDestruction.getOverlay(stack))).func_150255_a(Styles.AQUA));
        tooltip.add(TooltipTranslation.GADGET_BUILDING_PLACE_ATOP.componentTranslation(String.valueOf(GadgetDestruction.getConnectedArea(stack))).func_150255_a(Styles.YELLOW));
        if (Config.isServerConfigLoaded() && ((Boolean)Config.GADGETS.GADGET_DESTRUCTION.nonFuzzyEnabled.get()).booleanValue()) {
            tooltip.add(TooltipTranslation.GADGET_FUZZY.componentTranslation(String.valueOf(GadgetDestruction.getFuzzy(stack))).func_150255_a(Styles.GOLD));
        }
        GadgetDestruction.addInformationRayTraceFluid(tooltip, stack);
        this.addEnergyInformation(tooltip, stack);
    }

    public static UUID getUUID(ItemStack stack) {
        CompoundNBT tag = NBTHelper.getOrNewTag(stack);
        if (!tag.func_186855_b("uuid")) {
            UUID uuid = UUID.randomUUID();
            tag.func_186854_a("uuid", uuid);
            stack.func_77982_d(tag);
            return uuid;
        }
        return tag.func_186857_a("uuid");
    }

    public static void setAnchor(ItemStack stack, BlockPos pos) {
        GadgetUtils.writePOSToNBT(stack, pos, "anchor");
    }

    public static BlockPos getAnchor(ItemStack stack) {
        return GadgetUtils.getPOSFromNBT(stack, "anchor");
    }

    public static void setAnchorSide(ItemStack stack, Direction side) {
        CompoundNBT tag = NBTHelper.getOrNewTag(stack);
        if (side == null) {
            tag.func_82580_o("anchor_side");
        } else {
            tag.func_74778_a("anchor_side", side.func_176610_l());
        }
    }

    public static Direction getAnchorSide(ItemStack stack) {
        CompoundNBT tag = NBTHelper.getOrNewTag(stack);
        String facing = tag.func_74779_i("anchor_side");
        if (facing.isEmpty()) {
            return null;
        }
        return Direction.func_176739_a((String)facing);
    }

    public static void setToolValue(ItemStack stack, int value, String valueName) {
        NBTHelper.getOrNewTag(stack).func_74768_a(valueName, value);
    }

    public static int getToolValue(ItemStack stack, String valueName) {
        return NBTHelper.getOrNewTag(stack).func_74762_e(valueName);
    }

    public static boolean getOverlay(ItemStack stack) {
        CompoundNBT tag = NBTHelper.getOrNewTag(stack);
        if (tag.func_74764_b("overlay")) {
            return tag.func_74767_n("overlay");
        }
        tag.func_74757_a("overlay", true);
        tag.func_74757_a("fuzzy", true);
        return true;
    }

    public static void setOverlay(ItemStack stack, boolean showOverlay) {
        NBTHelper.getOrNewTag(stack).func_74757_a("overlay", showOverlay);
    }

    public static void switchOverlay(PlayerEntity player, ItemStack stack) {
        boolean newOverlay = !GadgetDestruction.getOverlay(stack);
        GadgetDestruction.setOverlay(stack, newOverlay);
        player.func_146105_b(TooltipTranslation.GADGET_DESTROYSHOWOVERLAY.componentTranslation(newOverlay).func_150255_a(Styles.AQUA), true);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!world.field_72995_K) {
            if (!player.func_70093_af()) {
                BlockPos anchorPos = GadgetDestruction.getAnchor(stack);
                Direction anchorSide = GadgetDestruction.getAnchorSide(stack);
                if (anchorPos != null && anchorSide != null) {
                    this.clearArea(world, anchorPos, anchorSide, (ServerPlayerEntity)player, stack);
                    GadgetDestruction.clearSuccess(stack);
                    return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
                }
                BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, stack);
                if (lookingAt != null && world.func_180495_p(VectorHelper.getLookingAt(player, stack).func_216350_a()) != Blocks.field_150350_a.func_176223_P()) {
                    this.clearArea(world, lookingAt.func_216350_a(), lookingAt.func_216354_b(), (ServerPlayerEntity)player, stack);
                    GadgetDestruction.clearSuccess(stack);
                    return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
                }
                return new ActionResult(ActionResultType.FAIL, (Object)stack);
            }
        } else if (player.func_70093_af()) {
            GuiMod.DESTRUCTION.openScreen(player);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public static void clearSuccess(ItemStack stack) {
        GadgetDestruction.setAnchor(stack, null);
        GadgetDestruction.setAnchorSide(stack, null);
    }

    public static void anchorBlocks(PlayerEntity player, ItemStack stack) {
        BlockPos currentAnchor = GadgetDestruction.getAnchor(stack);
        if (currentAnchor == null) {
            BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, stack);
            if (lookingAt == null || player.field_70170_p.func_180495_p(VectorHelper.getLookingAt(player, stack).func_216350_a()) == Blocks.field_150350_a.func_176223_P()) {
                return;
            }
            currentAnchor = lookingAt.func_216350_a();
            GadgetDestruction.setAnchor(stack, currentAnchor);
            GadgetDestruction.setAnchorSide(stack, lookingAt.func_216354_b());
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + new TranslationTextComponent("message.gadget.anchorrender", new Object[0]).func_150261_e()), true);
        } else {
            GadgetDestruction.setAnchor(stack, null);
            GadgetDestruction.setAnchorSide(stack, null);
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + new TranslationTextComponent("message.gadget.anchorremove", new Object[0]).func_150261_e()), true);
        }
    }

    public static IPositionPlacementSequence getClearingPositions(World world, BlockPos pos, Direction incomingSide, PlayerEntity player, ItemStack stack) {
        BlockState stateTarget;
        ItemStack tool = GadgetDestruction.getGadget(player);
        int depth = GadgetDestruction.getToolValue(stack, "depth");
        if (tool.func_190926_b() || depth == 0 || !player.func_175142_cm()) {
            return CommonUtils.emptyPositionSequence();
        }
        Region boundary = GadgetDestruction.getClearingRegion(pos, incomingSide, player, stack);
        BlockPos startPos = GadgetDestruction.getAnchor(stack) == null ? pos : GadgetDestruction.getAnchor(stack);
        boolean fuzzy = (Boolean)Config.GADGETS.GADGET_DESTRUCTION.nonFuzzyEnabled.get() == false || AbstractGadget.getFuzzy(stack);
        BlockState blockState = stateTarget = fuzzy ? null : world.func_180495_p(pos);
        if (AbstractGadget.getConnectedArea(stack)) {
            return PlacementSequences.ConnectedSurface.create((IBlockReader)world, boundary, Function.identity(), startPos, null, (s, p) -> GadgetDestruction.isValidBlock(world, p, player, s, fuzzy));
        }
        return new SetBackedPlacementSequence(boundary.stream().filter(p -> GadgetDestruction.isValidBlock(world, p, player, stateTarget, fuzzy)).collect(Collectors.toCollection(HashSet::new)), boundary);
    }

    public static List<BlockPos> getClearingPositionsForRendering(World world, BlockPos pos, Direction incomingSide, PlayerEntity player, ItemStack stack) {
        return SortingHelper.Blocks.byDistance(GadgetDestruction.getClearingPositions(world, pos, incomingSide, player, stack), player);
    }

    public static boolean isValidBlock(World world, BlockPos voidPos, PlayerEntity player, @Nullable BlockState stateTarget, boolean fuzzy) {
        BlockState currentBlock = world.func_180495_p(voidPos);
        return GadgetDestruction.isValidBlock(world, voidPos, player, currentBlock, stateTarget, fuzzy);
    }

    public static boolean isValidBlock(World world, BlockPos voidPos, PlayerEntity player, BlockState currentBlock, @Nullable BlockState stateTarget, boolean fuzzy) {
        if (currentBlock.func_177230_c().isAir(currentBlock, (IBlockReader)world, voidPos) || currentBlock.equals((Object)BGBlocks.effectBlock.func_176223_P()) || currentBlock.func_185887_b((IBlockReader)world, voidPos) < 0.0f || !fuzzy && currentBlock != stateTarget || !world.func_175660_a(player, voidPos)) {
            return false;
        }
        TileEntity te = world.func_175625_s(voidPos);
        if (te != null && !(te instanceof ConstructionBlockTileEntity)) {
            return false;
        }
        if (!world.field_72995_K) {
            BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((IWorld)world, (BlockPos)voidPos);
            if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blockSnapshot, (Direction)Direction.UP)) {
                return false;
            }
            BlockEvent.BreakEvent e = new BlockEvent.BreakEvent(world, voidPos, currentBlock, player);
            return !MinecraftForge.EVENT_BUS.post((Event)e);
        }
        return true;
    }

    public static Region getClearingRegion(BlockPos pos, Direction side, PlayerEntity player, ItemStack stack) {
        Direction depth = side.func_176734_d();
        boolean vertical = side.func_176740_k().func_200128_b();
        Direction up = vertical ? player.func_174811_aO() : Direction.UP;
        Direction down = up.func_176734_d();
        Direction right = vertical ? up.func_176746_e() : side.func_176735_f();
        Direction left = right.func_176734_d();
        BlockPos first = pos.func_177967_a(left, GadgetDestruction.getToolValue(stack, "left")).func_177967_a(up, GadgetDestruction.getToolValue(stack, "up"));
        BlockPos second = pos.func_177967_a(right, GadgetDestruction.getToolValue(stack, "right")).func_177967_a(down, GadgetDestruction.getToolValue(stack, "down")).func_177967_a(depth, GadgetDestruction.getToolValue(stack, "depth") - 1);
        return new Region((Vec3i)first, (Vec3i)second);
    }

    public void clearArea(World world, BlockPos pos, Direction side, ServerPlayerEntity player, ItemStack stack) {
        RegionSnapshot snapshot;
        IPositionPlacementSequence positions = GadgetDestruction.getClearingPositions(world, pos, side, (PlayerEntity)player, stack);
        try {
            snapshot = RegionSnapshot.select((IWorld)world, positions).excludeAir().checkBlocks((p, state) -> this.destroyBlock(world, (BlockPos)p, player)).checkTiles((TriPredicate<BlockPos, BlockState, TileEntity>)((TriPredicate)(p, state, tile) -> state.func_177230_c() == BGBlocks.constructionBlock && tile instanceof ConstructionBlockTileEntity)).build();
        }
        catch (PaletteOverflowException e) {
            player.func_145747_a((ITextComponent)TooltipTranslation.GADGET_PALETTE_OVERFLOW.componentTranslation(new Object[0]));
            return;
        }
        WorldSave worldSave = WorldSave.getWorldSaveDestruction(world);
        worldSave.addToMap(GadgetDestruction.getUUID(stack).toString(), snapshot.serialize());
    }

    public static void undo(PlayerEntity player, ItemStack stack) {
        World world = player.field_70170_p;
        WorldSave worldSave = WorldSave.getWorldSaveDestruction(world);
        CompoundNBT serializedSnapshot = worldSave.getCompoundFromUUID(GadgetDestruction.getUUID(stack).toString());
        if (serializedSnapshot.isEmpty()) {
            return;
        }
        RegionSnapshot snapshot = RegionSnapshot.deserialize(serializedSnapshot);
        GadgetDestruction.restoreSnapshotWithBuilder(world, snapshot);
        worldSave.addToMap(GadgetDestruction.getUUID(stack).toString(), new CompoundNBT());
        worldSave.func_76185_a();
    }

    public static void restoreSnapshotWithBuilder(World world, RegionSnapshot snapshot) {
        Set pastePositions = snapshot.getTileData().stream().map(Pair::getLeft).collect(Collectors.toSet());
        int index = 0;
        for (BlockPos pos : snapshot.getPositions()) {
            ((Optional)snapshot.getBlockStates().get(index)).ifPresent(state -> EffectBlock.spawnEffectBlock(world, pos, new BlockData((BlockState)state, TileSupport.dummyTileEntityData()), EffectBlock.Mode.PLACE, pastePositions.contains(pos)));
            ++index;
        }
    }

    private boolean destroyBlock(World world, BlockPos voidPos, ServerPlayerEntity player) {
        if (world.func_175623_d(voidPos)) {
            return false;
        }
        ItemStack tool = GadgetDestruction.getGadget((PlayerEntity)player);
        if (tool.func_190926_b()) {
            return false;
        }
        if (!this.canUse(tool, (PlayerEntity)player)) {
            return false;
        }
        this.applyDamage(tool, player);
        EffectBlock.spawnEffectBlock(world, voidPos, TileSupport.createBlockData((IBlockReader)world, voidPos), EffectBlock.Mode.REMOVE, false);
        return true;
    }

    public static ItemStack getGadget(PlayerEntity player) {
        ItemStack stack = AbstractGadget.getGadget(player);
        if (!(stack.func_77973_b() instanceof GadgetDestruction)) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }
}

