/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets;

import com.direwolf20.buildinggadgets.api.building.BlockData;
import com.direwolf20.buildinggadgets.api.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.client.events.EventTooltip;
import com.direwolf20.buildinggadgets.client.gui.GuiMod;
import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlock;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.ITemplate;
import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BaseRenderer;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.CopyPasteRender;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketBindTool;
import com.direwolf20.buildinggadgets.common.network.packets.PacketBlockMap;
import com.direwolf20.buildinggadgets.common.network.packets.PacketRotateMirror;
import com.direwolf20.buildinggadgets.common.registry.objects.BGItems;
import com.direwolf20.buildinggadgets.common.tiles.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.blocks.BlockMap;
import com.direwolf20.buildinggadgets.common.util.blocks.BlockMapIntState;
import com.direwolf20.buildinggadgets.common.util.helpers.InventoryHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.tools.NetworkIO;
import com.direwolf20.buildinggadgets.common.util.tools.UniqueItem;
import com.direwolf20.buildinggadgets.common.world.WorldSave;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class GadgetCopyPaste
extends AbstractGadget
implements ITemplate {
    public GadgetCopyPaste(Item.Properties builder) {
        super(builder);
    }

    @Override
    public int getEnergyMax() {
        return (Integer)Config.GADGETS.GADGET_COPY_PASTE.maxEnergy.get();
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return (Integer)Config.GADGETS.GADGET_COPY_PASTE.energyCost.get();
    }

    @Override
    protected Supplier<BaseRenderer> createRenderFactory() {
        return CopyPasteRender::new;
    }

    private static void setAnchor(ItemStack stack, BlockPos anchorPos) {
        GadgetUtils.writePOSToNBT(stack, anchorPos, "anchor");
    }

    public static void setX(ItemStack stack, int horz) {
        GadgetUtils.writeIntToNBT(stack, horz, "X");
    }

    public static void setY(ItemStack stack, int vert) {
        GadgetUtils.writeIntToNBT(stack, vert, "Y");
    }

    public static void setZ(ItemStack stack, int depth) {
        GadgetUtils.writeIntToNBT(stack, depth, "Z");
    }

    public static int getX(ItemStack stack) {
        return GadgetUtils.getIntFromNBT(stack, "X");
    }

    public static int getY(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        return tagCompound == null || !tagCompound.func_74764_b("Y") ? 1 : tagCompound.func_74762_e("Y");
    }

    public static int getZ(ItemStack stack) {
        return GadgetUtils.getIntFromNBT(stack, "Z");
    }

    public static BlockPos getAnchor(ItemStack stack) {
        return GadgetUtils.getPOSFromNBT(stack, "anchor");
    }

    @Override
    public WorldSave getWorldSave(World world) {
        return WorldSave.getWorldSave(world);
    }

    @Override
    @Nullable
    public String getUUID(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        String uuid = tagCompound.func_74779_i("uuid");
        if (uuid.isEmpty()) {
            if (this.getStartPos(stack) == null && this.getEndPos(stack) == null) {
                return null;
            }
            UUID uid = UUID.randomUUID();
            tagCompound.func_74778_a("uuid", uid.toString());
            stack.func_77982_d(tagCompound);
            uuid = uid.toString();
        }
        return uuid;
    }

    private static void setLastBuild(ItemStack stack, BlockPos anchorPos, DimensionType dim) {
        GadgetUtils.writePOSToNBT(stack, anchorPos, "last_build_pos", dim);
    }

    private static BlockPos getLastBuild(ItemStack stack) {
        return GadgetUtils.getPOSFromNBT(stack, "last_build_pos");
    }

    @Nullable
    private static ResourceLocation getLastBuildDim(ItemStack stack) {
        return GadgetUtils.getDIMFromNBT(stack, "last_build_pos");
    }

    public static List<BlockMap> getBlockMapList(@Nullable CompoundNBT tagCompound) {
        return GadgetCopyPaste.getBlockMapList(tagCompound, GadgetUtils.getPOSFromNBT(tagCompound, "start_pos"));
    }

    private static List<BlockMap> getBlockMapList(@Nullable CompoundNBT tagCompound, BlockPos startBlock) {
        ListNBT MapIntStateTag;
        ArrayList<BlockMap> blockMap = new ArrayList<BlockMap>();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        if ((MapIntStateTag = (ListNBT)tagCompound.func_74781_a("block_palette")) == null) {
            MapIntStateTag = new ListNBT();
        }
        BlockMapIntState MapIntState = new BlockMapIntState();
        MapIntState.getIntStateMapFromNBT(MapIntStateTag);
        int[] posIntArray = tagCompound.func_74759_k("i2pos");
        int[] stateIntArray = tagCompound.func_74759_k("i2state_id");
        for (int i = 0; i < posIntArray.length; ++i) {
            int p = posIntArray[i];
            BlockPos pos = GadgetUtils.relIntToPos(startBlock, p);
            short IntState = (short)stateIntArray[i];
            blockMap.add(new BlockMap(pos, new BlockData(MapIntState.getStateFromSlot(IntState), TileSupport.dummyTileEntityData()), (byte)((p & 0xFF0000) >> 16), (byte)((p & 0xFF00) >> 8), (byte)(p & 0xFF)));
        }
        return blockMap;
    }

    public static BlockMapIntState getBlockMapIntState(@Nullable CompoundNBT tagCompound) {
        ListNBT MapIntStackTag;
        ListNBT MapIntStateTag;
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        if ((MapIntStateTag = (ListNBT)tagCompound.func_74781_a("block_palette")) == null) {
            MapIntStateTag = new ListNBT();
        }
        if ((MapIntStackTag = (ListNBT)tagCompound.func_74781_a("map_int_stack")) == null) {
            MapIntStackTag = new ListNBT();
        }
        BlockMapIntState MapIntState = new BlockMapIntState();
        MapIntState.getIntStateMapFromNBT(MapIntStateTag);
        MapIntState.getIntStackMapFromNBT(MapIntStackTag);
        return MapIntState;
    }

    private static void setToolMode(ItemStack stack, ToolMode mode) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        tagCompound.func_74778_a("mode", mode.name());
        stack.func_77982_d(tagCompound);
    }

    public static ToolMode getToolMode(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        ToolMode mode = ToolMode.Copy;
        if (tagCompound == null) {
            GadgetCopyPaste.setToolMode(stack, mode);
            return mode;
        }
        try {
            mode = ToolMode.valueOf(tagCompound.func_74779_i("mode"));
        }
        catch (Exception e) {
            GadgetCopyPaste.setToolMode(stack, mode);
        }
        return mode;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add(TooltipTranslation.GADGET_MODE.componentTranslation(new Object[]{GadgetCopyPaste.getToolMode(stack)}).func_150255_a(Styles.AQUA));
        this.addEnergyInformation(tooltip, stack);
        GadgetCopyPaste.addInformationRayTraceFluid(tooltip, stack);
        EventTooltip.addTemplatePadding(stack, tooltip);
    }

    public void setMode(ItemStack heldItem, int modeInt) {
        ToolMode mode = ToolMode.values()[modeInt];
        GadgetCopyPaste.setToolMode(heldItem, mode);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        BlockPos pos = VectorHelper.getPosLookingAt(player, stack);
        if (!world.field_72995_K) {
            if (GadgetCopyPaste.getToolMode(stack) == ToolMode.Copy) {
                if (world.func_180495_p(VectorHelper.getLookingAt(player, stack).func_216350_a()) != Blocks.field_150350_a.func_176223_P()) {
                    this.setPosOrCopy(stack, player, world, pos);
                }
            } else if (GadgetCopyPaste.getToolMode(stack) == ToolMode.Paste && !player.func_70093_af() && player instanceof ServerPlayerEntity) {
                if (GadgetCopyPaste.getAnchor(stack) == null) {
                    if (world.func_180495_p(VectorHelper.getLookingAt(player, stack).func_216350_a()) != Blocks.field_150350_a.func_176223_P()) {
                        this.buildBlockMap(world, pos, stack, (ServerPlayerEntity)player);
                    }
                } else {
                    BlockPos startPos = GadgetCopyPaste.getAnchor(stack);
                    this.buildBlockMap(world, startPos, stack, (ServerPlayerEntity)player);
                }
            }
        } else {
            if (player.func_70093_af()) {
                if (Screen.hasControlDown()) {
                    PacketHandler.sendToServer(new PacketBindTool());
                } else if (GadgetUtils.getRemoteInventory(pos, world, NetworkIO.Operation.EXTRACT) != null) {
                    return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
                }
            }
            if (GadgetCopyPaste.getToolMode(stack) == ToolMode.Copy) {
                if (player.func_70093_af() && world.func_180495_p(VectorHelper.getLookingAt(player, stack).func_216350_a()) == Blocks.field_150350_a.func_176223_P()) {
                    GuiMod.COPY.openScreen(player);
                }
            } else if (player.func_70093_af()) {
                GuiMod.PASTE.openScreen(player);
            } else {
                BaseRenderer.updateInventoryCache();
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void setPosOrCopy(ItemStack stack, PlayerEntity player, World world, BlockPos pos) {
        if (player.func_70093_af()) {
            this.setEndPos(stack, pos);
        } else {
            this.setStartPos(stack, pos);
        }
        if (this.getStartPos(stack) != null && this.getEndPos(stack) != null) {
            GadgetCopyPaste.copyBlocks(stack, player, world, this.getStartPos(stack), this.getEndPos(stack));
        }
    }

    public static void rotateOrMirrorBlocks(ItemStack stack, PlayerEntity player, PacketRotateMirror.Operation operation) {
        if (GadgetCopyPaste.getToolMode(stack) != ToolMode.Paste) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        GadgetCopyPaste tool = BGItems.gadgetCopyPaste;
        WorldSave worldSave = WorldSave.getWorldSave(player.field_70170_p);
        CompoundNBT tagCompound = worldSave.getCompoundFromUUID(tool.getUUID(stack));
        BlockPos startPos = tool.getStartPos(stack);
        if (startPos == null) {
            return;
        }
        List<BlockMap> blockMapList = GadgetCopyPaste.getBlockMapList(tagCompound);
        ArrayList<Integer> posIntArrayList = new ArrayList<Integer>();
        ArrayList<Integer> stateIntArrayList = new ArrayList<Integer>();
        BlockMapIntState blockMapIntState = new BlockMapIntState();
        for (BlockMap blockMap : blockMapList) {
            int nz;
            int nx;
            BlockPos tempPos = blockMap.pos;
            int px = tempPos.func_177958_n() - startPos.func_177958_n();
            int pz = tempPos.func_177952_p() - startPos.func_177952_p();
            BlockData alteredState = GadgetUtils.rotateOrMirrorBlock(player, operation, blockMap.state);
            if (operation == PacketRotateMirror.Operation.MIRROR) {
                if (player.func_174811_aO().func_176740_k() == Direction.Axis.X) {
                    nx = px;
                    nz = -pz;
                } else {
                    nx = -px;
                    nz = pz;
                }
            } else {
                nx = -pz;
                nz = px;
            }
            BlockPos newPos = new BlockPos(startPos.func_177958_n() + nx, tempPos.func_177956_o(), startPos.func_177952_p() + nz);
            posIntArrayList.add(GadgetUtils.relPosToInt(startPos, newPos));
            blockMapIntState.addToMap(alteredState.getState());
            stateIntArrayList.add(Integer.valueOf(blockMapIntState.findSlot(alteredState.getState()).shortValue()));
            UniqueItem uniqueItem = BlockMapIntState.blockStateToUniqueItem(alteredState, player, tempPos);
            blockMapIntState.addToStackMap(uniqueItem, alteredState.getState());
        }
        int[] posIntArray = posIntArrayList.stream().mapToInt(i -> i).toArray();
        int[] stateIntArray = stateIntArrayList.stream().mapToInt(i -> i).toArray();
        tagCompound.func_218657_a("block_palette", (INBT)blockMapIntState.putIntStateMapIntoNBT());
        tagCompound.func_218657_a("map_int_stack", (INBT)blockMapIntState.putIntStackMapIntoNBT());
        tagCompound.func_74783_a("i2pos", posIntArray);
        tagCompound.func_74783_a("i2state_id", stateIntArray);
        tool.incrementCopyCounter(stack);
        tagCompound.func_74768_a("copy_count", tool.getCopyCounter(stack));
        worldSave.addToMap(tool.getUUID(stack), tagCompound);
        worldSave.markForSaving();
        PacketHandler.sendTo(new PacketBlockMap(tagCompound), (ServerPlayerEntity)player);
        player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + new TranslationTextComponent("message.gadget." + (player.func_70093_af() ? "mirrored" : "rotated"), new Object[0]).func_150261_e()), true);
    }

    public static void copyBlocks(ItemStack stack, PlayerEntity player, World world, BlockPos startPos, BlockPos endPos) {
        GadgetCopyPaste tool;
        if (startPos != null && endPos != null && GadgetCopyPaste.findBlocks(world, startPos, endPos, stack, player, tool = BGItems.gadgetCopyPaste)) {
            tool.setStartPos(stack, startPos);
            tool.setEndPos(stack, endPos);
        }
    }

    private static boolean findBlocks(World world, BlockPos start, BlockPos end, ItemStack stack, PlayerEntity player, GadgetCopyPaste tool) {
        GadgetCopyPaste.setLastBuild(stack, null, DimensionType.field_223227_a_);
        int foundTE = 0;
        int startX = start.func_177958_n();
        int startY = start.func_177956_o();
        int startZ = start.func_177952_p();
        int endX = end.func_177958_n();
        int endY = end.func_177956_o();
        int endZ = end.func_177952_p();
        if (Math.abs(startX - endX) >= 125 || Math.abs(startY - endY) >= 125 || Math.abs(startZ - endZ) >= 125) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + new TranslationTextComponent("message.gadget.toobigarea", new Object[0]).func_150261_e()), true);
            return false;
        }
        int iStartX = startX < endX ? startX : endX;
        int iStartY = startY < endY ? startY : endY;
        int iStartZ = startZ < endZ ? startZ : endZ;
        int iEndX = startX < endX ? endX : startX;
        int iEndY = startY < endY ? endY : startY;
        int iEndZ = startZ < endZ ? endZ : startZ;
        WorldSave worldSave = WorldSave.getWorldSave(world);
        CompoundNBT tagCompound = new CompoundNBT();
        ArrayList<Integer> posIntArrayList = new ArrayList<Integer>();
        ArrayList<Integer> stateIntArrayList = new ArrayList<Integer>();
        BlockMapIntState blockMapIntState = new BlockMapIntState();
        HashMultiset itemCountMap = HashMultiset.create();
        int blockCount = 0;
        for (int x = iStartX; x <= iEndX; ++x) {
            for (int y = iStartY; y <= iEndY; ++y) {
                for (int z = iStartZ; z <= iEndZ; ++z) {
                    BlockPos tempPos = new BlockPos(x, y, z);
                    BlockState tempState = world.func_180495_p(tempPos);
                    if (tempState != Blocks.field_150350_a.func_176223_P() && !tempState.func_185904_a().func_76224_d() && Config.BLACKLIST.isAllowedBlock(tempState.func_177230_c())) {
                        UniqueItem uniqueItem;
                        BlockData assignState;
                        TileEntity te = world.func_175625_s(tempPos);
                        BlockData actualState = assignState = InventoryHelper.getSpecificStates(tempState, world, player, tempPos, stack);
                        if (te instanceof ConstructionBlockTileEntity) {
                            actualState = ((ConstructionBlockTileEntity)te).getActualBlockData();
                        }
                        if (actualState == null || (uniqueItem = BlockMapIntState.blockStateToUniqueItem(actualState, player, tempPos)).getItem() == Items.field_190931_a) continue;
                        posIntArrayList.add(GadgetUtils.relPosToInt(start, tempPos));
                        blockMapIntState.addToMap(actualState.getState());
                        stateIntArrayList.add(Integer.valueOf(blockMapIntState.findSlot(actualState.getState()).shortValue()));
                        blockMapIntState.addToStackMap(uniqueItem, actualState.getState());
                        if (++blockCount > 32768) {
                            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + new TranslationTextComponent("message.gadget.toomanyblocks", new Object[0]).func_150261_e()), true);
                            return false;
                        }
                        NonNullList drops = NonNullList.func_191196_a();
                        int neededItems = 0;
                        for (ItemStack drop : drops) {
                            if (!drop.func_77973_b().equals(uniqueItem.getItem())) continue;
                            ++neededItems;
                        }
                        if (neededItems == 0) {
                            neededItems = 1;
                        }
                        itemCountMap.add((Object)uniqueItem, neededItems);
                        continue;
                    }
                    if (world.func_175625_s(tempPos) == null || world.func_175625_s(tempPos) instanceof ConstructionBlockTileEntity) continue;
                    ++foundTE;
                }
            }
        }
        tool.setItemCountMap(stack, (Multiset)itemCountMap);
        tagCompound.func_218657_a("block_palette", (INBT)blockMapIntState.putIntStateMapIntoNBT());
        tagCompound.func_218657_a("map_int_stack", (INBT)blockMapIntState.putIntStackMapIntoNBT());
        int[] posIntArray = posIntArrayList.stream().mapToInt(i -> i).toArray();
        int[] stateIntArray = stateIntArrayList.stream().mapToInt(i -> i).toArray();
        tagCompound.func_74783_a("i2pos", posIntArray);
        tagCompound.func_74783_a("i2state_id", stateIntArray);
        tagCompound.func_218657_a("start_pos", (INBT)NBTUtil.func_186859_a((BlockPos)start));
        tagCompound.func_218657_a("end_pos", (INBT)NBTUtil.func_186859_a((BlockPos)end));
        tagCompound.func_74778_a("dim", player.field_71093_bK.toString());
        tagCompound.func_74778_a("uuid", tool.getUUID(stack));
        tool.incrementCopyCounter(stack);
        tagCompound.func_74768_a("copy_count", tool.getCopyCounter(stack));
        worldSave.addToMap(tool.getUUID(stack), tagCompound);
        worldSave.markForSaving();
        PacketHandler.sendTo(new PacketBlockMap(tagCompound), (ServerPlayerEntity)player);
        if (foundTE > 0) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + new TranslationTextComponent("message.gadget.TEinCopy", new Object[0]).func_150261_e() + ": " + foundTE), true);
        } else {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + new TranslationTextComponent("message.gadget.copied", new Object[0]).func_150261_e()), true);
        }
        return true;
    }

    private void buildBlockMap(World world, BlockPos startPos, ItemStack stack, ServerPlayerEntity player) {
        BlockPos anchorPos = GadgetCopyPaste.getAnchor(stack);
        BlockPos pos = anchorPos == null ? startPos : anchorPos;
        CompoundNBT tagCompound = WorldSave.getWorldSave(world).getCompoundFromUUID(this.getUUID(stack));
        pos = pos.func_177981_b(GadgetCopyPaste.getY(stack));
        pos = pos.func_177965_g(GadgetCopyPaste.getX(stack));
        pos = pos.func_177970_e(GadgetCopyPaste.getZ(stack));
        List<BlockMap> blockMapList = GadgetCopyPaste.getBlockMapList(tagCompound, pos);
        GadgetCopyPaste.setLastBuild(stack, pos, player.field_71093_bK);
        for (BlockMap blockMap : blockMapList) {
            this.placeBlock(world, blockMap.pos, player, blockMap.state, GadgetCopyPaste.getBlockMapIntState(tagCompound).getIntStackMap());
        }
        GadgetCopyPaste.setAnchor(stack, null);
    }

    private void placeBlock(World world, BlockPos pos, ServerPlayerEntity player, BlockData data, Map<BlockState, UniqueItem> IntStackMap) {
        BlockState testState = world.func_180495_p(pos);
        if (((Boolean)Config.GENERAL.allowOverwriteBlocks.get()).booleanValue() && !testState.func_196953_a(new BlockItemUseContext(new ItemUseContext((PlayerEntity)player, Hand.MAIN_HAND, VectorHelper.getLookingAt((PlayerEntity)player, RayTraceContext.FluidMode.NONE)))) || !((Boolean)Config.GENERAL.allowOverwriteBlocks.get()).booleanValue() && world.func_180495_p(pos).func_185904_a() != Material.field_151579_a) {
            return;
        }
        if (pos.func_177956_o() < 0 || data.getState().equals((Object)Blocks.field_150350_a.func_176223_P()) || !player.func_175142_cm()) {
            return;
        }
        ItemStack heldItem = GadgetCopyPaste.getGadget((PlayerEntity)player);
        if (heldItem.func_190926_b()) {
            return;
        }
        if (BGItems.gadgetCopyPaste.getStartPos(heldItem) == null || BGItems.gadgetCopyPaste.getEndPos(heldItem) == null) {
            return;
        }
        UniqueItem uniqueItem = IntStackMap.get(data.getState());
        if (uniqueItem == null) {
            return;
        }
        ItemStack itemStack = new ItemStack((IItemProvider)uniqueItem.getItem(), 1);
        NonNullList drops = NonNullList.func_191196_a();
        int neededItems = 0;
        for (ItemStack drop : drops) {
            if (!drop.func_77973_b().equals(itemStack.func_77973_b())) continue;
            ++neededItems;
        }
        if (neededItems == 0) {
            neededItems = 1;
        }
        if (!world.func_175660_a((PlayerEntity)player, pos)) {
            return;
        }
        BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((IWorld)world, (BlockPos)pos);
        if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blockSnapshot, (Direction)Direction.UP)) {
            return;
        }
        boolean useConstructionPaste = false;
        if (!data.getState().hasTileEntity()) {
            ItemStack constructionPaste = new ItemStack((IItemProvider)BGItems.constructionPaste);
            if (InventoryHelper.countItem(itemStack, (PlayerEntity)player, world) < neededItems) {
                if (InventoryHelper.countPaste((PlayerEntity)player) < neededItems) {
                    return;
                }
                itemStack = constructionPaste.func_77946_l();
                useConstructionPaste = true;
            }
        }
        if (!this.canUse(heldItem, (PlayerEntity)player)) {
            return;
        }
        this.applyDamage(heldItem, player);
        boolean useItemSuccess = useConstructionPaste ? InventoryHelper.usePaste((PlayerEntity)player, 1) : InventoryHelper.useItem(itemStack, (PlayerEntity)player, neededItems, world);
        if (useItemSuccess) {
            EffectBlock.spawnEffectBlock(world, pos, data, EffectBlock.Mode.PLACE, useConstructionPaste);
        }
    }

    public static void anchorBlocks(PlayerEntity player, ItemStack stack) {
        BlockPos currentAnchor = GadgetCopyPaste.getAnchor(stack);
        if (currentAnchor == null) {
            BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, stack);
            if (lookingAt == null || player.field_70170_p.func_180495_p(VectorHelper.getLookingAt(player, stack).func_216350_a()) == Blocks.field_150350_a.func_176223_P()) {
                return;
            }
            currentAnchor = lookingAt.func_216350_a();
            GadgetCopyPaste.setAnchor(stack, currentAnchor);
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + new TranslationTextComponent("message.gadget.anchorrender", new Object[0]).func_150261_e()), true);
        } else {
            GadgetCopyPaste.setAnchor(stack, null);
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + new TranslationTextComponent("message.gadget.anchorremove", new Object[0]).func_150261_e()), true);
        }
    }

    public static void undoBuild(PlayerEntity player, ItemStack heldItem) {
        CompoundNBT tagCompound = WorldSave.getWorldSave(player.field_70170_p).getCompoundFromUUID(BGItems.gadgetCopyPaste.getUUID(heldItem));
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        BlockPos startPos = GadgetCopyPaste.getLastBuild(heldItem);
        if (startPos == null) {
            return;
        }
        ItemStack silkTool = heldItem.func_77946_l();
        silkTool.func_77966_a(Enchantments.field_185306_r, 1);
        List<BlockMap> blockMapList = GadgetCopyPaste.getBlockMapList(tagCompound, startPos);
        boolean success = true;
        boolean sameDim = player.field_71093_bK == DimensionType.func_193417_a((ResourceLocation)GadgetCopyPaste.getLastBuildDim(heldItem));
        for (BlockMap blockMap : blockMapList) {
            double distance = blockMap.pos.func_177951_i((Vec3i)player.func_180425_c());
            BlockData currentBlock = TileSupport.createBlockData((IBlockReader)world, blockMap.pos);
            BlockEvent.BreakEvent e = new BlockEvent.BreakEvent(world, blockMap.pos, currentBlock.getState(), player);
            boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)e);
            if (distance < 256.0 && !cancelled && sameDim) {
                if (currentBlock.getState().func_177230_c() != blockMap.state.getState().func_177230_c() && !(currentBlock.getState().func_177230_c() instanceof ConstructionBlock) || !(currentBlock.getState().func_185887_b((IBlockReader)world, blockMap.pos) >= 0.0f)) continue;
                currentBlock.getState().func_177230_c().func_180657_a(world, player, blockMap.pos, currentBlock.getState(), world.func_175625_s(blockMap.pos), silkTool);
                EffectBlock.spawnEffectBlock(world, blockMap.pos, currentBlock, EffectBlock.Mode.REMOVE, false);
                continue;
            }
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + new TranslationTextComponent("message.gadget.undofailed", new Object[0]).func_150261_e()), true);
            success = false;
        }
        if (success) {
            GadgetCopyPaste.setLastBuild(heldItem, null, DimensionType.field_223227_a_);
        }
    }

    public static ItemStack getGadget(PlayerEntity player) {
        ItemStack stack = AbstractGadget.getGadget(player);
        if (!(stack.func_77973_b() instanceof GadgetCopyPaste)) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static enum ToolMode {
        Copy,
        Paste;

        private static ToolMode[] vals;

        public ToolMode next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        static {
            vals = ToolMode.values();
        }
    }
}

