/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.client.events.EventTooltip;
import com.direwolf20.buildinggadgets.common.items.ITemplate;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.world.WorldSave;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class Template
extends Item
implements ITemplate {
    public Template(Item.Properties builder) {
        super(builder.func_200917_a(1));
    }

    @Override
    public WorldSave getWorldSave(World world) {
        return WorldSave.getTemplateWorldSave(world);
    }

    @Override
    @Nullable
    public String getUUID(ItemStack stack) {
        String uuid;
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        if ((uuid = tagCompound.func_74779_i("uuid")).isEmpty()) {
            UUID uid = UUID.randomUUID();
            tagCompound.func_74778_a("uuid", uid.toString());
            stack.func_77982_d(tagCompound);
            uuid = uid.toString();
        }
        return uuid;
    }

    public static void setName(ItemStack stack, String name) {
        GadgetUtils.writeStringToNBT(stack, name, "template_name");
    }

    public static String getName(ItemStack stack) {
        return GadgetUtils.getStringFromNBT(stack, "template_name");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(TooltipTranslation.TEMPLATE_NAME.componentTranslation(Template.getName(stack)).func_150255_a(Styles.AQUA));
        EventTooltip.addTemplatePadding(stack, tooltip);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }
}

