/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.tools.UniqueItem;
import com.direwolf20.buildinggadgets.common.world.WorldSave;
import com.google.common.collect.Multiset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface ITemplate {
    public static ItemStack getTemplate(PlayerEntity player) {
        ItemStack mainhand = player.func_184614_ca();
        if (mainhand.func_77973_b() instanceof ITemplate) {
            return mainhand;
        }
        ItemStack offhand = player.func_184592_cb();
        if (offhand.func_77973_b() instanceof ITemplate) {
            return offhand;
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public String getUUID(ItemStack var1);

    public WorldSave getWorldSave(World var1);

    default public void setItemCountMap(ItemStack stack, Multiset<UniqueItem> tagMap) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        ListNBT tagList = GadgetUtils.itemCountToNBT(tagMap);
        tagCompound.func_218657_a("itemcountmap", (INBT)tagList);
        stack.func_77982_d(tagCompound);
    }

    @Nonnull
    default public Multiset<UniqueItem> getItemCountMap(ItemStack stack) {
        Multiset<UniqueItem> tagMap;
        CompoundNBT tagCompound = stack.func_77978_p();
        Multiset<UniqueItem> multiset = tagMap = tagCompound == null ? null : GadgetUtils.nbtToItemCount((ListNBT)tagCompound.func_74781_a("itemcountmap"));
        if (tagMap == null) {
            throw new IllegalArgumentException("ITemplate#getItemCountMap faild to retieve tag map from " + GadgetUtils.getStackErrorSuffix(stack));
        }
        return tagMap;
    }

    default public int getCopyCounter(ItemStack stack) {
        return GadgetUtils.getStackTag(stack).func_74762_e("copy_count");
    }

    default public void setCopyCounter(ItemStack stack, int counter) {
        CompoundNBT tagCompound = GadgetUtils.getStackTag(stack);
        tagCompound.func_74768_a("copy_count", counter);
        stack.func_77982_d(tagCompound);
    }

    default public void incrementCopyCounter(ItemStack stack) {
        this.setCopyCounter(stack, this.getCopyCounter(stack) + 1);
    }

    default public void setStartPos(ItemStack stack, BlockPos startPos) {
        GadgetUtils.writePOSToNBT(stack, startPos, "start_pos");
    }

    @Nullable
    default public BlockPos getStartPos(ItemStack stack) {
        return GadgetUtils.getPOSFromNBT(stack, "start_pos");
    }

    default public void setEndPos(ItemStack stack, BlockPos startPos) {
        GadgetUtils.writePOSToNBT(stack, startPos, "end_pos");
    }

    @Nullable
    default public BlockPos getEndPos(ItemStack stack) {
        return GadgetUtils.getPOSFromNBT(stack, "end_pos");
    }
}

